/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.Core;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.I_C_Order;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceBatchLine;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrderLine;
import org.compiere.model.MTax;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;

public class CalloutInvoiceBatch
extends CalloutEngine {
    public String date(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        mTab.setValue("DateAcct", value);
        this.setDocumentNo(ctx, WindowNo, mTab);
        return "";
    }

    public String bPartner(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_BPartner_ID = (Integer)value;
        if (C_BPartner_ID == null || C_BPartner_ID == 0) {
            return "";
        }
        String sql = "SELECT p.AD_Language,p.C_PaymentTerm_ID, COALESCE(p.M_PriceList_ID,g.M_PriceList_ID) AS M_PriceList_ID, p.PaymentRule,p.POReference, p.SO_Description,p.IsDiscountPrinted, p.SO_CreditLimit, p.SO_CreditLimit-p.SO_CreditUsed AS CreditAvailable, (select max(lbill.C_BPartner_Location_ID) from C_BPartner_Location lbill where p.C_BPartner_ID=lbill.C_BPartner_ID AND lbill.IsBillTo='Y' AND lbill.IsActive='Y') AS C_BPartner_Location_ID, (select max(c.AD_User_ID) from AD_User c where p.C_BPartner_ID=c.C_BPartner_ID AND c.IsActive='Y') as AD_User_ID, COALESCE(p.PO_PriceList_ID,g.PO_PriceList_ID) AS PO_PriceList_ID, p.PaymentRulePO,p.PO_PaymentTerm_ID FROM C_BPartner p INNER JOIN C_BP_Group g ON (p.C_BP_Group_ID=g.C_BP_Group_ID)WHERE p.C_BPartner_ID=? AND p.IsActive='Y'";
        boolean IsSOTrx = Env.getContext((Properties)ctx, (int)WindowNo, (String)"IsSOTrx").equals("Y");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, C_BPartner_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    double CreditLimit;
                    String cont;
                    String loc;
                    String s = rs.getString(IsSOTrx ? "PaymentRule" : "PaymentRulePO");
                    if (s != null && s.length() != 0) {
                        mTab.setValue("PaymentRule", (Object)s);
                    }
                    if (Env.getContext((Properties)ctx, (int)WindowNo, (String)"DocBaseType").endsWith("C")) {
                        s = "P";
                    }
                    Integer ii = rs.getInt(IsSOTrx ? "C_PaymentTerm_ID" : "PO_PaymentTerm_ID");
                    if (!rs.wasNull()) {
                        mTab.setValue("C_PaymentTerm_ID", (Object)ii);
                    }
                    int locID = rs.getInt("C_BPartner_Location_ID");
                    if (C_BPartner_ID.toString().equals(Env.getContext((Properties)ctx, (int)WindowNo, (int)1113, (String)"C_BPartner_ID")) && (loc = Env.getContext((Properties)ctx, (int)WindowNo, (int)1113, (String)"C_BPartner_Location_ID")).length() > 0) {
                        locID = Integer.parseInt(loc);
                    }
                    if (locID == 0) {
                        mTab.setValue("C_BPartner_Location_ID", null);
                    } else {
                        mTab.setValue("C_BPartner_Location_ID", (Object)locID);
                    }
                    int contID = rs.getInt("AD_User_ID");
                    if (C_BPartner_ID.toString().equals(Env.getContext((Properties)ctx, (int)WindowNo, (int)1113, (String)"C_BPartner_ID")) && (cont = Env.getContext((Properties)ctx, (int)WindowNo, (int)1113, (String)"AD_User_ID")).length() > 0) {
                        contID = Integer.parseInt(cont);
                    }
                    if (contID == 0) {
                        mTab.setValue("AD_User_ID", null);
                    } else {
                        mTab.setValue("AD_User_ID", (Object)contID);
                    }
                    if (IsSOTrx && (CreditLimit = rs.getDouble("SO_CreditLimit")) != 0.0) {
                        double CreditAvailable = rs.getDouble("CreditAvailable");
                        if (!rs.wasNull() && CreditAvailable < 0.0) {
                            mTab.fireDataStatusEEvent("CreditLimitOver", DisplayType.getNumberFormat((int)12).format(CreditAvailable), false);
                        }
                    }
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                String string = e.getLocalizedMessage();
                DB.close((ResultSet)rs, (Statement)pstmt);
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        this.setDocumentNo(ctx, WindowNo, mTab);
        return this.tax(ctx, WindowNo, mTab, mField, value);
    }

    public String docType(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        this.setDocumentNo(ctx, WindowNo, mTab);
        return "";
    }

    private void setDocumentNo(Properties ctx, int WindowNo, GridTab mTab) {
        String sql = "SELECT COALESCE(MAX(C_InvoiceBatchLine_ID),0) FROM C_InvoiceBatchLine WHERE C_InvoiceBatch_ID=?";
        int C_InvoiceBatch_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_InvoiceBatch_ID");
        int C_InvoiceBatchLine_ID = DB.getSQLValue(null, (String)sql, (int)C_InvoiceBatch_ID);
        if (C_InvoiceBatchLine_ID == 0) {
            return;
        }
        MInvoiceBatchLine last = new MInvoiceBatchLine(Env.getCtx(), C_InvoiceBatchLine_ID, null);
        int C_DocType_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_DocType_ID");
        int C_BPartner_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_BPartner_ID");
        if (C_DocType_ID == last.getC_DocType_ID() && C_BPartner_ID == last.getC_BPartner_ID()) {
            return;
        }
        String oldDocNo = last.getDocumentNo();
        if (oldDocNo == null) {
            return;
        }
        int docNo = 0;
        try {
            docNo = Integer.parseInt(oldDocNo);
        }
        catch (Exception exception) {}
        if (docNo == 0) {
            return;
        }
        String newDocNo = String.valueOf(docNo + 1);
        mTab.setValue("DocumentNo", (Object)newDocNo);
    }

    public String charge(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_Charge_ID = (Integer)value;
        if (C_Charge_ID == null || C_Charge_ID == 0) {
            return "";
        }
        String sql = "SELECT ChargeAmt FROM C_Charge WHERE C_Charge_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, C_Charge_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    mTab.setValue("PriceEntered", (Object)rs.getBigDecimal(1));
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                String string = e.getLocalizedMessage();
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return this.tax(ctx, WindowNo, mTab, mField, value);
    }

    public String tax(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        String column = mField.getColumnName();
        if (value == null) {
            return "";
        }
        int C_Charge_ID = 0;
        C_Charge_ID = column.equals("C_Charge_ID") ? (Integer)value : Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_Charge_ID");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("C_Charge_ID=" + C_Charge_ID);
        }
        if (C_Charge_ID == 0) {
            return this.amt(ctx, WindowNo, mTab, mField, value);
        }
        int C_BPartner_Location_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_BPartner_Location_ID");
        if (C_BPartner_Location_ID == 0) {
            return this.amt(ctx, WindowNo, mTab, mField, value);
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("BP_Location=" + C_BPartner_Location_ID);
        }
        Timestamp billDate = Env.getContextAsDate((Properties)ctx, (int)WindowNo, (String)"DateInvoiced");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Bill Date=" + String.valueOf(billDate));
        }
        Timestamp shipDate = billDate;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Ship Date=" + String.valueOf(shipDate));
        }
        int AD_Org_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"AD_Org_ID");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Org=" + AD_Org_ID);
        }
        int M_Warehouse_ID = Env.getContextAsInt((Properties)ctx, (String)"#M_Warehouse_ID");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Warehouse=" + M_Warehouse_ID);
        }
        String deliveryViaRule = this.getLineDeliveryViaRule(ctx, WindowNo, mTab);
        int dropshipLocationId = this.getDropShipLocationId(ctx, WindowNo, mTab);
        int C_Tax_ID = Core.getTaxLookup().get(ctx, 0, C_Charge_ID, billDate, shipDate, AD_Org_ID, M_Warehouse_ID, C_BPartner_Location_ID, C_BPartner_Location_ID, dropshipLocationId, Env.getContext((Properties)ctx, (int)WindowNo, (String)"IsSOTrx").equals("Y"), deliveryViaRule, null);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Tax ID=" + C_Tax_ID);
        }
        if (C_Tax_ID == 0) {
            mTab.fireDataStatusEEvent(CLogger.retrieveError());
        } else {
            mTab.setValue("C_Tax_ID", (Object)C_Tax_ID);
        }
        return this.amt(ctx, WindowNo, mTab, mField, value);
    }

    private String getLineDeliveryViaRule(Properties ctx, int windowNo, GridTab mTab) {
        MInvoice invoice;
        I_C_Order order;
        int C_Invoice_ID;
        int C_InvoiceLine_ID;
        if (mTab.getValue("C_InvoiceLine_ID") != null && (C_InvoiceLine_ID = ((Integer)mTab.getValue("C_InvoiceLine_ID")).intValue()) > 0) {
            MInvoiceLine invoiceLine = new MInvoiceLine(ctx, C_InvoiceLine_ID, null);
            int C_OrderLine_ID = invoiceLine.getC_OrderLine_ID();
            if (C_OrderLine_ID > 0) {
                MOrderLine orderLine = new MOrderLine(ctx, C_OrderLine_ID, null);
                return orderLine.getParent().getDeliveryViaRule();
            }
            int M_InOutLine_ID = invoiceLine.getM_InOutLine_ID();
            if (M_InOutLine_ID > 0) {
                MInOutLine ioLine = new MInOutLine(ctx, M_InOutLine_ID, null);
                return ioLine.getParent().getDeliveryViaRule();
            }
        }
        if (mTab.getValue("C_Invoice_ID") != null && (C_Invoice_ID = ((Integer)mTab.getValue("C_Invoice_ID")).intValue()) > 0 && (order = (invoice = new MInvoice(ctx, C_Invoice_ID, null)).getC_Order()) != null) {
            return order.getDeliveryViaRule();
        }
        return null;
    }

    private int getDropShipLocationId(Properties ctx, int windowNo, GridTab mTab) {
        MInvoice invoice;
        I_C_Order order;
        int C_Invoice_ID;
        MInvoiceLine invoiceLine;
        int C_OrderLine_ID;
        int C_InvoiceLine_ID;
        if (mTab.getValue("C_InvoiceLine_ID") != null && (C_InvoiceLine_ID = ((Integer)mTab.getValue("C_InvoiceLine_ID")).intValue()) > 0 && (C_OrderLine_ID = (invoiceLine = new MInvoiceLine(ctx, C_InvoiceLine_ID, null)).getC_OrderLine_ID()) > 0) {
            MOrderLine orderLine = new MOrderLine(ctx, C_OrderLine_ID, null);
            return orderLine.getParent().getDropShip_Location_ID();
        }
        if (mTab.getValue("C_Invoice_ID") != null && (C_Invoice_ID = ((Integer)mTab.getValue("C_Invoice_ID")).intValue()) > 0 && (order = (invoice = new MInvoice(ctx, C_Invoice_ID, null)).getC_Order()) != null) {
            return order.getDropShip_Location_ID();
        }
        return -1;
    }

    public String amt(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal LineNetAmt;
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        int StdPrecision = 2;
        BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
        BigDecimal PriceEntered = (BigDecimal)mTab.getValue("PriceEntered");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("QtyEntered=" + String.valueOf(QtyEntered) + ", PriceEntered=" + String.valueOf(PriceEntered));
        }
        if (QtyEntered == null) {
            QtyEntered = Env.ZERO;
        }
        if (PriceEntered == null) {
            PriceEntered = Env.ZERO;
        }
        if ((LineNetAmt = QtyEntered.multiply(PriceEntered)).scale() > StdPrecision) {
            LineNetAmt = LineNetAmt.setScale(StdPrecision, RoundingMode.HALF_UP);
        }
        boolean IsTaxIncluded = "Y".equals(Env.getContext((Properties)Env.getCtx(), (int)WindowNo, (String)"IsTaxIncluded"));
        BigDecimal TaxAmt = null;
        if (mField.getColumnName().equals("TaxAmt")) {
            TaxAmt = (BigDecimal)mTab.getValue("TaxAmt");
        } else {
            Integer taxID = (Integer)mTab.getValue("C_Tax_ID");
            if (taxID != null) {
                int C_Tax_ID = taxID;
                MTax tax = new MTax(ctx, C_Tax_ID, null);
                TaxAmt = tax.calculateTax(LineNetAmt, IsTaxIncluded, StdPrecision);
                mTab.setValue("TaxAmt", (Object)TaxAmt);
            }
        }
        if (TaxAmt == null) {
            TaxAmt = BigDecimal.ZERO;
        }
        if (IsTaxIncluded) {
            mTab.setValue("LineTotalAmt", (Object)LineNetAmt);
            mTab.setValue("LineNetAmt", (Object)LineNetAmt.subtract(TaxAmt));
        } else {
            mTab.setValue("LineNetAmt", (Object)LineNetAmt);
            mTab.setValue("LineTotalAmt", (Object)LineNetAmt.add(TaxAmt));
        }
        return "";
    }
}

