/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.scheduler;

import java.util.Properties;
import org.adempiere.base.Core;
import org.adempiere.util.Callback;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.editor.IEditorConfiguration;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.window.Dialog;
import org.compiere.model.GridField;
import org.compiere.model.MScheduler;
import org.compiere.model.StateChangeEvent;
import org.compiere.model.StateChangeListener;
import org.compiere.server.AdempiereServerMgr;
import org.compiere.server.IServerManager;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.idempiere.distributed.IClusterService;
import org.idempiere.server.cluster.ClusterServerMgr;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.Clients;

public class SchedulerStateEditor
extends WEditor {
    private static final String ON_START_SCHEDULER_EVENT = "onStartScheduler";
    private static final String ON_STOP_SCHEDULER_EVENT = "onStopScheduler";
    private static final String ON_ADD_SCHEDULER_EVENT = "onAddScheduler";
    private int schedulerState;

    public SchedulerStateEditor(GridField gridField) {
        this(gridField, false, null);
    }

    public SchedulerStateEditor(GridField gridField, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        this(gridField, -1, tableEditor, editorConfiguration);
    }

    public SchedulerStateEditor(GridField gridField, int rowIndex) {
        this(gridField, rowIndex, false, null);
    }

    public SchedulerStateEditor(GridField gridField, int rowIndex, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        super((Component)new Button(), gridField, rowIndex, tableEditor, editorConfiguration);
        Button btn = this.getComponent();
        btn.addEventListener(ON_START_SCHEDULER_EVENT, evt -> {
            int id = this.getAD_Scheduler_ID();
            if (id > 0) {
                MScheduler model = new MScheduler(Env.getCtx(), id, null);
                IServerManager serverMgr = this.getServerMgr();
                if (serverMgr != null) {
                    String error = serverMgr.start(model.getServerID());
                    if (error == null) {
                        Dialog.info(0, "SchedulerStartSuccess");
                    } else {
                        Dialog.error(0, "SchedulerStartFail", error);
                    }
                    this.getComponent().setLabel(this.getDisplay());
                }
                Clients.clearBusy();
            }
        });
        btn.addEventListener(ON_STOP_SCHEDULER_EVENT, evt -> {
            int id = this.getAD_Scheduler_ID();
            if (id > 0) {
                MScheduler model = new MScheduler(Env.getCtx(), id, null);
                IServerManager serverMgr = this.getServerMgr();
                if (serverMgr != null) {
                    String error = serverMgr.stop(model.getServerID());
                    if (error == null) {
                        Dialog.info(0, "SchedulerStopSuccess");
                    } else {
                        Dialog.error(0, "SchedulerStopFail", error);
                    }
                    this.getComponent().setLabel(this.getDisplay());
                }
                Clients.clearBusy();
            }
        });
        btn.addEventListener(ON_ADD_SCHEDULER_EVENT, evt -> {
            int id = this.getAD_Scheduler_ID();
            if (id > 0) {
                MScheduler model = new MScheduler(Env.getCtx(), id, null);
                IServerManager serverMgr = this.getServerMgr();
                if (serverMgr != null) {
                    String error = serverMgr.addScheduler(model);
                    if (error == null) {
                        if (serverMgr.getServerInstance(model.getServerID()) != null) {
                            Dialog.info(0, "SchedulerAddAndStartSuccess");
                        } else {
                            Dialog.error(0, "SchedulerAddAndStartFail", "Not accepted by any server node, please check the scheduler's schedule setting");
                        }
                    } else {
                        Dialog.error(0, "SchedulerAddAndStartFail", error);
                    }
                    this.getComponent().setLabel(this.getDisplay());
                }
                Clients.clearBusy();
            }
        });
        this.getComponent().addEventListener("onClick", this);
        this.getComponent().setLabel(this.getDisplay());
        if (gridField.getGridTab() != null) {
            gridField.getGridTab().addStateChangeListener(new StateChangeListener(){

                public void stateChange(StateChangeEvent event) {
                    if (event.getEventType() == 4 || event.getEventType() == 5) {
                        SchedulerStateEditor.this.getComponent().setLabel(SchedulerStateEditor.this.getDisplay());
                    }
                }
            });
        }
    }

    private int getAD_Scheduler_ID() {
        return this.gridTab != null ? this.gridTab.getRecord_ID() : 0;
    }

    public void onEvent(Event event) throws Exception {
        if (event.getName().equals("onClick")) {
            if (this.schedulerState == 0) {
                ADWindow adwindow = ADWindow.findADWindow((Component)this.getComponent());
                if (adwindow != null) {
                    if (this.gridTab != null && (this.gridTab.isNew() || this.gridTab.needSave(false, false))) {
                        adwindow.getADWindowContent().onSave(true, false, new Callback<Boolean>(){

                            public void onCallback(Boolean result) {
                                if (result.booleanValue()) {
                                    int id = SchedulerStateEditor.this.getAD_Scheduler_ID();
                                    if (id <= 0) {
                                        return;
                                    }
                                    SchedulerStateEditor.this.schedule();
                                }
                            }
                        });
                    } else {
                        this.schedule();
                    }
                }
            } else if (this.schedulerState == 1) {
                ADWindow adwindow = ADWindow.findADWindow((Component)this.getComponent());
                if (adwindow != null) {
                    if (this.gridTab != null && (this.gridTab.isNew() || this.gridTab.needSave(false, false))) {
                        adwindow.getADWindowContent().onSave(true, false, new Callback<Boolean>(){

                            public void onCallback(Boolean result) {
                                if (result.booleanValue()) {
                                    SchedulerStateEditor.this.stop();
                                }
                            }
                        });
                    } else {
                        this.stop();
                    }
                }
            } else if (this.schedulerState == 2) {
                ADWindow adwindow = ADWindow.findADWindow((Component)this.getComponent());
                if (adwindow != null) {
                    if (this.gridTab != null && (this.gridTab.isNew() || this.gridTab.needSave(false, false))) {
                        adwindow.getADWindowContent().onSave(true, false, new Callback<Boolean>(){

                            public void onCallback(Boolean result) {
                                if (result.booleanValue()) {
                                    SchedulerStateEditor.this.start();
                                }
                            }
                        });
                    } else {
                        this.start();
                    }
                }
            } else {
                Dialog.error(0, "CantReadCurrentSchedulerState");
            }
        }
    }

    private void schedule() {
        int id = this.getAD_Scheduler_ID();
        if (id <= 0) {
            return;
        }
        Dialog.ask(0, "SchedulerAddAndStartPrompt", new Callback<Boolean>(){

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    Clients.showBusy((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Processing"));
                    Events.echoEvent((String)SchedulerStateEditor.ON_ADD_SCHEDULER_EVENT, (Component)SchedulerStateEditor.this.getComponent(), null);
                }
            }
        });
    }

    private void stop() {
        int id = this.getAD_Scheduler_ID();
        if (id <= 0) {
            return;
        }
        Dialog.ask(0, "SchedulerStopPrompt", new Callback<Boolean>(){

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    Clients.showBusy((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Processing"));
                    Events.echoEvent((String)SchedulerStateEditor.ON_STOP_SCHEDULER_EVENT, (Component)SchedulerStateEditor.this.getComponent(), null);
                }
            }
        });
    }

    private void start() {
        int id = this.getAD_Scheduler_ID();
        if (id <= 0) {
            return;
        }
        Dialog.ask(0, "SchedulerStartPrompt", new Callback<Boolean>(){

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    Clients.showBusy((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Processing"));
                    Events.echoEvent((String)SchedulerStateEditor.ON_START_SCHEDULER_EVENT, (Component)SchedulerStateEditor.this.getComponent(), null);
                }
            }
        });
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        GridField descriptionField;
        GridField gridField = descriptionField = this.gridTab != null ? this.gridTab.getField("Description") : null;
        if (descriptionField != null) {
            this.getComponent().setEnabled(descriptionField.isEditable(true));
        } else {
            this.getComponent().setEnabled(readWrite);
        }
    }

    @Override
    public boolean isReadWrite() {
        return this.getComponent().isEnabled();
    }

    @Override
    public void setValue(Object value) {
        this.getComponent().setLabel(this.getDisplay());
    }

    @Override
    public Object getValue() {
        return this.getAD_Scheduler_ID();
    }

    @Override
    public String getDisplay() {
        this.schedulerState = 0;
        MScheduler scheduler = new MScheduler(Env.getCtx(), this.getAD_Scheduler_ID(), null);
        IServerManager serverMgr = this.getServerMgr();
        this.schedulerState = serverMgr != null ? serverMgr.getServerStatus(scheduler.getServerID()) : -1;
        String label = null;
        label = this.schedulerState == 0 ? Msg.getMsg((Properties)Env.getCtx(), (String)"SchedulerNotSchedule") : (this.schedulerState == 1 ? Msg.getMsg((Properties)Env.getCtx(), (String)"SchedulerStarted") : (this.schedulerState == 2 ? Msg.getMsg((Properties)Env.getCtx(), (String)"SchedulerStopped") : "-"));
        return label;
    }

    public Button getComponent() {
        return (Button)this.component;
    }

    @Override
    public boolean isSearchable() {
        return false;
    }

    private IServerManager getServerMgr() {
        Object serverMgr = null;
        IClusterService service = Core.getClusterService();
        serverMgr = service != null ? ClusterServerMgr.getInstance() : AdempiereServerMgr.get((boolean)false);
        return serverMgr;
    }
}

