/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.ui.zk.report;

import com.google.common.net.MediaType;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.adempiere.base.Core;
import org.adempiere.webui.window.ZkReportViewer;
import org.compiere.print.ReportEngine;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.idempiere.print.renderer.IReportRenderer;
import org.idempiere.print.renderer.IReportRendererConfiguration;
import org.idempiere.print.renderer.XMLReportRendererConfiguration;
import org.idempiere.ui.zk.report.IReportViewerRenderer;
import org.osgi.service.component.annotations.Component;
import org.zkoss.util.media.AMedia;

@Component(service={IReportViewerRenderer.class}, immediate=true)
public class XMLReportViewerRenderer
implements IReportViewerRenderer {
    @Override
    public String getId() {
        return "XML";
    }

    @Override
    public String getExportLabel() {
        return Msg.getMsg((Properties)Env.getCtx(), (String)"FileXML");
    }

    @Override
    public String getContentType() {
        return MediaType.XML_UTF_8.toString();
    }

    @Override
    public String getFileExtension() {
        return "xml";
    }

    @Override
    public boolean isExport() {
        return true;
    }

    @Override
    public boolean isPreview(boolean roleCanExport) {
        return false;
    }

    @Override
    public AMedia renderMedia(ZkReportViewer viewer, boolean export) {
        StringWriter sw = new StringWriter();
        ReportEngine reportEngine = viewer.getReportEngine();
        IReportRenderer renderer = Core.getReportRenderer((String)this.getId());
        XMLReportRendererConfiguration config = new XMLReportRendererConfiguration().setOutputWriter((Writer)sw);
        renderer.renderReport(reportEngine, (IReportRendererConfiguration)config);
        String data = sw.getBuffer().toString();
        return new AMedia(reportEngine.getName() + "." + this.getFileExtension(), this.getFileExtension(), this.getContentType(), data);
    }
}

