/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.X_C_InvoiceSchedule;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MInvoiceSchedule
extends X_C_InvoiceSchedule
implements ImmutablePOSupport {
    private static final long serialVersionUID = -2480759794244343907L;
    private static ImmutableIntPOCache<Integer, MInvoiceSchedule> s_cache = new ImmutableIntPOCache("C_InvoiceSchedule", 5);

    public static MInvoiceSchedule get(int C_InvoiceSchedule_ID, String trxName) {
        return MInvoiceSchedule.get(Env.getCtx(), C_InvoiceSchedule_ID, trxName);
    }

    public static MInvoiceSchedule get(int C_InvoiceSchedule_ID) {
        return MInvoiceSchedule.get(C_InvoiceSchedule_ID, null);
    }

    public static MInvoiceSchedule get(Properties ctx, int C_InvoiceSchedule_ID, String trxName) {
        Integer key = C_InvoiceSchedule_ID;
        MInvoiceSchedule retValue = s_cache.get(ctx, key, e -> new MInvoiceSchedule(ctx, (MInvoiceSchedule)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MInvoiceSchedule(Env.getCtx(), C_InvoiceSchedule_ID, trxName);
        if (retValue.get_ID() == C_InvoiceSchedule_ID) {
            s_cache.put(key, retValue, e -> new MInvoiceSchedule(Env.getCtx(), (MInvoiceSchedule)e));
            return retValue;
        }
        return null;
    }

    public MInvoiceSchedule(Properties ctx, String C_InvoiceSchedule_UU, String trxName) {
        super(ctx, C_InvoiceSchedule_UU, trxName);
    }

    public MInvoiceSchedule(Properties ctx, int C_InvoiceSchedule_ID, String trxName) {
        super(ctx, C_InvoiceSchedule_ID, trxName);
    }

    public MInvoiceSchedule(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInvoiceSchedule(MInvoiceSchedule copy) {
        this(Env.getCtx(), copy);
    }

    public MInvoiceSchedule(Properties ctx, MInvoiceSchedule copy) {
        this(ctx, copy, null);
    }

    public MInvoiceSchedule(Properties ctx, MInvoiceSchedule copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    @Deprecated
    public boolean canInvoice(Timestamp xDate, BigDecimal orderAmt) {
        if (this.isAmount() && this.getAmt() != null && orderAmt != null && orderAmt.compareTo(this.getAmt()) >= 0) {
            return true;
        }
        return this.canInvoice(xDate);
    }

    public boolean canInvoice(Timestamp xDate) {
        if ("D".equals(this.getInvoiceFrequency())) {
            return true;
        }
        xDate = TimeUtil.getDay(xDate);
        Calendar today = TimeUtil.getToday();
        if ("W".equals(this.getInvoiceFrequency())) {
            Calendar cutoff = TimeUtil.getToday();
            cutoff.set(7, this.getCalendarDay(this.getInvoiceWeekDayCutoff()));
            if (cutoff.after(today)) {
                cutoff.add(6, -7);
            }
            Timestamp cutoffDate = new Timestamp(cutoff.getTimeInMillis());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("canInvoice - Date=" + String.valueOf(xDate) + " > Cutoff=" + String.valueOf(cutoffDate) + " - " + xDate.after(cutoffDate));
            }
            if (xDate.after(cutoffDate)) {
                return false;
            }
            Calendar invoice = TimeUtil.getToday();
            invoice.set(7, this.getCalendarDay(this.getInvoiceWeekDay()));
            if (invoice.after(today)) {
                invoice.add(6, -7);
            }
            Timestamp invoiceDate = new Timestamp(invoice.getTimeInMillis());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("canInvoice - Date=" + String.valueOf(xDate) + " > Invoice=" + String.valueOf(invoiceDate) + " - " + xDate.after(invoiceDate));
            }
            return !xDate.after(invoiceDate);
        }
        if ("M".equals(this.getInvoiceFrequency()) || "T".equals(this.getInvoiceFrequency())) {
            if (this.getInvoiceDayCutoff() > 0) {
                Calendar cutoff = TimeUtil.getToday();
                cutoff.set(5, this.getInvoiceDayCutoff());
                if (cutoff.after(today)) {
                    cutoff.add(2, -1);
                }
                Timestamp cutoffDate = new Timestamp(cutoff.getTimeInMillis());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("canInvoice - Date=" + String.valueOf(xDate) + " > Cutoff=" + String.valueOf(cutoffDate) + " - " + xDate.after(cutoffDate));
                }
                if (xDate.after(cutoffDate)) {
                    return false;
                }
            }
            Calendar invoice = TimeUtil.getToday();
            invoice.set(5, this.getInvoiceDay());
            if (invoice.after(today)) {
                invoice.add(2, -1);
            }
            Timestamp invoiceDate = new Timestamp(invoice.getTimeInMillis());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("canInvoice - Date=" + String.valueOf(xDate) + " > Invoice=" + String.valueOf(invoiceDate) + " - " + xDate.after(invoiceDate));
            }
            return !xDate.after(invoiceDate);
        }
        if ("T".equals(this.getInvoiceFrequency())) {
            Timestamp invoiceDate;
            if (this.getInvoiceDayCutoff() > 0) {
                Timestamp cutoffDate;
                Calendar cutoff = TimeUtil.getToday();
                cutoff.set(5, this.getInvoiceDayCutoff() + 15);
                if (cutoff.after(today)) {
                    cutoff.add(2, -1);
                }
                if (xDate.after(cutoffDate = new Timestamp(cutoff.getTimeInMillis()))) {
                    return false;
                }
            }
            Calendar invoice = TimeUtil.getToday();
            invoice.set(5, this.getInvoiceDay() + 15);
            if (invoice.after(today)) {
                invoice.add(2, -1);
            }
            return !xDate.after(invoiceDate = new Timestamp(invoice.getTimeInMillis()));
        }
        return false;
    }

    private int getCalendarDay(String day) {
        if ("5".equals(day)) {
            return 6;
        }
        if ("6".equals(day)) {
            return 7;
        }
        if ("7".equals(day)) {
            return 1;
        }
        if ("1".equals(day)) {
            return 2;
        }
        if ("2".equals(day)) {
            return 3;
        }
        if ("3".equals(day)) {
            return 4;
        }
        return 5;
    }

    @Override
    public MInvoiceSchedule markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

