/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.base;

import java.util.Arrays;
import java.util.Properties;
import org.compiere.model.MDocumentStatus;
import org.compiere.model.MDocumentStatusAccess;
import org.compiere.util.Env;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DocumentStatusTest
extends AbstractTestCase {
    @Test
    public void testDocumentStatusVisibility() {
        MDocumentStatus invoiceDS = new MDocumentStatus(Env.getCtx(), 0, this.getTrxName());
        invoiceDS.setName("Invoice Document Status Unit Test");
        invoiceDS.setEntityType("D");
        invoiceDS.setAD_Table_ID(318);
        invoiceDS.setAD_Window_ID(167);
        invoiceDS.setSeqNo(10);
        invoiceDS.saveEx();
        MDocumentStatusAccess invoiceDSAccess = new MDocumentStatusAccess(Env.getCtx(), 0, this.getTrxName());
        invoiceDSAccess.setPA_DocumentStatus_ID(invoiceDS.get_ID());
        invoiceDSAccess.setAD_User_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
        invoiceDSAccess.setAD_Role_ID(DictionaryIDs.AD_Role.GARDEN_WORLD_ADMIN.id);
        invoiceDSAccess.saveEx();
        MDocumentStatus noticeDS = new MDocumentStatus(Env.getCtx(), 0, this.getTrxName());
        noticeDS.setName("Notice Document Status Unit Test");
        noticeDS.setEntityType("D");
        noticeDS.setAD_Table_ID(259);
        noticeDS.setAD_Window_ID(193);
        noticeDS.setSeqNo(20);
        noticeDS.saveEx();
        MDocumentStatus requestDS = new MDocumentStatus(Env.getCtx(), 0, this.getTrxName());
        requestDS.setName("Request Document Status Unit Test");
        requestDS.setEntityType("D");
        requestDS.setAD_Table_ID(318);
        requestDS.setAD_Window_ID(201);
        requestDS.setSeqNo(30);
        requestDS.saveEx();
        MDocumentStatusAccess requestDSAccess = new MDocumentStatusAccess(Env.getCtx(), 0, this.getTrxName());
        requestDSAccess.setPA_DocumentStatus_ID(requestDS.get_ID());
        requestDSAccess.setAD_Role_ID(DictionaryIDs.AD_Role.GARDEN_WORLD_USER.id);
        requestDSAccess.saveEx();
        MDocumentStatus WorkflowActivitiesDS = new MDocumentStatus(Env.getCtx(), 0, this.getTrxName());
        WorkflowActivitiesDS.setName("Workflow Activities Document Status Unit Test");
        WorkflowActivitiesDS.setEntityType("D");
        WorkflowActivitiesDS.setAD_Table_ID(318);
        WorkflowActivitiesDS.setAD_Window_ID(298);
        WorkflowActivitiesDS.setSeqNo(40);
        WorkflowActivitiesDS.saveEx();
        MDocumentStatusAccess WorkflowActivitiesDSAccess = new MDocumentStatusAccess(Env.getCtx(), 0, this.getTrxName());
        WorkflowActivitiesDSAccess.setPA_DocumentStatus_ID(WorkflowActivitiesDS.get_ID());
        WorkflowActivitiesDSAccess.setAD_User_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
        WorkflowActivitiesDSAccess.saveEx();
        MDocumentStatus[] documentStatusIndicators = MDocumentStatus.getDocumentStatusIndicators((Properties)Env.getCtx(), (int)DictionaryIDs.AD_User.GARDEN_ADMIN.id, (int)DictionaryIDs.AD_Role.GARDEN_WORLD_ADMIN.id, (String)this.getTrxName());
        Assertions.assertTrue((boolean)Arrays.asList(documentStatusIndicators).contains(invoiceDS), (String)"Either User or Role Assignment matching");
        Assertions.assertTrue((boolean)Arrays.asList(documentStatusIndicators).contains(noticeDS), (String)"No permission assigned, should visible to every one");
        Assertions.assertFalse((boolean)Arrays.asList(documentStatusIndicators).contains(requestDS), (String)"When Role not matching, Should not Visible");
        Assertions.assertTrue((boolean)Arrays.asList(documentStatusIndicators).contains(WorkflowActivitiesDS), (String)"User is assigned, Should Visible");
        documentStatusIndicators = MDocumentStatus.getDocumentStatusIndicators((Properties)Env.getCtx(), (int)DictionaryIDs.AD_User.GARDEN_ADMIN.id, (int)DictionaryIDs.AD_Role.GARDEN_WORLD_USER.id, (String)this.getTrxName());
        Assertions.assertFalse((boolean)Arrays.asList(documentStatusIndicators).contains(invoiceDS), (String)"User Assignment Match but role do not");
        Assertions.assertTrue((boolean)Arrays.asList(documentStatusIndicators).contains(noticeDS), (String)"No permission assigned, should visible to every one");
        Assertions.assertTrue((boolean)Arrays.asList(documentStatusIndicators).contains(requestDS), (String)"When Role matching, Should  Visible");
        Assertions.assertTrue((boolean)Arrays.asList(documentStatusIndicators).contains(WorkflowActivitiesDS), (String)"User is assigned, Should Visible");
        documentStatusIndicators = MDocumentStatus.getDocumentStatusIndicators((Properties)Env.getCtx(), (int)DictionaryIDs.AD_User.GARDEN_USER.id, (int)DictionaryIDs.AD_Role.GARDEN_WORLD_USER.id, (String)this.getTrxName());
        Assertions.assertFalse((boolean)Arrays.asList(documentStatusIndicators).contains(invoiceDS), (String)"Invoice Document Status Not Visible For User Garden Admin and Role GardenWorld User");
        Assertions.assertTrue((boolean)Arrays.asList(documentStatusIndicators).contains(noticeDS), (String)"No permission assigned, should visible to every one");
        Assertions.assertTrue((boolean)Arrays.asList(documentStatusIndicators).contains(requestDS), (String)"When Role not matching, Should not Visible");
        Assertions.assertFalse((boolean)Arrays.asList(documentStatusIndicators).contains(WorkflowActivitiesDS), (String)"User is assigned, Should not Visible");
        documentStatusIndicators = MDocumentStatus.getDocumentStatusIndicators((Properties)Env.getCtx(), (int)100, (int)DictionaryIDs.AD_Role.GARDEN_WORLD_ADMIN_NOT_ADVANCED.id, (String)this.getTrxName());
        Assertions.assertFalse((boolean)Arrays.asList(documentStatusIndicators).contains(invoiceDS), (String)"Neither User or Role Assignment match, Should not visible");
        Assertions.assertTrue((boolean)Arrays.asList(documentStatusIndicators).contains(noticeDS), (String)"No permission assigned, should visible to every one");
        Assertions.assertFalse((boolean)Arrays.asList(documentStatusIndicators).contains(requestDS), (String)"Role assignment not matching, Should not visible");
        Assertions.assertFalse((boolean)Arrays.asList(documentStatusIndicators).contains(WorkflowActivitiesDS), (String)"User assignment not visible, Should not Visible");
    }
}

