/**
 * API endpoint to save push subscription
 * POST /api/push/subscribe
 */

import { savePushSubscription } from '../../utils/pushDb'

export default defineEventHandler(async (event) => {
  try {
    const body = await readBody(event)
    const { subscription } = body

    if (!subscription || !subscription.endpoint || !subscription.keys) {
      return {
        success: false,
        error: 'Invalid subscription data'
      }
    }

    // Extract user info from JWT token
    const token = await getTokenHelper(event)
    let userId: number
    let roleId: number

    try {
      const tokenPayload = JSON.parse(Buffer.from(token.split('.')[1], 'base64').toString())
      userId = tokenPayload.AD_User_ID
      roleId = tokenPayload.AD_Role_ID

      if (!userId || !roleId) {
        throw new Error('User ID or Role ID not found in token')
      }
    } catch (error: any) {
      console.error('[Push Subscribe] Error extracting token:', error.message)
      return {
        success: false,
        error: 'Authentication error'
      }
    }

    // Get user agent
    const userAgent = getHeader(event, 'user-agent') || undefined

    // Save subscription to database
    savePushSubscription(userId, roleId, subscription, userAgent)

    console.log('[Push Subscribe] ✅ Subscription saved for user', userId, 'role', roleId)

    return {
      success: true,
      message: 'Push subscription saved successfully'
    }
  } catch (error: any) {
    console.error('[Push Subscribe] ❌ Error:', error.message)
    return {
      success: false,
      error: error.message
    }
  }
})
