import refreshTokenHelper from "../../../utils/refreshTokenHelper"
import getTokenHelper from "../../../utils/getTokenHelper"
import forceLogoutHelper from "../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../utils/errorHandlingHelper"
import fetchHelper from "../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const config = useRuntimeConfig()
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  let newObjValue = {}
  if(body.assetGroupId) {
    newObjValue = {...newObjValue, A_Asset_Group_ID: {
      id: body.assetGroupId,
      tableName: 'A_Asset_Group'
    }}
  }
  if(body.printColorId) {
    newObjValue = {...newObjValue, AD_PrintColor_ID: {
      id: body.printColorId,
      tableName: 'AD_PrintColor'
    }}
  }
  if(body.mMPolicyId) {
    newObjValue = {...newObjValue, MMPolicy: {
      id: body.mMPolicyId
    }}
  }
  if(body.parentProductCategoryId) {
    newObjValue = {...newObjValue, M_Product_Category_Parent_ID: {
      id: body.parentProductCategoryId,
      tableName: 'M_Product_Category'
    }}
  }

  const res: any = await fetchHelper(event, 'models/m_product_category', 'POST', token, {
    AD_Org_ID: {
      id: body.organizationId,
      tableName: 'AD_Org'
    },
    isActive: body.isActive,
    name: body.name,
    description: body.description,
    value: body.value,
    isDefault: body.isDefault,
    plannedMargin: body.plannedMargin,
    isSelfService: body.isSelfService,
    ...newObjValue,
    tableName: 'M_Product_Category'
  })
  if(res) {
    data = res
    data['status'] = 200
    data['message'] = ''
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})