import refreshTokenHelper from "../../../utils/refreshTokenHelper"
import getTokenHelper from "../../../utils/getTokenHelper"
import forceLogoutHelper from "../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../utils/errorHandlingHelper"
import fetchHelper from "../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const config = useRuntimeConfig()
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  let newObjValue = {}
  if(body.organizationId) {
    newObjValue = {...newObjValue, AD_Org_ID: {
      id: body.organizationId,
      tableName: 'AD_Org'
    }}
  }
  if(body.shipperId) {
    newObjValue = {...newObjValue, 
      M_Shipper_ID: {
        id: body.shipperId,
        tableName: 'M_Shipper'
      }
    }
  }
  if(body.shipperLabelsCfgId) {
    newObjValue = {...newObjValue, M_ShipperLabelsCfg_ID: {
      id: body.shipperLabelsCfgId,
      tableName: 'M_ShipperLabelsCfg'
    }}
  }
  if(body.labelPrintMethodId) {
    newObjValue = {...newObjValue, LabelPrintMethod: {
      id: body.labelPrintMethodId
    }}
  }

  const res: any = await fetchHelper(event, 'models/m_shipperlabels/'+body.id, 'PUT',token, {
    isActive: body.isActive,
    name: body.name,
    isDefault: body.isDefault,
    ...newObjValue,
    tableName: 'm_shipperlabels'
  })
  if(res) {
    data = res
    data['status'] = 200
    data['message'] = ''
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})