import refreshTokenHelper from "../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../utils/errorHandlingHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const config = useRuntimeConfig()
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  let newObjValue = {}
  if(body.confidentialTypeId) {
    newObjValue = {...newObjValue, 
      ConfidentialType: {
        id: body.confidentialTypeId
      }
    }
  }
  if(body.statusCategoryId) {
    newObjValue = {...newObjValue, 
      R_StatusCategory_ID: {
        id: body.statusCategoryId,
        tableName: 'R_StatusCategory'
      }
    }
  }

  const res: any = await event.context.fetch('models/r_requesttype/'+body.id, 'PUT', token, {
    isActive: body.isActive,
    name: body.name,
    description: body.description,
    isDefault: body.isDefault,
    isSelfService: body.isSelfService,
    dueDateTolerance: body.dueDateTolerance,
    isEMailWhenOverdue: body.isEMailWhenOverdue,
    isEMailWhenDue: body.isEMailWhenDue,
    isInvoiced: body.isInvoiced,
    isAutoChangeRequest: body.isAutoChangeRequest,
    isConfidentialInfo: body.isConfidentialInfo,
    isIndexed: body.isIndexed,
    autoDueDateDays: body.autoDueDateDays,
    headerColor: body.headerColor,
    contentColor: body.contentColor,
    ...newObjValue,
    tableName: 'R_RequestType'
  })
  if(res) {
    data = res
    data['status'] = 200
    data['message'] = ''
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})