import type { RouterConfig } from '@nuxt/schema'
import sales from './forms/sales'
import users from './forms/users'
//import SalesOrdersCreate from '../pages/sales/orders/create.vue'
//import SalesInvoicesCreate from '../pages/sales/invoices/create.vue'
//import SalesShipmentsCreate from '../pages/sales/shipments/create.vue'
//import RequestsRequestsCreate from '../pages/requests/requests/create.vue'

// https://router.vuejs.org/api/interfaces/routeroptions.html
export default <RouterConfig> {
  routes: (_routes) => [
    ..._routes,
    {
      path: '/windows',
      component: () => import('./windows/index.vue').then(r => r.default || r),
      children: [
        { 
          path: 'sales-orders-create', 
          component: () => import('../pages/sales/orders/create.vue').then(r => r.default || r) 
        },
        { 
          path: 'sales-orders-edit/:id', 
          component: () => import('../pages/sales/orders/[id]/edit.vue').then(r => r.default || r) 
        },
        { 
          path: 'sales-invoices-create', 
          component: () => import('../pages/sales/invoices/create.vue').then(r => r.default || r)
        },
        { 
          path: 'sales-invoices-edit/:id', 
          component: () => import('../pages/sales/invoices/[id]/edit.vue').then(r => r.default || r)
        },
        { 
          path: 'sales-shipments-create', 
          component: () => import('../pages/sales/shipments/create.vue').then(r => r.default || r)
        },
        { 
          path: 'sales-shipments-edit/:id', 
          component: () => import('../pages/sales/shipments/[id]/edit.vue').then(r => r.default || r)
        },
        { 
          path: 'procurements-orders-edit/:id', 
          component: () => import('../pages/procurements/orders/[id]/edit.vue').then(r => r.default || r) 
        },
        { 
          path: 'requests-requests-create', 
          component: () => import('../pages/requests/requests/create.vue').then(r => r.default || r)
        },
        { 
          path: 'partners-partners-edit/:id', 
          component: () => import('../pages/partners/partners/[id]/edit.vue').then(r => r.default || r)
        },
        { 
          path: 'materials-products-edit/:id', 
          component: () => import('../pages/materials/products/[id]/edit.vue').then(r => r.default || r)
        },
        { 
          path: 'documents-status-edit/:id', 
          component: () => import('../pages/settings/document-status/[id]/edit.vue').then(r => r.default || r)
        },
        { 
          path: 'documents-types-edit/:id', 
          component: () => import('../pages/settings/document-types/[id]/edit.vue').then(r => r.default || r)
        },
      ]
    },
    {
      path: '/create',
      component: () => import('./windows/index.vue').then(r => r.default || r),
      children: [
        ...sales['create'],
        ...users['create']
      ]
    },
    {
      path: '/edit',
      component: () => import('./windows/index.vue').then(r => r.default || r),
      children: [
        ...sales['edit'],
        ...users['edit']
      ]
    },
    {
      path: '/view',
      component: () => import('./windows/index.vue').then(r => r.default || r),
      children: [
        ...sales['view'],
        ...users['view']
      ]
    },
    {
      path: '/duplicate',
      component: () => import('./windows/index.vue').then(r => r.default || r),
      children: [
        ...sales['duplicate'],
        ...users['duplicate']
      ]
    },
  ],
}