import refreshTokenHelper from "../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../utils/errorHandlingHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const config = useRuntimeConfig()
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  const res: any = await event.context.fetch('models/m_discountschemabreak', 'POST', token, {
    AD_Org_ID: {
      id: body.organizationId,
      tableName: 'AD_Org'
    },
    isActive: body.isActive,
    seqNo: body.seqNo,
    breakValue: body.breakValue,
    breakDiscount: body.breakDiscount,
    isBPartnerFlatDiscount: body.isBPartnerFlatDiscount,
    fixedPrice: body.fixedPrice,
    M_Product_Category_ID: {
      id: body.productCategoryId
    },
    M_DiscountSchema_ID: {
      id: body.discountSchemaId,
      tableName: 'M_Discountschema'
    },
    tableName: 'M_Discountschemabreak'
  })
  if(res) {
    data = res
    data['status'] = 200
    data['message'] = ''
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})