export default defineEventHandler(async (event) => {
  const config = useRuntimeConfig()
  const body = await readBody(event)
  let user: any = {}

  if(event.context.auth.user) {
    user = event.context.auth.user
    user.isSuccess = true
  } else {
    await $fetch(config.api.url+'/account/reset-password/finish', {
      method: 'POST',
      headers: {
        'Authorization': 'Bearer '+event.context.auth.token
      },
      body: {
        key: body.key,
        newPassword: body.newPassword
      }
    })

    user.isSuccess = true
  }

  return user
})