import { Client } from '@elastic/elasticsearch'

export default async function elasticsearchHelper(url: string, query: string) {
  const config = useRuntimeConfig()
  
  const client = new Client({
    node: config.api.elastic,
    auth: {
      //apiKey: ''//config.api.elastickey
      username: config.api.elasticusername,
      password: config.api.elasticpass
    }
  })

  return await client.search({
    index: url,
    q: query
  })
}
