import refreshTokenHelper from "../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../utils/errorHandlingHelper"
import fetchHelper from "../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  let newObjValue = {}
  if(body.countryGroupId) {
    newObjValue = {...newObjValue, 
      C_CountryGroup_ID: {
        id: body.countryGroupId,
        tableName: 'C_CountryGroup'
      }
    }
  }
  if(body.countryId) {
    newObjValue = {...newObjValue, 
      C_Country_ID: {
        id: body.countryId,
        tableName: 'C_Country'
      }
    }
  }
  if(body.regionId) {
    newObjValue = {...newObjValue, 
      C_Region_ID: {
        id: body.regionId,
        tableName: 'C_Region'
      }
    }
  }
  if(body.toCountryGroupId) {
    newObjValue = {...newObjValue, 
      To_CountryGroup_ID: {
        id: body.toCountryGroupId,
        tableName: 'C_CountryGroup'
      }
    }
  }
  if(body.toCountryId) {
    newObjValue = {...newObjValue, 
      To_Country_ID: {
        id: body.toCountryId,
        tableName: 'C_Country'
      }
    }
  }
  if(body.toRegionId) {
    newObjValue = {...newObjValue, 
      To_Region_ID: {
        id: body.toRegionId,
        tableName: 'C_Region'
      }
    }
  }
  if(body.taxCategoryId) {
    newObjValue = {...newObjValue, 
      C_TaxCategory_ID: {
        id: body.taxCategoryId,
        tableName: 'C_TaxCategory'
      }
    }
  }
  if(body.SOPOTypeId) {
    newObjValue = {...newObjValue, 
      SOPOType: {
        id: body.SOPOTypeId
      }
    }
  }
  if(body.taxPostingIndicatorId) {
    newObjValue = {...newObjValue, 
      TaxPostingIndicator: {
        id: body.taxPostingIndicatorId
      }
    }
  }
  if(body.taxProviderId) {
    newObjValue = {...newObjValue, 
      C_TaxProvider_ID: {
        id: body.taxProviderId,
        tableName: 'C_TaxProvider'
      }
    }
  }
  if(body.parentTaxId) {
    newObjValue = {...newObjValue, 
      Parent_Tax_ID: {
        id: body.parentTaxId,
        tableName: 'C_Tax'
      }
    }
  }
  if(body.organizationId) {
    newObjValue = {...newObjValue, 
      AD_Org_ID: {
        id: body.organizationId,
        tableName: 'AD_Org'
      }
    }
  }

  const res: any = await fetchHelper(event, 'models/c_tax/'+body.id, 'PUT', token, {
    isActive: body.isActive,
    name: body.name,
    description: body.description,
    isDefault: body.isDefault,
    isDocumentLevel: body.isDocumentLevel,
    isSummary: body.isSummary,
    isTaxExempt: body.isTaxExempt,
    isSalesTax: body.isSalesTax,
    validFrom: body.validFrom,
    rate: body.rate,
    requiresTaxCertificate: body.requiresTaxCertificate,
    taxIndicator: body.taxIndicator,
    ...newObjValue,
    tableName: 'C_Tax'
  })
  if(res) {
    data = res
    data['status'] = 200
    data['message'] = ''
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})