import refreshTokenHelper from "../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../utils/errorHandlingHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const config = useRuntimeConfig()
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  let newObjValue = {}
  if(body.languageId) {
    newObjValue = {...newObjValue, 
      AD_Language: {
        id: body.languageId,
        tableName: 'AD_Language'
      }
    }
  }
  if(body.autoArchiveId) {
    newObjValue = {...newObjValue, 
      AutoArchive: {
        id: body.autoArchiveId
      }
    }
  }
  if(body.mMPolicyId) {
    newObjValue = {...newObjValue, 
      MMPolicy: {
        id: body.mMPolicyId
      }
    }
  }

  const res: any = await event.context.fetch('models/ad_client/'+body.id, 'PUT', token, {
    isActive: body.isActive,
    name: body.name,
    description: body.description,
    value: body.value,
    requestEMail: body.requestEMail,
    requestFolder: body.requestFolder,
    requestUser: body.requestUser,
    isMultiLingualDocument: body.isMultiLingualDocument,
    isSmtpAuthorization: body.isSmtpAuthorization,
    isUseBetaFunctions: body.isUseBetaFunctions,
    isPostImmediate: body.isPostImmediate,
    isUseASP: body.isUseASP,
    isSecureSMTP: body.isSecureSMTP,
    ...newObjValue,
    tableName: 'AD_Client'
  })
  if(res) {
    data = res
    data['status'] = 200
    data['message'] = ''
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})