import refreshTokenHelper from "../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../utils/errorHandlingHelper"
import fetchHelper from "../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const config = useRuntimeConfig()
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  let newObjValue = {}
  if(body.docNoSequenceId) {
    newObjValue = {...newObjValue, 
      DocNoSequence_ID: {
        id: body.docNoSequenceId,
        tableName: 'AD_Sequence'
      }
    }
  }
  if(body.categoryId) {
    newObjValue = {...newObjValue, 
      GL_Category_ID: {
        id: body.categoryId,
        tableName: 'GL_Category'
      }
    }
  }
  if(body.docBaseTypeId) {
    newObjValue = {...newObjValue, 
      DocBaseType: {
        id: body.docBaseTypeId
      }
    }
  }
  if(body.definiteSequenceId) {
    newObjValue = {...newObjValue, 
      DefiniteSequence_ID: {
        id: body.definiteSequenceId,
        tableName: 'AD_Sequence'
      }
    }
  }
  if(body.printFormatId) {
    newObjValue = {...newObjValue, 
      AD_PrintFormat_ID: {
        id: body.printFormatId,
        tableName: 'AD_PrintFormat'
      }
    }
  }
  if(body.organizationId) {
    newObjValue = {...newObjValue, 
      AD_Org_ID: {
        id: body.organizationId,
        tableName: 'AD_Org'
      }
    }
  }

  const res: any = await fetchHelper(event, 'models/c_doctype/'+body.id, 'PUT', token, {
    isActive: body.isActive,
    name: body.name,
    description: body.description,
    isDocNoControlled: body.isDocNoControlled,
    printName: body.printName,
    hasCharges: body.hasCharges,
    hasProforma: body.hasProforma,
    isDefault: body.isDefault,
    documentCopies: body.documentCopies,
    isSOTrx: body.isSOTrx,
    isDefaultCounterDoc: body.isDefaultCounterDoc,
    isPickQAConfirm: body.isPickQAConfirm,
    isShipConfirm: body.isShipConfirm,
    isInTransit: body.isInTransit,
    isSplitWhenDifference: body.isSplitWhenDifference,
    isCreateCounter: body.isCreateCounter,
    isIndexed: body.isIndexed,
    isOverwriteSeqOnComplete: body.isOverwriteSeqOnComplete,
    isOverwriteDateOnComplete: body.isOverwriteDateOnComplete,
    isPrepareSplitDocument: body.isPrepareSplitDocument,
    isChargeOrProductMandatory: body.isChargeOrProductMandatory,
    isNoPriceListCheck: body.isNoPriceListCheck,
    documentNote: body.documentNote,
    ...newObjValue,
    tableName: 'c_doctype'
  })
  if(res) {
    data = res
    data['status'] = 200
    data['message'] = ''
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})