package com.logship.mobile;

import android.content.IntentFilter;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.webkit.WebView;
import com.getcapacitor.BridgeActivity;

public class MainActivity extends BridgeActivity {
    private static final String TAG = "MainActivity";
    private ScannerBroadcastReceiver scannerReceiver;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        // Register custom plugins before super.onCreate
        registerPlugin(AppUpdatePlugin.class);
        super.onCreate(savedInstanceState);
    }

    @Override
    public void onResume() {
        super.onResume();
        registerScannerReceiver();
    }

    @Override
    public void onPause() {
        super.onPause();
        unregisterScannerReceiver();
    }

    private void registerScannerReceiver() {
        try {
            // Get the WebView from Capacitor bridge
            WebView webView = getBridge().getWebView();

            if (webView != null && scannerReceiver == null) {
                scannerReceiver = new ScannerBroadcastReceiver(webView);
                IntentFilter filter = new IntentFilter();

                // Zebra DataWedge intents
                filter.addAction("com.symbol.datawedge.api.RESULT_ACTION");
                filter.addAction("com.logship.mobile.SCAN");

                // Generic scanner intents
                filter.addAction("android.intent.action.SCAN_BARCODE");
                filter.addAction("android.intent.action.DECODE_DATA");
                filter.addAction("android.intent.ACTION_DECODE_DATA");

                // Honeywell
                filter.addAction("com.honeywell.decode.intent.action.EDIT_DATA");
                filter.addAction("com.honeywell.aidc.action.BARCODE_SCAN");

                // Newland
                filter.addAction("nlscan.action.SCANNER_RESULT");
                filter.addAction("com.nlscan.broadcast");

                // Urovo
                filter.addAction("urovo.rcv.message");
                filter.addAction("android.intent.action.SCANRESULT");

                // Generic PDA scanners
                filter.addAction("scan.rcv.message");
                filter.addAction("com.android.scanner.broadcast");
                filter.addAction("com.scanner.broadcast");
                filter.addAction("scanner.broadcast");

                // Netum / generic Chinese PDAs
                filter.addAction("com.netum.scan");
                filter.addAction("netum.action.BARCODE_SCAN");
                filter.addAction("com.barcode.sendBroadcast");

                // Honeywell HS7 engine (used in Netum Q900)
                filter.addAction("com.honeywell.scan.broadcast");
                filter.addAction("com.hsm.RECVRBI");

                // More generic actions
                filter.addAction("com.android.server.scannerservice.broadcast");
                filter.addAction("action.scanner_broadcast");
                filter.addAction("com.scanner.ACTION_RESULT");
                filter.addAction("ACTION_BAR_SCAN");
                filter.addAction("lephone.scanner.action.SCANNER_RESULT");

                // iData
                filter.addAction("android.intent.action.iDataScanResult");

                // Chainway
                filter.addAction("com.chainway.action.BARCODE_DECODING_BROADCAST");

                // Register the receiver
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU) {
                    registerReceiver(scannerReceiver, filter, RECEIVER_EXPORTED);
                } else {
                    registerReceiver(scannerReceiver, filter);
                }

                Log.d(TAG, "Scanner receiver registered with " + filter.countActions() + " actions");
            }
        } catch (Exception e) {
            Log.e(TAG, "Error registering scanner receiver", e);
        }
    }

    private void unregisterScannerReceiver() {
        try {
            if (scannerReceiver != null) {
                unregisterReceiver(scannerReceiver);
                scannerReceiver = null;
                Log.d(TAG, "Scanner receiver unregistered");
            }
        } catch (Exception e) {
            Log.e(TAG, "Error unregistering scanner receiver", e);
        }
    }
}
