import refreshTokenHelper from "../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../utils/errorHandlingHelper"
import fetchHelper from "../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const config = useRuntimeConfig()
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  let newObjValue = {}
  if(body.printColorId) {
    newObjValue = {...newObjValue, AD_PrintColor_ID: {
      id: body.printColorId,
      tableName: 'AD_Printcolor'
    }}
  }
  if(body.priorityBaseId) {
    newObjValue = {...newObjValue, PriorityBase: {
      id: body.priorityBaseId
    }}
  }
  if(body.priceListId) {
    newObjValue = {...newObjValue, M_PriceList_ID: {
      id: body.priceListId,
      tableName: 'M_Pricelist'
    }}
  }
  if(body.poPriceListId) {
    newObjValue = {...newObjValue, PO_PriceList_ID: {
      id: body.poPriceListId,
      tableName: 'M_Pricelist'
    }}
  }
  if(body.discountSchemaId) {
    newObjValue = {...newObjValue, M_DiscountSchema_ID: {
      id: body.discountSchemaId,
      tableName: 'M_Discountschema'
    }}
  }
  if(body.poDiscountSchemaId) {
    newObjValue = {...newObjValue, PO_DiscountSchema_ID: {
      id: body.poDiscountSchemaId,
      tableName: 'M_Discountschema'
    }}
  }
  if(body.dunningId) {
    newObjValue = {...newObjValue, C_Dunning_ID: {
      id: body.dunningId,
      tableName: 'C_Dunning'
    }}
  }

  const res: any = await fetchHelper(event, 'models/c_bp_group/'+body.id, 'PUT', token, {
    isActive: body.isActive,
    name: body.name,
    value: body.value,
    description: body.description,
    isDefault: body.isDefault,
    isConfidentialInfo: body.isConfidentialInfo,
    creditWatchPercent: body.creditWatchPercent,
    priceMatchTolerance: body.priceMatchTolerance,
    ...newObjValue,
    tableName: 'C_BP_Group'
  })
  if(res) {
    data = res
    data['status'] = 200
    data['message'] = ''
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})