import refreshTokenHelper from "../../../utils/refreshTokenHelper"
import getTokenHelper from "../../../utils/getTokenHelper"
import forceLogoutHelper from "../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../utils/errorHandlingHelper"
import fetchHelper from "../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const config = useRuntimeConfig()
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  let newObjValue = {}
  if(body.organizationId) {
    newObjValue = {...newObjValue, AD_Org_ID: {
      id: body.organizationId,
      tableName: 'AD_Org'
    }}
  }
  if(body.shippingProcessorCfgId) {
    newObjValue = {...newObjValue, M_ShippingProcessorCfg_ID: {
      id: body.shippingProcessorCfgId
    }}
  }

  const res: any = await fetchHelper(event, 'models/m_shippercfg/'+body.id, 'PUT',token, {
    isActive: body.isActive,
    name: body.name,
    description: body.description,
    shippingServiceCode: body.shippingServiceCode,
    trackingURL: body.trackingURL,
    isInternational: body.isInternational,
    isOnline: body.isOnline,
    isResidential: body.isResidential,
    isSaturdayDelivery: body.isSaturdayDelivery,
    ...newObjValue,
    tableName: 'm_shippercfg'
  })
  if(res) {
    data = res
    data['status'] = 200
    data['message'] = ''
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})