import refreshTokenHelper from "../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../utils/errorHandlingHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const config = useRuntimeConfig()
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  let newObjValue = {}
  if(body.locatorTypeId) {
    newObjValue = {
      M_LocatorType_ID: {
        id: body.locatorTypeId,
        tableName: 'M_LocatorType'
      }
    }
  }

  const res: any = await event.context.fetch('models/m_locator', 'POST', token, {
    AD_Org_ID: {
      id: body.organizationId,
      tableName: 'AD_Org'
    },
    isActive: body.isActive,
    value: body.value,
    priorityNo: body.priorityNo,
    isDefault: body.isDefault,
    x: body.x,
    y: body.y,
    z: body.z,
    M_Warehouse_ID: {
      id: body.warehouseId,
      tableName: 'M_Warehouse'
    },
    ...newObjValue,
    tableName: 'M_Locator'
  })
  if(res) {
    data = res
    data['status'] = 200
    data['message'] = ''
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})