/*
 * Decompiled with CFR 0.152.
 */
package org.zkforge.timeline;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import org.zkforge.timeline.Hotzone;
import org.zkforge.timeline.Timeline;
import org.zkforge.timeline.data.OccurEvent;
import org.zkforge.timeline.decorator.HighlightDecorator;
import org.zkforge.timeline.event.BandScrollEvent;
import org.zkforge.timeline.event.OccurEventSelectEvent;
import org.zkforge.timeline.util.TimelineUtil;
import org.zkoss.json.JSONArray;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.au.out.AuSetAttribute;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.util.DeferredValue;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;
import org.zkoss.zul.impl.XulElement;

public class Bandinfo
extends XulElement {
    private String _width = "70%";
    private String _intervalUnit = "month";
    private int _intervalPixels = 100;
    private String _syncWith;
    private String _eventSourceUrl;
    private boolean _overview = false;
    private TimeZone _timeZone = TimeZone.getDefault();
    private Date _date = new Date();
    private ListModel _model;
    private SortedSet _events = new TreeSet();
    private LinkedList _eventList = new LinkedList();
    private Date _min;
    private Date _max;
    private transient ListDataListener _dataListener;
    private transient BandScrollListener _bandScrollListener;
    private boolean _bubbleVisible = true;
    private List _addEvtList;
    private List _mdyEvtList;
    private List _rmEvtList;
    private static final String ATTR_ON_ADD_EVENT_RESPONSE = "org.zkforge.timeline.onAddEventResponse";
    private static final String ATTR_ON_REMOVE_EVENT_RESPONSE = "org.zkforge.timeline.onRemoveEventResponse";
    private static final String ATTR_ON_MODIFY_EVENT_RESPONSE = "org.zkforge.timeline.onModifyEventResponse";

    public String getWidth() {
        return this._width;
    }

    public void setWidth(String width) {
        if (!Objects.equals((Object)this._width, (Object)width)) {
            this._width = width;
            this.smartUpdate("width", width);
        }
    }

    public String getIntervalUnit() {
        return this._intervalUnit;
    }

    public void setIntervalUnit(String intervalUnit) {
        if (!Objects.equals((Object)this._intervalUnit, (Object)intervalUnit)) {
            this._intervalUnit = intervalUnit;
            this.smartUpdate("intervalUnit", intervalUnit);
        }
    }

    public int getIntervalPixels() {
        return this._intervalPixels;
    }

    public void setIntervalPixels(int intervalPixels) {
        if (this._intervalPixels != intervalPixels) {
            this._intervalPixels = intervalPixels;
            this.smartUpdate("intervalPixels", intervalPixels);
        }
    }

    public void setSyncWith(String syncWith) {
        if (!Objects.equals((Object)this._syncWith, (Object)syncWith)) {
            this._syncWith = syncWith;
            this.smartUpdate("syncWith", syncWith);
        }
    }

    public String getSyncWith() {
        return this._syncWith;
    }

    public void setEventSourceUrl(String eventSourceUrl) {
        if (!Objects.equals((Object)this._eventSourceUrl, (Object)eventSourceUrl)) {
            this._eventSourceUrl = eventSourceUrl;
            this.smartUpdate("eventSourceUrl", new EncodedURL(eventSourceUrl));
        }
    }

    public String getEventSourceUrl() {
        return this._eventSourceUrl;
    }

    public void setOverview(boolean overview) {
        if (this._overview != overview) {
            this._overview = overview;
            this.smartUpdate("overview", overview);
        }
    }

    public boolean getOverview() {
        return this._overview;
    }

    public void setTimeZone(TimeZone timeZone) {
        if (!Objects.equals((Object)this._timeZone, (Object)timeZone)) {
            this._timeZone = timeZone;
            this.smartUpdate("timeZone", timeZone.getRawOffset() / 3600000);
        }
    }

    public TimeZone getTimeZone() {
        return this._timeZone;
    }

    public void setDate(Date date) {
        if (!this._date.equals(date)) {
            this._date = date;
            this.smartUpdate("date", TimelineUtil.formatDateTime(date));
        }
    }

    public Date getDate() {
        return this._date;
    }

    public void setBubbleVisible(boolean bubbleVisible) {
        if (this._bubbleVisible != bubbleVisible) {
            this._bubbleVisible = bubbleVisible;
            this.smartUpdate("bubbleVisible", this._bubbleVisible);
        }
    }

    public boolean isBubbleVisible() {
        return this._bubbleVisible;
    }

    public void scrollToCenter(Date date) {
        if (date == null) {
            return;
        }
        String uuid = this.getUuid();
        this.response("scrollToCenter", (AuResponse)new AuScript((Component)this, "zk.Widget.$(\"" + uuid + "\").scrollToCenter(\"" + uuid + "\"" + ",\"" + date.toString() + "\")"));
    }

    public void addHighlightDecorator(HighlightDecorator hd) {
        if (hd == null) {
            return;
        }
        String uuid = this.getUuid();
        this.response("addHighlightDecorator" + hd.getId(), (AuResponse)new AuScript((Component)this, "zk.Widget.$(\"" + uuid + "\").addHighlightDecorator(\"" + uuid + "\"" + "," + hd.toString() + ")"));
    }

    public void removeHighlightDecorator(HighlightDecorator hd) {
        if (hd == null) {
            return;
        }
        String uuid = this.getUuid();
        this.response("removeHighlightDecorator" + hd.getId(), (AuResponse)new AuScript((Component)this, "zk.Widget.$(\"" + uuid + "\").removeHighlightDecorator(\"" + uuid + "\"" + "," + hd.getId() + ")"));
    }

    public void showLoadingMessage(boolean show) {
        String uuid = this.getUuid();
        String parentId = this.getParent().getUuid();
        if (show) {
            this.response("showLoadingMessage", (AuResponse)new AuScript((Component)this, "zk.Widget.$(\"" + uuid + "\").showLoadingMessage(\"" + parentId + "\"" + ")"));
        } else {
            this.response("hideLoadingMessage", (AuResponse)new AuScript((Component)this, "zk.Widget.$(\"" + uuid + "\").hideLoadingMessage(\"" + parentId + "\"" + ")"));
        }
    }

    public void addOccurEvent(OccurEvent event) {
        if (event == null) {
            return;
        }
        if (this._addEvtList == null) {
            this._addEvtList = new LinkedList();
        }
        this._addEvtList.add(event);
        if (this.getAttribute(ATTR_ON_ADD_EVENT_RESPONSE) == null) {
            this.setAttribute(ATTR_ON_ADD_EVENT_RESPONSE, Boolean.TRUE);
            Events.postEvent((int)-20000, (String)"onAddEventResponse", (Component)this, null);
        }
    }

    public void removeOccurEvent(OccurEvent event) {
        if (event == null) {
            return;
        }
        if (this._rmEvtList == null) {
            this._rmEvtList = new LinkedList();
        }
        this._rmEvtList.add(event);
        if (this.getAttribute(ATTR_ON_REMOVE_EVENT_RESPONSE) == null) {
            this.setAttribute(ATTR_ON_REMOVE_EVENT_RESPONSE, Boolean.TRUE);
            Events.postEvent((int)-20000, (String)"onRemoveEventResponse", (Component)this, null);
        }
    }

    public void modifyOccurEvent(OccurEvent event) {
        if (event == null) {
            return;
        }
        if (this._mdyEvtList == null) {
            this._mdyEvtList = new LinkedList();
        }
        this._mdyEvtList.add(event);
        if (this.getAttribute(ATTR_ON_MODIFY_EVENT_RESPONSE) == null) {
            this.setAttribute(ATTR_ON_MODIFY_EVENT_RESPONSE, Boolean.TRUE);
            Events.postEvent((int)-20000, (String)"onModifyEventResponse", (Component)this, null);
        }
    }

    public void addManyOccurEvents(Iterator iter) {
        if (iter == null || !iter.hasNext()) {
            return;
        }
        if (this._addEvtList == null) {
            this._addEvtList = new LinkedList();
        }
        while (iter.hasNext()) {
            this._addEvtList.add(iter.next());
        }
        if (this.getAttribute(ATTR_ON_ADD_EVENT_RESPONSE) == null) {
            this.setAttribute(ATTR_ON_ADD_EVENT_RESPONSE, Boolean.TRUE);
            Events.postEvent((int)-20000, (String)"onAddEventResponse", (Component)this, null);
        }
    }

    private String getJSONResponse(List list) {
        StringBuffer sb = new StringBuffer().append('[');
        Iterator it = list.iterator();
        while (it.hasNext()) {
            sb.append(it.next()).append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(']');
        list.clear();
        return sb.toString();
    }

    public void onAddEventResponse() {
        this.removeAttribute(ATTR_ON_ADD_EVENT_RESPONSE);
        this.response("addOccurEvent" + this.getUuid(), (AuResponse)new AuSetAttribute((Component)this, "addOccurEvent", (Object)this.getJSONResponse(this._addEvtList)));
    }

    public void onRemoveEventResponse() {
        this.removeAttribute(ATTR_ON_REMOVE_EVENT_RESPONSE);
        this.response("removeOccurEvent" + this.getUuid(), (AuResponse)new AuSetAttribute((Component)this, "removeOccurEvent", (Object)this.getJSONResponse(this._rmEvtList)));
    }

    public void onModifyEventResponse() {
        this.removeAttribute(ATTR_ON_MODIFY_EVENT_RESPONSE);
        this.response("modifyOccurEvent" + this.getUuid(), (AuResponse)new AuSetAttribute((Component)this, "modifyOccurEvent", (Object)this.getJSONResponse(this._mdyEvtList)));
    }

    private void initDataListener() {
        if (this._dataListener == null) {
            this._dataListener = new ListDataListener(){

                public void onChange(ListDataEvent event) {
                    Bandinfo.this.onListDataChange(event);
                }
            };
        }
        this._model.addListDataListener(this._dataListener);
    }

    public ListModel getModel() {
        return this._model;
    }

    public void setModel(ListModel model) {
        int i;
        if (model == null || Objects.equals((Object)this._model, (Object)model)) {
            return;
        }
        if (this._model != null) {
            this._model.removeListDataListener(this._dataListener);
            int j = this._eventList.size();
            for (i = 0; i < j; ++i) {
                OccurEvent oe = (OccurEvent)this._eventList.get(0);
                this._events.remove(oe);
                this._eventList.remove(oe);
                this.removeOccurEvent(oe);
            }
        }
        this._model = model;
        if (this._model != null) {
            this.initDataListener();
            for (i = 0; i < this._model.getSize(); ++i) {
                Object o = this._model.getElementAt(i);
                this._events.add(o);
                this._eventList.add(o);
            }
        }
        if (this._bandScrollListener == null) {
            this._bandScrollListener = new BandScrollListener();
        }
        this.addEventListener("onBandScroll", this._bandScrollListener);
        if (this._max != null) {
            this.syncModel(this._min, this._max);
        }
    }

    protected void syncModel(Date min, Date max) {
        OccurEvent e1 = new OccurEvent();
        e1.setStart(min);
        OccurEvent e2 = new OccurEvent();
        e2.setStart(max);
        SortedSet<OccurEvent> ss = this._events.subSet(e1, e2);
        Iterator iter = ss.iterator();
        this.addManyOccurEvents(iter);
    }

    protected void onListDataChange(ListDataEvent event) {
        int lower = event.getIndex0();
        int upper = event.getIndex1();
        OccurEvent e1 = new OccurEvent();
        e1.setStart(this._min);
        OccurEvent e2 = new OccurEvent();
        e2.setStart(this._max);
        block0 : switch (event.getType()) {
            case 1: {
                for (int i = lower; i <= upper; ++i) {
                    OccurEvent oe = (OccurEvent)this._model.getElementAt(i);
                    this._events.add(oe);
                    this._eventList.add(oe);
                    if (oe.compareTo(e1) < 0 || oe.compareTo(e2) > 0) continue;
                    this.addOccurEvent(oe);
                }
                break;
            }
            case 2: {
                int count = upper - lower + 1;
                int nowCount = 0;
                ListIterator it = this._eventList.listIterator(upper + 1);
                while (it.hasPrevious()) {
                    OccurEvent oe = (OccurEvent)it.previous();
                    if (count == nowCount) break block0;
                    it.remove();
                    this._events.remove(oe);
                    this._eventList.remove(oe);
                    this.removeOccurEvent(oe);
                    oe = null;
                    ++nowCount;
                }
                break;
            }
            case 0: {
                ListIterator it = this._eventList.listIterator(lower + 1);
                for (int i = lower; i <= upper; ++i) {
                    OccurEvent oe = (OccurEvent)this._model.getElementAt(i);
                    OccurEvent e = (OccurEvent)it.next();
                    this._eventList.set(i, oe);
                    this._events.remove(e);
                    this._events.add(oe);
                    this.removeOccurEvent(e);
                    if (oe.compareTo(e1) >= 0 && oe.compareTo(e2) <= 0) {
                        this.addOccurEvent(oe);
                    }
                    it.hasNext();
                }
                break;
            }
        }
    }

    public void setParent(Component parent) {
        if (parent != null && !(parent instanceof Timeline)) {
            throw new UiException("Unsupported parent for bandinfo: " + parent);
        }
        super.setParent(parent);
    }

    public boolean insertBefore(Component child, Component insertBefore) {
        if (!(child instanceof Hotzone)) {
            throw new UiException("Unsupported child for bandinfo: " + child);
        }
        return super.insertBefore(child, insertBefore);
    }

    private String getString(Object obj) {
        if (obj != null) {
            return obj.toString();
        }
        return "";
    }

    public void service(AuRequest request, boolean everError) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        JSONArray data = (JSONArray)request.getData().get("data");
        Component comp = request.getComponent();
        if (comp == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, (Object)this);
        }
        if (!(comp instanceof Bandinfo)) {
            throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, (Object)this);
        }
        String cmd = request.getCommand();
        if (cmd.equals("onOccurEventSelect")) {
            OccurEvent evt = new OccurEvent();
            evt.setId(this.getString(data.get(0)));
            try {
                evt.setStart(sdf.parse(this.getString(data.get(1))));
                evt.setEnd(sdf.parse(this.getString(data.get(2))));
                evt.setLatestStart(sdf.parse(this.getString(data.get(3))));
                evt.setEarliestEnd(sdf.parse(this.getString(data.get(4))));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            evt.setText(this.getString(data.get(5)));
            evt.setDescription(this.getString(data.get(6)));
            evt.setImageUrl(this.getString(data.get(7)));
            evt.setLinkUrl(this.getString(data.get(8)));
            evt.setIconUrl(this.getString(data.get(9)));
            evt.setColor(this.getString(data.get(10)));
            evt.setTextColor(this.getString(data.get(11)));
            evt.setWikiUrl(this.getString(data.get(12)));
            evt.setWikiSection(this.getString(data.get(13)));
            Events.postEvent((Event)new OccurEventSelectEvent("onOccurEventSelect", comp, evt));
        } else if (cmd.equals("onBandScroll")) {
            if (data == null || data.size() < 2) {
                throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{Objects.toString((Object)data), this});
            }
            Date min = null;
            try {
                min = sdf.parse(this.getString(data.get(0)));
            }
            catch (ParseException e) {
                // empty catch block
            }
            Date max = null;
            try {
                max = sdf.parse(this.getString(data.get(1)));
            }
            catch (ParseException e) {
                // empty catch block
            }
            Date center = null;
            try {
                center = sdf.parse(this.getString(data.get(2)));
            }
            catch (ParseException e) {
                // empty catch block
            }
            Events.postEvent((Event)new BandScrollEvent("onBandScroll", comp, min, max, center));
        } else {
            super.service(request, everError);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (!"70%".equals(this._width)) {
            this.render(renderer, "width", this._width);
        }
        if (!"month".equals(this._intervalUnit)) {
            this.render(renderer, "intervalUnit", this._intervalUnit);
        }
        if (this._intervalPixels != 100) {
            renderer.render("intervalPixels", this._intervalPixels);
        }
        if (this._overview) {
            this.render(renderer, "overview", this._overview);
        }
        if (!Objects.equals((Object)this._timeZone, (Object)TimeZone.getDefault())) {
            renderer.render("timeZone", this._timeZone.getRawOffset() / 3600000);
        }
        this.render(renderer, "date", TimelineUtil.formatDateTime(this._date));
        this.render(renderer, "syncWith", this._syncWith);
        this.render(renderer, "eventSourceUrl", this.getEncodedURL(this._eventSourceUrl));
        if (!this._bubbleVisible) {
            renderer.render("bubbleVisible", this._bubbleVisible);
        }
    }

    private String getEncodedURL(String url) {
        Desktop dt = this.getDesktop();
        return dt != null ? dt.getExecution().encodeURL(url) : "";
    }

    static {
        Bandinfo.addClientEvent((Class)Bandinfo.class, (String)"onOccurEventSelect", (int)1);
        Bandinfo.addClientEvent((Class)Bandinfo.class, (String)"onBandScroll", (int)1);
    }

    private class EncodedURL
    implements DeferredValue {
        private String url;

        public EncodedURL(String url) {
            this.url = url;
        }

        public Object getValue() {
            return Bandinfo.this.getEncodedURL(this.url);
        }
    }

    private class BandScrollListener
    implements EventListener {
        private BandScrollListener() {
        }

        public boolean isAsap() {
            return true;
        }

        public void onEvent(Event event) {
            BandScrollEvent e = (BandScrollEvent)event;
            Date newmin = e.getMin();
            Date newmax = e.getMax();
            if (Bandinfo.this._min == null && Bandinfo.this._max == null) {
                Bandinfo.this._min = newmin;
                Bandinfo.this._max = newmax;
                Bandinfo.this.syncModel(Bandinfo.this._min, Bandinfo.this._max);
            }
            if (newmin.compareTo(Bandinfo.this._min) < 0) {
                Bandinfo.this.syncModel(newmin, Bandinfo.this._min);
                Bandinfo.this._min = newmin;
            }
            if (newmax.compareTo(Bandinfo.this._max) > 0) {
                Bandinfo.this.syncModel(Bandinfo.this._max, newmax);
                Bandinfo.this._max = newmax;
            }
        }
    }
}

