/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.tracker.impl;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.zkoss.bind.sys.Binding;
import org.zkoss.bind.sys.LoadBinding;
import org.zkoss.bind.sys.ReferenceBinding;
import org.zkoss.bind.sys.tracker.TrackerNode;
import org.zkoss.bind.xel.zel.BindELContext;

public class TrackerNodeImpl
implements TrackerNode,
Serializable {
    private static final long serialVersionUID = 1463169907348730644L;
    private final Object _script;
    private final Map<Object, TrackerNode> _dependents;
    private final Map<Object, TrackerNode> _brackets;
    private final Set<LoadBinding> _bindings;
    private final Set<ReferenceBinding> _refBindings;
    private final Set<TrackerNode> _associates;
    private transient WeakReference<Object> _bean;

    public TrackerNodeImpl(Object property) {
        this._script = property;
        this._dependents = new HashMap<Object, TrackerNode>(4);
        this._bindings = new HashSet<LoadBinding>(4);
        this._refBindings = new HashSet<ReferenceBinding>(2);
        this._brackets = new HashMap<Object, TrackerNode>(4);
        this._associates = new HashSet<TrackerNode>(4);
    }

    @Override
    public void addAssociate(TrackerNode node) {
        this._associates.add(node);
    }

    @Override
    public TrackerNode getDependent(Object property) {
        TrackerNode kid = this.getDependent0(property);
        if (kid == null) {
            kid = this._brackets.get(property);
        }
        return kid;
    }

    @Override
    public Set<TrackerNode> getDependents(Object property) {
        String prop;
        TrackerNode node;
        LinkedHashSet<TrackerNode> set = new LinkedHashSet<TrackerNode>(5);
        TrackerNode kid = this.getDependent0(property);
        if (kid != null) {
            set.add(kid);
        }
        if ((node = this._brackets.get(property)) == null && property instanceof String && BindELContext.isBracket(prop = (String)property)) {
            node = this._brackets.get(prop.substring(1, prop.length() - 1));
        }
        if (node != null) {
            set.add(node);
        }
        return set;
    }

    @Override
    public Set<TrackerNode> getDependents() {
        return this.collectDependents0(new HashSet<TrackerNode>());
    }

    private TrackerNode getDependent0(Object script) {
        return this._dependents.get(script);
    }

    @Override
    public void addDependent(Object script, TrackerNode dependent) {
        this._dependents.put(script, dependent);
    }

    @Override
    public void tieProperty(Object property, TrackerNode trackerNode) {
        TrackerNode oldNode = this._brackets.get(property);
        if (trackerNode.equals(oldNode)) {
            return;
        }
        if (oldNode != null) {
            this._brackets.remove(property);
        }
        Iterator<TrackerNode> it = this._brackets.values().iterator();
        while (it.hasNext()) {
            TrackerNode bracket = it.next();
            if (!trackerNode.equals(bracket)) continue;
            it.remove();
            break;
        }
        if (property != null) {
            this._brackets.put(property, trackerNode);
        }
    }

    @Override
    public TrackerNode removeDependent(Object script) {
        return null;
    }

    @Override
    public void addBinding(Binding binding) {
        if (binding instanceof ReferenceBinding) {
            this._refBindings.add((ReferenceBinding)binding);
        } else {
            this._bindings.add((LoadBinding)binding);
        }
    }

    @Override
    public Set<Binding> getBindings() {
        HashSet<Binding> bindings = new HashSet<Binding>();
        bindings.addAll(this.getLoadBindings());
        bindings.addAll(this.getReferenceBindings());
        return bindings;
    }

    @Override
    public Set<ReferenceBinding> getReferenceBindings() {
        return this._refBindings;
    }

    @Override
    public Set<LoadBinding> getLoadBindings() {
        return this._bindings;
    }

    private Set<TrackerNode> collectDependents0(Set<TrackerNode> nodes) {
        Set<TrackerNode> kids = this.getDirectDependents();
        nodes.addAll(kids);
        for (TrackerNode kid : kids) {
            ((TrackerNodeImpl)kid).collectDependents0(nodes);
        }
        for (TrackerNode associate : this._associates) {
            if (nodes.contains(associate)) continue;
            nodes.add(associate);
            ((TrackerNodeImpl)associate).collectDependents0(nodes);
        }
        return nodes;
    }

    @Override
    public Set<TrackerNode> getDirectDependents() {
        return new HashSet<TrackerNode>(this._dependents.values());
    }

    @Override
    public Set<TrackerNode> getAssociates() {
        return this._associates;
    }

    @Override
    public Object getBean() {
        Object bean;
        Object v0 = bean = this._bean == null ? null : this._bean.get();
        if (bean == null && this._bean != null) {
            this.setBean(null);
        }
        return bean;
    }

    @Override
    public void setBean(Object bean) {
        this._bean = bean == null ? null : new WeakReference<Object>(bean);
    }

    @Override
    public Object getFieldScript() {
        return this._script;
    }

    @Override
    public Map<Object, ?> getPropNameMapping() {
        return this._brackets;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[bean:").append(this.getBean()).append(",script:").append(this._script).append("]@").append(System.identityHashCode(this));
        return sb.toString();
    }

    @Override
    public boolean isPropNameNodeMapped(TrackerNode trackerNode) {
        return this._brackets == null ? false : this._brackets.values().contains(trackerNode);
    }
}

