/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.select.impl;

import java.util.LinkedList;
import java.util.List;
import org.zkoss.fsm.MacroStateCtx;
import org.zkoss.fsm.StateCtx;
import org.zkoss.fsm.StateMachine;
import org.zkoss.zk.ui.select.impl.InSeqMachine;
import org.zkoss.zk.ui.select.impl.ParseException;
import org.zkoss.zk.ui.select.impl.Selector;
import org.zkoss.zk.ui.select.impl.Token;
import org.zkoss.zk.ui.select.impl.Tokenizer;

public class Parser {
    private String _source;
    private List<Selector> _selectorSet = new LinkedList<Selector>();
    private Selector _selector;
    private InSeqMachine _submachine;
    private StateMachine<State, CharClass, Token> _machine = new StateMachine<State, CharClass, Token>(){

        protected void init() {
            this.getState((Object)State.PRE_SELECTOR).addReturningClasses((Object[])new CharClass[]{CharClass.WHITESPACE}).addTransition((Object)CharClass.SELECTOR_LITERAL, (Object)State.IN_SELECTOR);
            Parser.this._submachine = new InSeqMachine();
            this.setState((Object)State.IN_SELECTOR, (StateCtx)new MacroStateCtx((StateMachine)Parser.this._submachine)).addReturningClasses((Object[])new CharClass[]{CharClass.SELECTOR_LITERAL}).addTransition((Object)CharClass.WHITESPACE, (Object)State.PRE_COMBINATOR).addTransition((Object)CharClass.SELECTOR_SEPARATOR, (Object)State.PRE_SELECTOR, (StateCtx.TransitionListener)new StateCtx.TransitionListener<Token, CharClass>(){

                public void onTransit(Token input, CharClass inputClass) {
                    this.flushCurrentSelector();
                }
            });
            this.getState((Object)State.PRE_COMBINATOR).addTransition((Object)CharClass.COMBINATOR, (Object)State.POST_COMBINATOR, (StateCtx.TransitionListener)new StateCtx.TransitionListener<Token, CharClass>(){

                public void onTransit(Token input, CharClass inputClass) {
                    Parser.this._selector.attachCombinator(Parser.this.getCombinator(input));
                }
            }).addTransition((Object)CharClass.SELECTOR_LITERAL, (Object)State.IN_SELECTOR).addTransition((Object)CharClass.SELECTOR_SEPARATOR, (Object)State.PRE_SELECTOR, (StateCtx.TransitionListener)new StateCtx.TransitionListener<Token, CharClass>(){

                public void onTransit(Token input, CharClass inputClass) {
                    this.flushCurrentSelector();
                }
            });
            this.getState((Object)State.POST_COMBINATOR).addTransition((Object)CharClass.WHITESPACE, (Object)State.PRE_SELECTOR);
        }

        protected CharClass getClass(Token input) {
            switch (input.getType()) {
                case WHITESPACE: {
                    return CharClass.WHITESPACE;
                }
                case CBN_CHILD: 
                case CBN_ADJACENT_SIBLING: 
                case CBN_GENERAL_SIBLING: {
                    return CharClass.COMBINATOR;
                }
                case SELECTOR_SEPARATOR: {
                    return CharClass.SELECTOR_SEPARATOR;
                }
            }
            return CharClass.SELECTOR_LITERAL;
        }

        protected State getLandingState(Token input, CharClass inputClass) {
            switch (inputClass) {
                case WHITESPACE: {
                    return State.PRE_SELECTOR;
                }
                case SELECTOR_LITERAL: {
                    return State.IN_SELECTOR;
                }
            }
            return null;
        }

        protected void onReset() {
            Parser.this._submachine.setSelector(Parser.this._selector);
            Parser.this._submachine.setSource(Parser.this._source);
        }

        protected void onStop(boolean endOfInput) {
        }

        private void flushCurrentSelector() {
            Parser.this._selector = new Selector(Parser.this._selectorSet.size());
            Parser.this._selectorSet.add(Parser.this._selector);
            Parser.this._submachine.setSelector(Parser.this._selector);
        }
    };

    public List<Selector> parse(String source) {
        try {
            return this.parse(new Tokenizer().tokenize(source), source);
        }
        catch (StateMachine.StateMachineException e) {
            throw new ParseException("Illegal selector string: " + source);
        }
    }

    public List<Selector> parse(List<Token> tokens, String source) {
        this._source = source;
        this._selectorSet.clear();
        this._selector = new Selector(0);
        this._selectorSet.add(this._selector);
        this._machine.start(tokens.iterator());
        return this._selectorSet;
    }

    public void setDebugMode(boolean mode) {
        this._machine.setDebugMode(mode);
        this._submachine.setDebugMode(mode);
    }

    private Selector.Combinator getCombinator(Token token) {
        switch (token.getType()) {
            case CBN_CHILD: {
                return Selector.Combinator.CHILD;
            }
            case CBN_ADJACENT_SIBLING: {
                return Selector.Combinator.ADJACENT_SIBLING;
            }
            case CBN_GENERAL_SIBLING: {
                return Selector.Combinator.GENERAL_SIBLING;
            }
        }
        throw new IllegalStateException();
    }

    private static enum CharClass {
        SELECTOR_LITERAL,
        WHITESPACE,
        COMBINATOR,
        SELECTOR_SEPARATOR;

    }

    private static enum State {
        PRE_SELECTOR,
        IN_SELECTOR,
        PRE_COMBINATOR,
        POST_COMBINATOR;

    }
}

