/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zhtml.impl;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.zkoss.html.HTMLs;
import org.zkoss.lang.Objects;
import org.zkoss.xml.XMLs;
import org.zkoss.zhtml.impl.PageRenderer;
import org.zkoss.zhtml.impl.TagRenderContext;
import org.zkoss.zk.au.DeferredValue;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.DynamicPropertied;
import org.zkoss.zk.ui.ext.RawId;
import org.zkoss.zk.ui.ext.render.DirectContent;
import org.zkoss.zk.ui.sys.BooleanPropertyAccess;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.ComponentsCtrl;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.HtmlPageRenders;
import org.zkoss.zk.ui.sys.PropertyAccess;
import org.zkoss.zk.ui.sys.StringPropertyAccess;

public class AbstractTag
extends AbstractComponent
implements DynamicPropertied,
RawId {
    protected String _tagnm;
    private Map<String, Object> _props;
    private static HashMap<String, PropertyAccess> _properties;

    protected AbstractTag(String tagname) {
        if (tagname == null || tagname.length() == 0) {
            throw new IllegalArgumentException("A tag name is required");
        }
        this._tagnm = tagname;
    }

    protected AbstractTag() {
    }

    public String getSclass() {
        return (String)this.getDynamicProperty("class");
    }

    public void setSclass(String sclass) {
        this.setDynamicProperty("class", sclass);
    }

    public String getStyle() {
        return (String)this.getDynamicProperty("style");
    }

    public void setStyle(String style) {
        this.setDynamicProperty("style", style);
    }

    public String getAccesskey() {
        return (String)this.getDynamicProperty("accesskey");
    }

    public void setAccesskey(String accesskey) throws WrongValueException {
        this.setDynamicProperty("accesskey", accesskey);
    }

    public boolean isContenteditable() {
        Boolean b = (Boolean)this.getDynamicProperty("contenteditable");
        return b != null && b != false;
    }

    public void setContenteditable(boolean contenteditable) throws WrongValueException {
        this.setDynamicProperty("contenteditable", contenteditable ? Boolean.valueOf(contenteditable) : null);
    }

    public String getDir() {
        return (String)this.getDynamicProperty("dir");
    }

    public void setDir(String dir) throws WrongValueException {
        this.setDynamicProperty("dir", dir);
    }

    public boolean isDraggable() {
        Boolean b = (Boolean)this.getDynamicProperty("draggable");
        return b != null && b != false;
    }

    public void setDraggable(boolean draggable) throws WrongValueException {
        this.setDynamicProperty("draggable", draggable ? Boolean.valueOf(draggable) : null);
    }

    public boolean isHidden() {
        Boolean b = (Boolean)this.getDynamicProperty("hidden");
        return b != null && b != false;
    }

    public void setHidden(boolean hidden) throws WrongValueException {
        this.setDynamicProperty("hidden", hidden ? Boolean.valueOf(hidden) : null);
    }

    public String getLang() {
        return (String)this.getDynamicProperty("lang");
    }

    public void setLang(String lang) throws WrongValueException {
        this.setDynamicProperty("lang", lang);
    }

    public boolean isSpellcheck() {
        Boolean b = (Boolean)this.getDynamicProperty("spellcheck");
        return b != null && b != false;
    }

    public void setSpellcheck(boolean spellcheck) throws WrongValueException {
        this.setDynamicProperty("spellcheck", spellcheck ? Boolean.valueOf(spellcheck) : null);
    }

    public Integer getTabindex() {
        return (Integer)this.getDynamicProperty("tabindex");
    }

    public void setTabindex(Integer tabindex) throws WrongValueException {
        this.setDynamicProperty("tabindex", tabindex);
    }

    public String getTitle() {
        return (String)this.getDynamicProperty("title");
    }

    public void setTitle(String title) throws WrongValueException {
        this.setDynamicProperty("title", title);
    }

    public String getTag() {
        return this._tagnm;
    }

    public boolean hasDynamicProperty(String name) {
        return ComponentsCtrl.isReservedAttribute((String)name);
    }

    public Map<String, Object> getDynamicProperties() {
        return this._props;
    }

    public Object getDynamicProperty(String name) {
        return this._props != null ? this._props.get(name) : null;
    }

    public void setDynamicProperty(String name, Object value) throws WrongValueException {
        if (name == null) {
            throw new WrongValueException("name is required");
        }
        if (!this.hasDynamicProperty(name)) {
            throw new WrongValueException("Attribute not allowed: " + name + "\nSpecify the ZK namespace if you want to use special ZK attributes");
        }
        String sval = Objects.toString((Object)value);
        if ("style".equals(name)) {
            sval = this.filterStyle(sval);
            this.setDynaProp(name, sval);
        } else if ("src".equals(name)) {
            EncodedURL url = new EncodedURL(sval);
            this.setDynaProp(name, url);
            sval = (String)url.getValue();
        } else if ("textContent".equals(name)) {
            this.setDynaProp(name, sval);
            if (!this.getChildren().isEmpty()) {
                this.invalidate();
            }
        } else {
            this.setDynaProp(name, value);
        }
        this.smartUpdate("dynamicProperty", new String[]{name, sval}, true);
    }

    private String getEncodedURL(String src) {
        if (src == null) {
            return "data:image/gif;base64,R0lGODlhAQABAIAAAP///////yH5BAUUAAEALAAAAAABAAEAAAICTAEAOw==";
        }
        Desktop dt = this.getDesktop();
        return dt != null ? dt.getExecution().encodeURL(src) : "";
    }

    private String filterStyle(String style) {
        int j;
        if (style != null && (j = HTMLs.getSubstyleIndex((String)style, (String)"display")) >= 0) {
            super.setVisible(!"none".equals(HTMLs.getSubstyleValue((String)style, (int)j)));
            return style;
        }
        if (!this.isVisible()) {
            int len;
            int n = len = style != null ? ((String)style).length() : 0;
            if (len == 0) {
                return "display:none;";
            }
            if (((String)style).charAt(len - 1) != ';') {
                style = (String)style + ";";
            }
            style = (String)style + "display:none;";
        }
        return style;
    }

    private void setDynaProp(String name, Object value) {
        if (value == null) {
            if (this._props != null) {
                this._props.remove(name);
            }
        } else {
            if (this._props == null) {
                this._props = new LinkedHashMap<String, Object>();
            }
            this._props.put(name, value);
        }
    }

    protected boolean shallHideId() {
        return false;
    }

    public boolean setVisible(boolean visible) {
        boolean old = super.setVisible(visible);
        if (old != visible) {
            String style = this.getStyle();
            if (visible) {
                String val;
                int j;
                if (style != null && (j = HTMLs.getSubstyleIndex((String)style, (String)"display")) >= 0 && "none".equals(val = HTMLs.getSubstyleValue((String)style, (int)j))) {
                    Object newstyle = style.substring(0, j);
                    int k = style.indexOf(59, j + 7);
                    if (k >= 0) {
                        newstyle = (String)newstyle + style.substring(k + 1);
                    }
                    this.setDynaProp("style", newstyle);
                }
            } else if (style == null) {
                this.setDynaProp("style", "display:none;");
            } else {
                int j = HTMLs.getSubstyleIndex((String)style, (String)"display");
                if (j >= 0) {
                    String val = HTMLs.getSubstyleValue((String)style, (int)j);
                    if (!"none".equals(val)) {
                        String newstyle = style.substring(0, j) + "display:none;";
                        int k = style.indexOf(59, j + 7);
                        if (k >= 0) {
                            newstyle = newstyle + style.substring(k + 1);
                        }
                        this.setDynaProp("style", newstyle);
                    }
                } else {
                    int len = style.length();
                    String newstyle = len > 0 && style.charAt(len - 1) != ';' ? style + ";" : style;
                    this.setDynaProp("style", style + "display:none;");
                }
            }
        }
        return old;
    }

    public String getWidgetClass() {
        return "zhtml.Widget";
    }

    public void redraw(Writer out) throws IOException {
        if (this._tagnm == null) {
            throw new UiException("The tag name is not initialized yet");
        }
        Execution exec = Executions.getCurrent();
        if (exec == null || exec.isAsyncUpdate(null) || !HtmlPageRenders.isDirectContent((Execution)exec)) {
            super.redraw(out);
            return;
        }
        TagRenderContext rc = PageRenderer.getTagRenderContext(exec);
        boolean rcRequired = rc == null;
        Object ret = null;
        if (rcRequired) {
            ret = PageRenderer.beforeRenderTag(exec);
            rc = PageRenderer.getTagRenderContext(exec);
        }
        out.write(this.getPrologHalf(false));
        rc.renderBegin((Component)this, this.getClientEvents(), this.getSpecialRendererOutput((Component)this), false);
        this.redrawChildrenDirectly(rc, exec, out);
        out.write(this.getEpilogHalf());
        rc.renderEnd((Component)this);
        if (rcRequired) {
            out.write(rc.complete());
            PageRenderer.afterRenderTag(exec, ret);
        }
    }

    protected void redrawChildrenDirectly(TagRenderContext rc, Execution exec, Writer out) throws IOException {
        Component child = this.getFirstChild();
        while (child != null) {
            Component next = child.getNextSibling();
            if (((ComponentCtrl)child).getExtraCtrl() instanceof DirectContent) {
                ((ComponentCtrl)child).redraw(out);
            } else {
                HtmlPageRenders.setDirectContent((Execution)exec, (boolean)false);
                rc.renderBegin(child, null, this.getSpecialRendererOutput(child), true);
                HtmlPageRenders.outStandalone((Execution)exec, (Component)child, (Writer)out);
                rc.renderEnd(child);
                HtmlPageRenders.setDirectContent((Execution)exec, (boolean)true);
            }
            child = next;
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "prolog", this.getPrologHalf(false));
        this.render(renderer, "epilog", this.getEpilogHalf());
    }

    String getPrologHalf(boolean hideUuidIfNoId) {
        StringBuilder sb = new StringBuilder(128).append('<').append(this._tagnm);
        if (this._props != null) {
            for (Map.Entry<String, Object> me : this._props.entrySet()) {
                if ("textContent".equals(me.getKey())) continue;
                Object v = me.getValue();
                if (v instanceof DeferredValue) {
                    v = ((DeferredValue)v).getValue();
                }
                sb.append(' ').append((Object)me.getKey()).append("=\"").append(XMLs.encodeAttribute((String)Objects.toString((Object)v))).append('\"');
            }
        }
        if (!this.isOrphanTag()) {
            sb.append('/');
        }
        sb.append('>');
        Object textContent = this.getDynamicProperty("textContent");
        if (textContent != null) {
            sb.append(XMLs.escapeXML((String)((String)textContent)));
        }
        return sb.toString();
    }

    String getEpilogHalf() {
        return this.isOrphanTag() ? "</" + this._tagnm + ">" : "";
    }

    protected boolean isChildable() {
        return this.isOrphanTag();
    }

    protected boolean isOrphanTag() {
        return !HTMLs.isOrphanTag((String)this._tagnm);
    }

    public PropertyAccess getPropertyAccess(String prop) {
        PropertyAccess pa = _properties.get(prop);
        if (pa != null) {
            return pa;
        }
        return super.getPropertyAccess(prop);
    }

    public Object clone() {
        AbstractTag clone = (AbstractTag)((Object)super.clone());
        if (clone._props != null) {
            clone._props = new LinkedHashMap<String, Object>(clone._props);
        }
        return clone;
    }

    public String toString() {
        return "[" + this._tagnm + " " + super.toString() + "]";
    }

    public Object getExtraCtrl() {
        return new ExtraCtrl();
    }

    static {
        AbstractTag.addClientEvent(AbstractTag.class, (String)"onClick", (int)0);
        _properties = new HashMap(5);
        _properties.put("id", (PropertyAccess)new StringPropertyAccess(){

            public void setValue(Component cmp, String value) {
                ((AbstractTag)cmp).setId(value);
            }

            public String getValue(Component cmp) {
                return ((AbstractTag)cmp).getId();
            }
        });
        _properties.put("sclass", (PropertyAccess)new StringPropertyAccess(){

            public void setValue(Component cmp, String value) {
                ((AbstractTag)cmp).setSclass(value);
            }

            public String getValue(Component cmp) {
                return ((AbstractTag)cmp).getSclass();
            }
        });
        _properties.put("style", (PropertyAccess)new StringPropertyAccess(){

            public void setValue(Component cmp, String value) {
                ((AbstractTag)cmp).setStyle(value);
            }

            public String getValue(Component cmp) {
                return ((AbstractTag)cmp).getStyle();
            }
        });
        _properties.put("visible", (PropertyAccess)new BooleanPropertyAccess(){

            public void setValue(Component cmp, Boolean value) {
                ((AbstractTag)cmp).setVisible(value);
            }

            public Boolean getValue(Component cmp) {
                return ((AbstractTag)cmp).isVisible();
            }
        });
    }

    private class EncodedURL
    implements DeferredValue,
    Serializable {
        private String _src;

        public EncodedURL(String src) {
            this._src = src;
        }

        public Object getValue() {
            return AbstractTag.this.getEncodedURL(this._src);
        }
    }

    protected class ExtraCtrl
    implements DirectContent {
        protected ExtraCtrl() {
        }
    }
}

