/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zel.impl.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.zkoss.zel.ELException;
import org.zkoss.zel.impl.util.ClassReflect;

public class ClassUtil {
    private static ClassReflect _classReflect;
    private static Map<Class<?>, Class<?>> _primToClass;

    public static final Method getCloseMethod(Class<?> cls, String name, Class<?>[] argTypes) throws NoSuchMethodException {
        return _classReflect.getCloseMethod(cls, name, argTypes);
    }

    public static final Object newInstance(Class<?> cls, Object[] args) throws NoSuchMethodException, InstantiationException, InvocationTargetException, IllegalAccessException {
        return _classReflect.newInstance(cls, args);
    }

    public static final Class<?> forNameByThread(String clsName) throws ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            try {
                return Class.forName(clsName, true, cl);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return Class.forName(clsName);
    }

    public static ClassLoader getContextClassLoader(Class<?> reference) {
        return _classReflect.getContextClassLoader(reference);
    }

    public static boolean isInstance(Object value, Class<?> clz) {
        if (clz.isPrimitive()) {
            clz = _primToClass.get(clz);
        }
        return clz.isInstance(value);
    }

    static {
        String className = "org.zkoss.xel.zel.ClassReflect";
        try {
            _classReflect = (ClassReflect)ClassUtil.forNameByThread("org.zkoss.xel.zel.ClassReflect").newInstance();
        }
        catch (Throwable ex) {
            throw new ELException("Unable to load org.zkoss.xel.zel.ClassReflect. Make sure zcommon.jar is available.", ex);
        }
        _primToClass = new HashMap(10);
        _primToClass.put(Boolean.TYPE, Boolean.class);
        _primToClass.put(Byte.TYPE, Byte.class);
        _primToClass.put(Character.TYPE, Character.class);
        _primToClass.put(Short.TYPE, Short.class);
        _primToClass.put(Integer.TYPE, Integer.class);
        _primToClass.put(Long.TYPE, Long.class);
        _primToClass.put(Float.TYPE, Float.class);
        _primToClass.put(Double.TYPE, Double.class);
    }
}

