/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.process;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.db.CConnection;
import org.compiere.model.MColumn;
import org.compiere.model.MProcessPara;
import org.compiere.model.MSequence;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Package_UUID_Map;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Util;

@Process
public class MoveClient
extends SvrProcess {
    private boolean p_IsCopyClient;
    private String p_JDBC_URL;
    private String p_UserName;
    private String p_Password;
    private String p_TablesToExclude;
    private String p_ClientsToInclude;
    private String p_ClientsToExclude;
    private boolean p_IsValidateOnly;
    private String p_TablesToPreserveIDs;
    private String p_ClientName;
    private String p_ClientValue;
    private boolean p_IsSkipSomeValidations;
    private String p_FallbackRecordsWhenFKNotFound = null;
    private static final String insertConversionId = "INSERT INTO T_MoveClient (AD_PInstance_ID, TableName, Source_Key, Target_Key, Identifier) VALUES (?, ?, ?, ?, ?)";
    private static final String queryT_MoveClient = "SELECT Target_Key FROM T_MoveClient WHERE AD_PInstance_ID=? AND TableName=? AND Source_Key=?";
    private Connection externalConn;
    private StringBuffer p_excludeTablesWhere = new StringBuffer();
    private StringBuffer p_whereClient = new StringBuffer();
    private List<String> p_errorList = new ArrayList<String>();
    private List<String> p_missingFkList = new ArrayList<String>();
    private List<String> p_tablesVerifiedList = new ArrayList<String>();
    private List<String> p_tablesToPreserveIDsList = new ArrayList<String>();
    private List<String> p_tablesToExcludeList = new ArrayList<String>();
    private List<String> p_columnsVerifiedList = new ArrayList<String>();
    private List<String> p_idSystemConversionList = new ArrayList<String>();
    private List<FallbackRecord> p_fallbackRecords = null;
    private boolean p_isPreserveAll = false;
    private ConcurrentMap<String, String> externalIdentifiersMap = new ConcurrentHashMap<String, String>();

    @Override
    protected void prepare() {
        this.p_IsValidateOnly = true;
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter para = processInfoParameterArray[n2];
            String name = para.getParameterName();
            if ("IsCopyClient".equals(name)) {
                this.p_IsCopyClient = para.getParameterAsBoolean();
            } else if ("JDBC_URL".equals(name)) {
                this.p_JDBC_URL = para.getParameterAsString();
            } else if ("UserName".equals(name)) {
                this.p_UserName = para.getParameterAsString();
            } else if ("Password".equals(name)) {
                this.p_Password = para.getParameterAsString();
            } else if ("ClientName".equals(name)) {
                this.p_ClientName = para.getParameterAsString();
            } else if ("ClientValue".equals(name)) {
                this.p_ClientValue = para.getParameterAsString();
            } else if ("TablesToExclude".equals(name)) {
                this.p_TablesToExclude = para.getParameterAsString();
            } else if ("ClientsToInclude".equals(name)) {
                this.p_ClientsToInclude = para.getParameterAsString();
            } else if ("ClientsToExclude".equals(name)) {
                this.p_ClientsToExclude = para.getParameterAsString();
            } else if ("IsValidateOnly".equals(name)) {
                this.p_IsValidateOnly = para.getParameterAsBoolean();
            } else if ("IsPreserveIDs".equals(name)) {
                this.p_TablesToPreserveIDs = para.getParameterAsString();
            } else if ("IsSkipSomeValidations".equals(name)) {
                this.p_IsSkipSomeValidations = para.getParameterAsBoolean();
            } else if ("FallbackRecordsWhenFKNotFound".equals(name)) {
                this.p_FallbackRecordsWhenFKNotFound = para.getParameterAsString();
            } else {
                MProcessPara.validateUnknownParameter(this.getProcessInfo().getAD_Process_ID(), para);
            }
            ++n2;
        }
    }

    @Override
    protected String doIt() throws Exception {
        int n;
        int n2;
        String[] stringArray;
        boolean addComma;
        if (this.p_IsCopyClient) {
            if (!Util.isEmpty(this.p_ClientsToExclude, true)) {
                throw new AdempiereException("Tenants to exclude must be empty when copying from template");
            }
            if (!Util.isEmpty(this.p_TablesToPreserveIDs, true)) {
                throw new AdempiereException("Preserve IDs must be empty when copying from template");
            }
            try {
                Integer.parseInt(this.p_ClientsToInclude);
            }
            catch (NumberFormatException numberFormatException) {
                throw new AdempiereException("Error in parameter Tenants to Include, must be just one integer");
            }
        } else if (Util.isEmpty(this.p_JDBC_URL, true)) {
            throw new AdempiereException("Fill mandatory JDBC_URL");
        }
        if (!Util.isEmpty(this.p_ClientsToInclude, true) && !Util.isEmpty(this.p_ClientsToExclude, true)) {
            throw new AdempiereException("Tenants to exclude and include cannot be used at the same time");
        }
        if (Util.isEmpty(this.p_UserName, true)) {
            this.p_UserName = CConnection.get().getDbUid();
        }
        if (Util.isEmpty(this.p_Password, true)) {
            this.p_Password = CConnection.get().getDbPwd();
        }
        this.p_excludeTablesWhere.append("(UPPER(AD_Table.TableName) NOT LIKE 'T|_%' ESCAPE '|'");
        if (this.p_IsCopyClient) {
            this.p_excludeTablesWhere.append(" AND UPPER(TableName) != 'AD_CHANGELOG'");
        }
        if (Util.isEmpty(this.p_TablesToExclude, true)) {
            this.p_excludeTablesWhere.append(")");
        } else {
            this.p_excludeTablesWhere.append(" AND UPPER(TableName) NOT IN (");
            addComma = false;
            stringArray = this.p_TablesToExclude.split(",");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String tableName = stringArray[n];
                this.p_tablesToExcludeList.add(tableName.toUpperCase());
                if (addComma) {
                    this.p_excludeTablesWhere.append(",");
                } else {
                    addComma = true;
                }
                this.p_excludeTablesWhere.append(DB.TO_STRING(tableName.toUpperCase()));
                ++n;
            }
            this.p_excludeTablesWhere.append("))");
        }
        this.p_whereClient.append("AD_Client.AD_Client_ID NOT IN (0");
        if (!Util.isEmpty(this.p_ClientsToExclude, true)) {
            String[] stringArray2 = this.p_ClientsToExclude.split(",");
            n = stringArray2.length;
            int tableName = 0;
            while (tableName < n) {
                int clientInt;
                String clientStr = stringArray2[tableName];
                this.p_whereClient.append(",");
                try {
                    clientInt = Integer.parseInt(clientStr);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new AdempiereException("Error in parameter Tenants to Exclude, must be a list of integer separated by commas, wrong format: " + clientStr);
                }
                this.p_whereClient.append(clientInt);
                ++tableName;
            }
        }
        this.p_whereClient.append(")");
        if (!Util.isEmpty(this.p_ClientsToInclude, true)) {
            this.p_whereClient.append(" AND AD_Client.AD_Client_ID IN (");
            addComma = false;
            stringArray = this.p_ClientsToInclude.split(",");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                int clientInt;
                String clientStr = stringArray[n];
                if (addComma) {
                    this.p_whereClient.append(",");
                } else {
                    addComma = true;
                }
                try {
                    clientInt = Integer.parseInt(clientStr);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new AdempiereException("Error in parameter Tenants to Include, must be a list of integer separated by commas, wrong format: " + clientStr);
                }
                this.p_whereClient.append(clientInt);
                ++n;
            }
            this.p_whereClient.append(")");
        }
        if (!Util.isEmpty(this.p_TablesToPreserveIDs, true)) {
            if ("*".equals(this.p_TablesToPreserveIDs)) {
                this.p_isPreserveAll = true;
            } else {
                this.p_isPreserveAll = false;
                String[] stringArray3 = this.p_TablesToPreserveIDs.split(",");
                n = stringArray3.length;
                int n3 = 0;
                while (n3 < n) {
                    String tableName = stringArray3[n3];
                    this.p_tablesToPreserveIDsList.add(tableName.toUpperCase());
                    ++n3;
                }
            }
        }
        this.p_fallbackRecords = this.parseFallbackRecordsString(this.p_FallbackRecordsWhenFKNotFound);
        this.externalConn = null;
        try {
            try {
                this.externalConn = this.p_IsCopyClient ? DB.getConnection() : DB.getDatabase(this.p_JDBC_URL).getDriverConnection(this.p_JDBC_URL, this.p_UserName, this.p_Password);
            }
            catch (Exception e) {
                throw new AdempiereException("Could not get a connection to " + this.p_JDBC_URL + ",\nCause: " + e.getLocalizedMessage());
            }
            this.validate();
            if (!this.p_errorList.isEmpty()) {
                for (String err : this.p_errorList) {
                    this.addLog(err);
                }
                if (!this.p_missingFkList.isEmpty()) {
                    Collections.sort(this.p_missingFkList);
                    for (String err : this.p_missingFkList) {
                        this.addLog("Missing Key -> " + err);
                    }
                }
                return "@Error@";
            }
            if (!this.p_IsValidateOnly) {
                this.moveClient();
            }
        }
        finally {
            if (this.externalConn != null) {
                this.externalConn.close();
            }
        }
        this.checkSequences();
        return "@OK@";
    }

    private void validate() {
        if (this.p_IsCopyClient) {
            int cntCN = DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM AD_Client WHERE Name=?", this.p_ClientName);
            if (cntCN > 0) {
                throw new AdempiereUserError("Tenant with name " + this.p_ClientName + " already exists in database");
            }
            int cntCV = DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM AD_Client WHERE Value=?", this.p_ClientValue);
            if (cntCV > 0) {
                throw new AdempiereUserError("Tenant with search key " + this.p_ClientValue + " already exists in database");
            }
            int cntCW = DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM W_Store WHERE WebContext=?", this.p_ClientValue.toLowerCase());
            if (cntCW > 0) {
                throw new AdempiereUserError("WebStore with context " + this.p_ClientValue.toLowerCase() + " already exists in database");
            }
        }
        StringBuilder sqlValidClientsSB = new StringBuilder().append("SELECT AD_Client_ID, Value, Name, AD_Client_UU FROM AD_Client WHERE ").append(this.p_whereClient).append(" ORDER BY Value");
        StringBuilder sqlValidateLocalClient = new StringBuilder().append("SELECT COUNT(*) FROM AD_Client WHERE Value=? OR Name=? OR AD_Client_UU=?");
        if (this.p_isPreserveAll || this.p_tablesToPreserveIDsList.contains("AD_CLIENT")) {
            sqlValidateLocalClient.append(" OR AD_Client_ID=?");
        }
        String sqlValidClients = DB.getDatabase().convertStatement(sqlValidClientsSB.toString());
        PreparedStatement stmtVC = null;
        ResultSet rsVC = null;
        int noClients = 0;
        try {
            try {
                stmtVC = this.externalConn.prepareStatement(sqlValidClients, 1003, 1007);
                rsVC = stmtVC.executeQuery();
                while (rsVC.next()) {
                    ++noClients;
                    int clientID = rsVC.getInt(1);
                    String clientValue = rsVC.getString(2);
                    String clientName = rsVC.getString(3);
                    String clientUUID = rsVC.getString(4);
                    if (this.p_IsCopyClient) continue;
                    int cnt = 0;
                    cnt = this.p_isPreserveAll || this.p_tablesToPreserveIDsList.contains("AD_CLIENT") ? DB.getSQLValueEx(this.get_TrxName(), sqlValidateLocalClient.toString(), clientValue, clientName, clientUUID, clientID) : DB.getSQLValueEx(this.get_TrxName(), sqlValidateLocalClient.toString(), clientValue, clientName, clientUUID);
                    if (cnt <= 0) continue;
                    String msg = "Tenant " + clientValue + "/" + clientName + " already exists.  UUID=" + clientUUID;
                    if (this.p_isPreserveAll || this.p_tablesToPreserveIDsList.contains("AD_CLIENT")) {
                        msg = msg + ", ID=" + clientID;
                    }
                    this.p_errorList.add(msg);
                }
            }
            catch (SQLException e) {
                throw new AdempiereException("Could not execute external query: " + sqlValidClients + "\nCause = " + e.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            DB.close(rsVC, stmtVC);
            throw throwable;
        }
        DB.close(rsVC, stmtVC);
        if (noClients <= 0) {
            throw new AdempiereUserError("No tenants to move");
        }
        if (this.p_errorList.size() > 0) {
            return;
        }
        if (!this.p_excludeTablesWhere.toString().contains("'AD_ATTACHMENT'")) {
            this.statusUpdate("Checking storage for attachments");
            StringBuilder sqlExternalAttachment = new StringBuilder().append("SELECT COUNT(*) FROM AD_Attachment").append(" JOIN AD_Client ON (AD_Attachment.AD_Client_ID=AD_Client.AD_Client_ID)").append(" JOIN AD_ClientInfo ON (AD_Attachment.AD_Client_ID=AD_ClientInfo.AD_Client_ID)").append(" JOIN AD_Table ON (AD_Attachment.AD_Table_ID=AD_Table.AD_Table_ID)").append(" LEFT JOIN AD_StorageProvider ON (AD_StorageProvider.AD_StorageProvider_ID=AD_ClientInfo.AD_StorageProvider_ID)").append(" WHERE AD_StorageProvider.Method IS NOT NULL AND AD_StorageProvider.Method!='DB'").append(" AND ").append(this.p_whereClient).append(" AND ").append(this.p_excludeTablesWhere);
            int cntES = this.countInExternal(sqlExternalAttachment.toString());
            if (cntES > 0) {
                throw new AdempiereUserError("There are attachments using external storage provider - that's not implemented yet");
            }
        }
        if (!this.p_excludeTablesWhere.toString().contains("'AD_ARCHIVE'")) {
            this.statusUpdate("Checking storage for archives");
            StringBuilder sqlExternalArchive = new StringBuilder().append("SELECT COUNT(*) FROM AD_Archive").append(" JOIN AD_Client ON (AD_Archive.AD_Client_ID=AD_Client.AD_Client_ID)").append(" JOIN AD_ClientInfo ON (AD_Archive.AD_Client_ID=AD_ClientInfo.AD_Client_ID)").append(" JOIN AD_Table ON (AD_Archive.AD_Table_ID=AD_Table.AD_Table_ID)").append(" LEFT JOIN AD_StorageProvider ON (AD_StorageProvider.AD_StorageProvider_ID=AD_ClientInfo.StorageArchive_ID)").append(" WHERE AD_StorageProvider.Method IS NOT NULL AND AD_StorageProvider.Method!='DB'").append(" AND ").append(this.p_whereClient).append(" AND ").append(this.p_excludeTablesWhere);
            int cntEA = this.countInExternal(sqlExternalArchive.toString());
            if (cntEA > 0) {
                throw new AdempiereUserError("There are archives using external storage provider - that's not implemented yet");
            }
        }
        StringBuilder sqlTablesSB = new StringBuilder().append("SELECT TableName FROM AD_Table WHERE IsActive='Y' AND IsView='N' AND ").append(this.p_excludeTablesWhere).append(" ORDER BY TableName");
        String sqlRemoteTables = DB.getDatabase().convertStatement(sqlTablesSB.toString());
        PreparedStatement stmtRT = null;
        ResultSet rsRT = null;
        try {
            try {
                stmtRT = this.externalConn.prepareStatement(sqlRemoteTables, 1003, 1007);
                rsRT = stmtRT.executeQuery();
                while (rsRT.next()) {
                    String tableName = rsRT.getString(1);
                    this.validateExternalTable(tableName);
                }
            }
            catch (SQLException e) {
                throw new AdempiereException("Could not execute external query: " + sqlRemoteTables + "\nCause = " + e.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            DB.close(rsRT, stmtRT);
            throw throwable;
        }
        DB.close(rsRT, stmtRT);
        if (!this.p_IsSkipSomeValidations) {
            for (String tableName : this.p_tablesVerifiedList) {
                this.validateOrphan(tableName);
            }
        }
    }

    private void validateExternalTable(String tableName) {
        this.statusUpdate("Validating table " + tableName);
        MTable localTable = MTable.get(this.getCtx(), tableName);
        if (localTable == null || localTable.getAD_Table_ID() <= 0) {
            this.p_errorList.add("Table " + tableName + " doesn't exist");
            return;
        }
        if (!"AD_Client".equalsIgnoreCase(tableName)) {
            StringBuilder sqlCountData = new StringBuilder().append("SELECT COUNT(*) FROM ").append(tableName);
            if ("AD_Attribute_Value".equalsIgnoreCase(tableName)) {
                sqlCountData.append(" JOIN AD_Attribute ON (AD_Attribute_Value.AD_Attribute_ID=AD_Attribute.AD_Attribute_ID)");
                sqlCountData.append(" JOIN AD_Client ON (AD_Attribute.AD_Client_ID=AD_Client.AD_Client_ID)");
            } else if ("AD_PInstance_Log".equalsIgnoreCase(tableName)) {
                sqlCountData.append(" JOIN AD_PInstance ON (AD_PInstance_Log.AD_PInstance_ID=AD_PInstance.AD_PInstance_ID)");
                sqlCountData.append(" JOIN AD_Client ON (AD_PInstance.AD_Client_ID=AD_Client.AD_Client_ID)");
            } else {
                if (MColumn.get(this.getCtx(), tableName, "AD_Client_ID") == null) {
                    if (this.log.isLoggable(Level.WARNING)) {
                        this.log.warning("Ignoring " + tableName + ", doesn't have column AD_Client_ID");
                    }
                    return;
                }
                sqlCountData.append(" JOIN AD_Client ON (").append(tableName).append(".AD_Client_ID=AD_Client.AD_Client_ID)");
            }
            sqlCountData.append(" WHERE ").append(this.p_whereClient);
            int cntCD = this.countInExternal(sqlCountData.toString());
            if (cntCD == 0) {
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Ignoring " + tableName + ", doesn't have tenant data");
                }
                return;
            }
            if (cntCD > 0 && "AD_Attribute_Value".equalsIgnoreCase(tableName)) {
                throw new AdempiereUserError("Table " + tableName + " has data, migration not supported");
            }
        }
        String sqlRemoteColumns = DB.getDatabase().convertStatement(" SELECT AD_Column.ColumnName, AD_Column.AD_Reference_ID, AD_Column.FieldLength FROM AD_Column JOIN AD_Table ON (AD_Table.AD_Table_ID=AD_Column.AD_Table_ID) WHERE UPPER(AD_Table.TableName)=? AND AD_Column.IsActive='Y' AND AD_Column.ColumnSQL IS NULL ORDER BY AD_Column.ColumnName");
        PreparedStatement stmtRC = null;
        ResultSet rsRC = null;
        try {
            try {
                stmtRC = this.externalConn.prepareStatement(sqlRemoteColumns, 1003, 1007);
                stmtRC.setString(1, tableName.toUpperCase());
                rsRC = stmtRC.executeQuery();
                while (rsRC.next()) {
                    String columnName = rsRC.getString(1);
                    int refID = rsRC.getInt(2);
                    int length = rsRC.getInt(3);
                    if (columnName.equalsIgnoreCase("AD_Client_ID")) {
                        this.p_columnsVerifiedList.add(tableName.toUpperCase() + "." + columnName.toUpperCase());
                        continue;
                    }
                    this.validateExternalColumn(tableName, columnName, refID, length);
                }
            }
            catch (SQLException e) {
                throw new AdempiereException("Could not execute external query: " + sqlRemoteColumns + "\nCause = " + e.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            DB.close(rsRC, stmtRC);
            throw throwable;
        }
        DB.close(rsRC, stmtRC);
        this.p_tablesVerifiedList.add(tableName.toUpperCase());
    }

    private void validateExternalColumn(String tableName, String columnName, int refID, int length) {
        int cntET;
        MColumn localColumn = MColumn.get(this.getCtx(), tableName, columnName);
        if (localColumn == null || localColumn.getAD_Column_ID() <= 0) {
            this.p_errorList.add("Column " + tableName + "." + columnName + " doesn't exist");
            return;
        }
        if (refID <= 999999 && localColumn.getAD_Reference_ID() <= 999999 && refID != localColumn.getAD_Reference_ID()) {
            this.p_errorList.add("Column " + tableName + "." + columnName + " has different type in dictionary, external: " + refID + ", local: " + localColumn.getAD_Reference_ID());
        }
        if (length > localColumn.getFieldLength()) {
            this.p_errorList.add("Column " + tableName + "." + columnName + " has different length in dictionary, external: " + length + ", local: " + localColumn.getFieldLength());
        }
        StringBuilder sqlDataNotNullInColumn = new StringBuilder().append("SELECT COUNT(*) FROM ").append(tableName).append(" JOIN AD_Client ON (").append(tableName).append(".AD_Client_ID=AD_Client.AD_Client_ID)").append(" WHERE ").append(tableName).append(".").append(columnName).append(" IS NOT NULL").append(" AND ").append(this.p_whereClient);
        if (!this.p_IsSkipSomeValidations && refID > 999999 && (cntET = this.countInExternal(sqlDataNotNullInColumn.toString())) > 0) {
            throw new AdempiereUserError("There is data in unsupported non-official data type for column " + tableName + "." + columnName);
        }
        String foreignTableName = localColumn.getReferenceTableName();
        if (foreignTableName != null && (foreignTableName.equalsIgnoreCase(tableName) || "AD_PInstance_Log".equalsIgnoreCase(tableName))) {
            foreignTableName = "";
        }
        if (!Util.isEmpty(foreignTableName)) {
            String uuidCol = PO.getUUIDColumnName(foreignTableName);
            StringBuilder sqlForeignClientSB = new StringBuilder();
            if ("AD_Ref_List".equalsIgnoreCase(foreignTableName)) {
                sqlForeignClientSB.append("SELECT DISTINCT AD_Ref_List.AD_Client_ID, AD_Ref_List.AD_Ref_List_ID, AD_Ref_List.").append(uuidCol).append(" FROM ").append(tableName);
                if (!"AD_Client".equalsIgnoreCase(tableName)) {
                    sqlForeignClientSB.append(" JOIN AD_Client ON (").append(tableName).append(".AD_Client_ID=AD_Client.AD_Client_ID)");
                }
                sqlForeignClientSB.append(" JOIN AD_Ref_List ON (").append(tableName).append(".").append(columnName).append("=AD_Ref_List.");
                if ("AD_Ref_List_ID".equalsIgnoreCase(columnName)) {
                    sqlForeignClientSB.append("AD_Ref_List_ID");
                } else {
                    sqlForeignClientSB.append("Value");
                }
                sqlForeignClientSB.append(" AND AD_Ref_List.AD_Reference_ID=").append(" (SELECT AD_Column.AD_Reference_Value_ID FROM AD_Column").append(" JOIN AD_Table ON (AD_Column.AD_Table_ID=AD_Table.AD_Table_ID)").append(" WHERE UPPER(AD_Table.TableName)='").append(tableName.toUpperCase()).append("' AND UPPER(AD_Column.ColumnName)='").append(columnName.toUpperCase()).append("'))").append(" WHERE ").append(this.p_whereClient).append(" AND ").append(foreignTableName).append(".AD_Client_ID!=").append(tableName).append(".AD_Client_ID").append(" ORDER BY 2");
            } else {
                sqlForeignClientSB.append("SELECT DISTINCT ").append(foreignTableName).append(".AD_Client_ID, ");
                MTable foreignTable = MTable.get(this.getCtx(), foreignTableName);
                if (foreignTable.isUUIDKeyTable()) {
                    sqlForeignClientSB.append(foreignTableName).append(".").append(uuidCol).append(", ");
                } else {
                    sqlForeignClientSB.append(foreignTableName).append(".").append(foreignTableName).append("_ID, ");
                }
                sqlForeignClientSB.append(foreignTableName).append(".").append(uuidCol).append(" FROM ").append(tableName);
                if (!"AD_Client".equalsIgnoreCase(tableName)) {
                    sqlForeignClientSB.append(" JOIN AD_Client ON (").append(tableName).append(".AD_Client_ID=AD_Client.AD_Client_ID)");
                }
                if ("AD_Client".equalsIgnoreCase(foreignTableName)) {
                    sqlForeignClientSB.append(" JOIN ").append(foreignTableName).append(" c ON (").append(tableName).append(".").append(columnName).append("=c.");
                } else {
                    sqlForeignClientSB.append(" JOIN ").append(foreignTableName).append(" ON (").append(tableName).append(".").append(columnName).append("=").append(foreignTableName).append(".");
                }
                if ("AD_Language".equalsIgnoreCase(foreignTableName) && !columnName.equalsIgnoreCase("AD_Language_ID")) {
                    sqlForeignClientSB.append("AD_Language");
                } else if ("AD_EntityType".equalsIgnoreCase(foreignTableName) && !columnName.equalsIgnoreCase("AD_EntityType_ID")) {
                    sqlForeignClientSB.append("EntityType");
                } else if (foreignTable.isUUIDKeyTable()) {
                    sqlForeignClientSB.append(uuidCol);
                } else {
                    sqlForeignClientSB.append(foreignTableName).append("_ID");
                }
                sqlForeignClientSB.append(")").append(" WHERE ").append(this.p_whereClient).append(" AND ").append(foreignTableName).append(".AD_Client_ID!=").append(tableName).append(".AD_Client_ID").append(" ORDER BY 2");
            }
            String sqlForeignClient = DB.getDatabase().convertStatement(sqlForeignClientSB.toString());
            PreparedStatement stmtFC = null;
            ResultSet rsFC = null;
            try {
                try {
                    stmtFC = this.externalConn.prepareStatement(sqlForeignClient, 1003, 1007);
                    rsFC = stmtFC.executeQuery();
                    while (rsFC.next()) {
                        Object localID;
                        int clientID = rsFC.getInt(1);
                        Object foreignID = rsFC.getObject(2);
                        String foreignUU = rsFC.getString(3);
                        if (clientID > 0) {
                            this.p_errorList.add("Column " + tableName + "." + columnName + " has invalid cross-tenant reference to tenant " + clientID + " on ID=" + String.valueOf(foreignID));
                            continue;
                        }
                        if (foreignID != null && !this.p_idSystemConversionList.contains(foreignTableName.toUpperCase() + "." + String.valueOf(foreignID)) && (localID = this.getFromUUID(foreignTableName, uuidCol, tableName, columnName, foreignUU, foreignID)) != null && localID instanceof Number && ((Number)localID).intValue() >= 0) continue;
                    }
                }
                catch (SQLException e) {
                    throw new AdempiereException("Could not execute external query: " + sqlForeignClient + "\nCause = " + e.getLocalizedMessage());
                }
            }
            catch (Throwable throwable) {
                DB.close(rsFC, stmtFC);
                throw throwable;
            }
            DB.close(rsFC, stmtFC);
        }
        this.p_columnsVerifiedList.add(tableName.toUpperCase() + "." + columnName.toUpperCase());
    }

    private void validateOrphan(String tableName) {
        MTable table2 = MTable.get(this.getCtx(), tableName);
        MColumn[] mColumnArray = table2.getColumns(false);
        int n = mColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            StringBuilder sqlVerifFKSB;
            int cntFk;
            MTable tableFK;
            String foreignTableName;
            String columnName;
            MColumn column = mColumnArray[n2];
            if (!(!column.isActive() || column.getColumnSQL() != null || "AD_Client_ID".equalsIgnoreCase(columnName = column.getColumnName()) || Util.isEmpty(foreignTableName = column.getReferenceTableName()) || "AD_Ref_List".equalsIgnoreCase(foreignTableName) || (tableFK = MTable.get(this.getCtx(), foreignTableName)) == null || "4".equals(tableFK.getAccessLevel()) || (cntFk = this.countInExternal((sqlVerifFKSB = new StringBuilder().append("SELECT COUNT(*) ").append("FROM   AD_Table t ").append("       JOIN AD_Column c ").append("         ON ( c.AD_Table_ID = t.AD_Table_ID ) ").append("WHERE  UPPER(t.TableName)=").append(DB.TO_STRING(tableName.toUpperCase())).append("       AND UPPER(c.ColumnName)=").append(DB.TO_STRING(columnName.toUpperCase())).append("       AND ( c.FKConstraintType IS NULL OR c.FKConstraintType=").append(DB.TO_STRING("D")).append(")")).toString())) <= 0)) {
                this.statusUpdate("Validating orphans for " + table2.getTableName() + "." + columnName);
                MTable foreignTable = MTable.get(this.getCtx(), foreignTableName);
                StringBuilder sqlExternalOrgOrphanSB = new StringBuilder("SELECT COUNT(*) FROM ").append(tableName);
                if (!"AD_Client".equalsIgnoreCase(tableName)) {
                    sqlExternalOrgOrphanSB.append(" JOIN AD_Client ON (").append(tableName).append(".AD_Client_ID=AD_Client.AD_Client_ID)");
                }
                sqlExternalOrgOrphanSB.append(" WHERE ").append(tableName).append(".").append(columnName);
                if (foreignTable.isUUIDKeyTable()) {
                    sqlExternalOrgOrphanSB.append(" IS NOT NULL AND ");
                } else {
                    sqlExternalOrgOrphanSB.append(">0 AND ");
                }
                sqlExternalOrgOrphanSB.append(" ").append(tableName).append(".").append(columnName).append(" NOT IN (").append(" SELECT ").append(foreignTableName).append(".").append(foreignTable.getKeyColumns()[0]).append(" FROM ").append(foreignTableName).append(" WHERE ").append(foreignTableName).append(".AD_Client_ID IN (0,").append(tableName).append(".AD_Client_ID)").append(")").append(" AND ").append(this.p_whereClient);
                int cntOr = this.countInExternal(sqlExternalOrgOrphanSB.toString());
                if (cntOr > 0) {
                    this.p_errorList.add("Column " + tableName + "." + columnName + " has orphan records in table " + foreignTableName);
                }
            }
            ++n2;
        }
    }

    private int countInExternal(String sql) {
        int cnt = 0;
        sql = DB.getDatabase().convertStatement(sql);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = this.externalConn.prepareStatement(sql, 1003, 1007);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    cnt = rs.getInt(1);
                }
            }
            catch (SQLException e) {
                throw new AdempiereException("Could not execute external query: " + sql + "\nCause = " + e.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, stmt);
            throw throwable;
        }
        DB.close(rs, stmt);
        return cnt;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void moveClient() {
        List tables = new Query(this.getCtx(), "AD_Table", "IsView='N' AND " + String.valueOf(this.p_excludeTablesWhere), this.get_TrxName()).setOnlyActiveRecords(true).setOrderBy("TableName").list();
        for (MTable table2 : tables) {
            String tableName = table2.getTableName();
            if (!this.p_tablesVerifiedList.contains(tableName.toUpperCase())) continue;
            String uuidCol = PO.getUUIDColumnName(tableName);
            Object keyCol = table2.isUUIDKeyTable() ? uuidCol.toUpperCase() : tableName.toUpperCase() + "_ID";
            if (!this.p_columnsVerifiedList.contains(tableName.toUpperCase() + "." + (String)keyCol)) continue;
            this.statusUpdate("Converting IDs for table " + tableName);
            StringBuilder selectVerifyIdSB = new StringBuilder().append("SELECT ").append((String)keyCol).append(" FROM ").append(tableName).append(" WHERE ").append((String)keyCol).append("=?");
            StringBuilder selectGetIdsSB = new StringBuilder().append("SELECT ").append(tableName).append(".").append((String)keyCol).append(" FROM ").append(tableName);
            if (!"AD_Client".equalsIgnoreCase(tableName)) {
                selectGetIdsSB.append(" JOIN AD_Client ON (").append(tableName).append(".AD_Client_ID=AD_Client.AD_Client_ID)");
            }
            selectGetIdsSB.append(" WHERE ").append(this.p_whereClient).append(" ORDER BY ").append((String)keyCol);
            String selectGetIds = DB.getDatabase().convertStatement(selectGetIdsSB.toString());
            PreparedStatement stmtGI = null;
            ResultSet rsGI = null;
            try {
                try {
                    stmtGI = this.externalConn.prepareStatement(selectGetIds, 1003, 1007);
                    rsGI = stmtGI.executeQuery();
                    while (rsGI.next()) {
                        Object source_Key = rsGI.getObject(1);
                        Object target_Key = null;
                        if (this.p_isPreserveAll || this.p_tablesToPreserveIDsList.contains(tableName.toUpperCase())) {
                            void var15_26;
                            List<Object> list = DB.getSQLValueObjectsEx(this.get_TrxName(), selectVerifyIdSB.toString(), source_Key);
                            Object var15_27 = null;
                            if (list != null && list.size() == 1) {
                                Object object = list.get(0);
                            }
                            if (var15_26 != null && (!(var15_26 instanceof Number) || ((Number)var15_26).intValue() >= 0)) throw new AdempiereException("In " + tableName + "." + tableName + "_ID already exist the ID=" + String.valueOf(source_Key));
                            target_Key = source_Key;
                        } else if ("AD_ChangeLog".equalsIgnoreCase(tableName)) {
                            int clId = DB.getSQLValueEx(this.get_TrxName(), queryT_MoveClient, this.getAD_PInstance_ID(), "AD_CHANGELOG", String.valueOf(source_Key));
                            if (clId == -1) {
                                target_Key = DB.getNextID(this.getAD_Client_ID(), tableName, this.get_TrxName());
                            }
                        } else {
                            target_Key = table2.isUUIDKeyTable() ? UUID.randomUUID().toString() : (source_Key instanceof Number && ((Number)source_Key).intValue() <= 999999 && !this.p_IsCopyClient ? source_Key : Integer.valueOf(DB.getNextID(this.getAD_Client_ID(), tableName, this.get_TrxName())));
                        }
                        if (target_Key == null && (!(target_Key instanceof Number) || ((Number)target_Key).intValue() < 0)) continue;
                        Object[] objectArray = new Object[5];
                        objectArray[0] = this.getAD_PInstance_ID();
                        objectArray[1] = tableName.toUpperCase();
                        objectArray[2] = source_Key;
                        objectArray[3] = target_Key;
                        DB.executeUpdateEx(insertConversionId, objectArray, this.get_TrxName());
                    }
                }
                catch (SQLException e) {
                    throw new AdempiereException("Could not execute external query: " + selectGetIds + "\nCause = " + e.getLocalizedMessage());
                }
            }
            catch (Throwable throwable) {
                DB.close(rsGI, stmtGI);
                throw throwable;
            }
            DB.close(rsGI, stmtGI);
        }
        try {
            this.commitEx();
        }
        catch (SQLException e1) {
            throw new AdempiereException(e1);
        }
        int newADClientID = -1;
        String oldClientValue = null;
        if (this.p_IsCopyClient) {
            int clientInt;
            try {
                clientInt = Integer.parseInt(this.p_ClientsToInclude);
            }
            catch (NumberFormatException numberFormatException) {
                throw new AdempiereException("Error in parameter Tenants to Include, must be just one integer");
            }
            newADClientID = DB.getSQLValueEx(this.get_TrxName(), queryT_MoveClient, this.getAD_PInstance_ID(), "AD_CLIENT", String.valueOf(clientInt));
            oldClientValue = DB.getSQLValueStringEx(this.get_TrxName(), "SELECT Value FROM AD_Client WHERE AD_Client_ID=?", clientInt);
        }
        for (MTable table3 : tables) {
            PreparedStatement preparedStatement;
            String tableName = table3.getTableName();
            if (!this.p_tablesVerifiedList.contains(tableName.toUpperCase())) continue;
            this.statusUpdate("Inserting data for table " + tableName);
            StringBuilder valuesSB = new StringBuilder();
            StringBuilder columnsSB = new StringBuilder();
            StringBuilder qColumnsSB = new StringBuilder();
            int ncols = 0;
            ArrayList<MColumn> columns = new ArrayList<MColumn>();
            MColumn[] mColumnArray = table3.getColumns(false);
            int clId = mColumnArray.length;
            int target_Key = 0;
            while (target_Key < clId) {
                MColumn column = mColumnArray[target_Key];
                if (column.isActive() && column.getColumnSQL() == null) {
                    String columnName = column.getColumnName();
                    if (this.p_columnsVerifiedList.contains(tableName.toUpperCase() + "." + columnName.toUpperCase())) {
                        if (columnsSB.length() > 0) {
                            qColumnsSB.append(",");
                            columnsSB.append(",");
                            valuesSB.append(",");
                        }
                        String quoteColumnName = DB.getDatabase().quoteColumnName(columnName);
                        qColumnsSB.append(tableName).append(".").append(quoteColumnName);
                        columnsSB.append(quoteColumnName);
                        valuesSB.append("?");
                        columns.add(column);
                        ++ncols;
                    }
                }
                ++target_Key;
            }
            StringBuilder insertSB = new StringBuilder().append("INSERT INTO ").append(tableName).append("(").append((CharSequence)columnsSB).append(") VALUES (").append((CharSequence)valuesSB).append(")");
            StringBuilder selectGetDataSB = new StringBuilder().append("SELECT ").append((CharSequence)qColumnsSB).append(" FROM ").append(tableName);
            if ("AD_PInstance_Log".equalsIgnoreCase(tableName)) {
                selectGetDataSB.append(" JOIN AD_PInstance ON (AD_PInstance_Log.AD_PInstance_ID=AD_PInstance.AD_PInstance_ID)");
                selectGetDataSB.append(" JOIN AD_Client ON (AD_PInstance.AD_Client_ID=AD_Client.AD_Client_ID)");
            } else if (!"AD_Client".equalsIgnoreCase(tableName)) {
                selectGetDataSB.append(" JOIN AD_Client ON (").append(tableName).append(".AD_Client_ID=AD_Client.AD_Client_ID)");
            }
            selectGetDataSB.append(" WHERE ").append(this.p_whereClient);
            String selectGetData = DB.getDatabase().convertStatement(selectGetDataSB.toString());
            Statement statement = null;
            ResultSet rsGD = null;
            Object[] parameters = new Object[ncols];
            try {
                try {
                    preparedStatement = this.externalConn.prepareStatement(selectGetData, 1003, 1007);
                    rsGD = preparedStatement.executeQuery();
                    while (rsGD.next()) {
                        boolean insertRecord = true;
                        int i = 0;
                        while (i < ncols) {
                            MColumn column = (MColumn)columns.get(i);
                            String columnName = column.getColumnName();
                            String convertTable = column.getReferenceTableName();
                            if ((tableName + "_ID").equalsIgnoreCase(columnName)) {
                                convertTable = tableName;
                            } else if (DisplayType.isMultiID(column.getAD_Reference_ID())) {
                                convertTable = column.getMultiReferenceTableName();
                            } else if (convertTable != null && ("AD_Ref_List".equalsIgnoreCase(convertTable) || "AD_Language".equalsIgnoreCase(columnName) || "EntityType".equalsIgnoreCase(columnName))) {
                                convertTable = "";
                            } else if (("Record_ID".equalsIgnoreCase(columnName) || "Record_UU".equalsIgnoreCase(columnName)) && table3.columnExistsInDB("AD_Table_ID")) {
                                int tableId = rsGD.getInt("AD_Table_ID");
                                convertTable = tableId > 0 ? this.getExternalTableName(tableId) : "";
                            } else if ("Line_ID".equalsIgnoreCase(columnName) && "Fact_Acct".equalsIgnoreCase(tableName)) {
                                int tableId = rsGD.getInt("AD_Table_ID");
                                convertTable = tableId > 0 ? this.getAcctDetailTableName(tableId) : "";
                            } else if ("Parent_ID".equalsIgnoreCase(columnName) && "AD_Tree_Favorite_Node".equalsIgnoreCase(tableName)) {
                                convertTable = "AD_Tree_Favorite_Node";
                            } else if ("Node_ID".equalsIgnoreCase(columnName) && "AD_TreeBar".equalsIgnoreCase(tableName)) {
                                convertTable = "AD_Menu";
                            } else if (("Node_ID".equalsIgnoreCase(columnName) || "Parent_ID".equalsIgnoreCase(columnName)) && "AD_TreeNodeMM".equalsIgnoreCase(tableName)) {
                                convertTable = "AD_Menu";
                            } else if (("Node_ID".equalsIgnoreCase(columnName) || "Parent_ID".equalsIgnoreCase(columnName)) && "AD_TreeNodeBP".equalsIgnoreCase(tableName)) {
                                convertTable = "C_BPartner";
                            } else if (("Node_ID".equalsIgnoreCase(columnName) || "Parent_ID".equalsIgnoreCase(columnName)) && "AD_TreeNodeCMC".equalsIgnoreCase(tableName)) {
                                convertTable = "CM_Container";
                            } else if (("Node_ID".equalsIgnoreCase(columnName) || "Parent_ID".equalsIgnoreCase(columnName)) && "AD_TreeNodeCMM".equalsIgnoreCase(tableName)) {
                                convertTable = "CM_Media";
                            } else if (("Node_ID".equalsIgnoreCase(columnName) || "Parent_ID".equalsIgnoreCase(columnName)) && "AD_TreeNodeCMS".equalsIgnoreCase(tableName)) {
                                convertTable = "CM_CStage";
                            } else if (("Node_ID".equalsIgnoreCase(columnName) || "Parent_ID".equalsIgnoreCase(columnName)) && "AD_TreeNodeCMT".equalsIgnoreCase(tableName)) {
                                convertTable = "CM_Template";
                            } else if (("Node_ID".equalsIgnoreCase(columnName) || "Parent_ID".equalsIgnoreCase(columnName)) && "AD_TreeNodePR".equalsIgnoreCase(tableName)) {
                                convertTable = "M_Product";
                            } else if (("Node_ID".equalsIgnoreCase(columnName) || "Parent_ID".equalsIgnoreCase(columnName)) && ("AD_TreeNodeU1".equalsIgnoreCase(tableName) || "AD_TreeNodeU2".equalsIgnoreCase(tableName) || "AD_TreeNodeU3".equalsIgnoreCase(tableName) || "AD_TreeNodeU4".equalsIgnoreCase(tableName))) {
                                convertTable = "C_ElementValue";
                            } else if (("Node_ID".equalsIgnoreCase(columnName) || "Parent_ID".equalsIgnoreCase(columnName)) && "AD_TreeNode".equalsIgnoreCase(tableName)) {
                                int treeId = rsGD.getInt("AD_Tree_ID");
                                convertTable = this.getExternalTableFromTree(treeId);
                            } else if ("AD_Preference".equalsIgnoreCase(tableName) && "Value".equalsIgnoreCase(columnName)) {
                                String att = rsGD.getString("Attribute");
                                if (att.toUpperCase().endsWith("_ID")) {
                                    convertTable = att.substring(0, att.length() - 3);
                                    if ("C_DocTypeTarget".equals(convertTable)) {
                                        convertTable = "C_DocType";
                                    } else if (MTable.getTable_ID(convertTable, this.get_TrxName()) <= 0) {
                                        convertTable = "";
                                    }
                                } else {
                                    convertTable = "";
                                }
                            }
                            if (!Util.isEmpty(convertTable)) {
                                Object key = rsGD.getObject(i + 1);
                                if (rsGD.wasNull()) {
                                    parameters[i] = null;
                                } else {
                                    if ((!(key instanceof Number) || ((Number)key).intValue() != 0 || !"Parent_ID".equalsIgnoreCase(columnName) && !"Node_ID".equalsIgnoreCase(columnName)) && (key instanceof String || key instanceof Number && ((Number)key).intValue() >= 999999 || this.p_IsCopyClient)) {
                                        Object convertedId = null;
                                        if (DisplayType.isMultiID(column.getAD_Reference_ID())) {
                                            String[] multiKeys;
                                            String[] stringArray = multiKeys = ((String)key).split(",");
                                            int n = multiKeys.length;
                                            int n2 = 0;
                                            while (n2 < n) {
                                                String multiKey = stringArray[n2];
                                                Object keyToConvert = Util.isUUID(multiKey) ? multiKey : Integer.valueOf(multiKey);
                                                Object multiConvertedId = this.getConvertedId(convertTable, keyToConvert, tableName, columnName);
                                                if (multiConvertedId == null || multiConvertedId instanceof Number && ((Number)multiConvertedId).intValue() < 0) {
                                                    if (!this.canIgnoreNullConvertedId(table3, tableName, columnName, convertTable)) throw new AdempiereException("Found orphan record in " + tableName + "." + columnName + ": " + multiKey + " related to table " + convertTable);
                                                    insertRecord = false;
                                                    break;
                                                }
                                                convertedId = convertedId == null ? "" : String.valueOf(convertedId) + ",";
                                                convertedId = String.valueOf(convertedId) + String.valueOf(multiConvertedId);
                                                ++n2;
                                            }
                                        } else {
                                            convertedId = this.getConvertedId(convertTable, key, tableName, columnName);
                                            if (convertedId == null || convertedId instanceof Number && ((Number)convertedId).intValue() < 0) {
                                                if (!this.canIgnoreNullConvertedId(table3, tableName, columnName, convertTable)) throw new AdempiereException("Found orphan record in " + tableName + "." + columnName + ": " + String.valueOf(key) + " related to table " + convertTable);
                                                insertRecord = false;
                                                break;
                                            }
                                        }
                                        Object object = key = convertedId instanceof Number ? Integer.valueOf(((Number)convertedId).intValue()) : convertedId.toString();
                                    }
                                    parameters[i] = "AD_Preference".equalsIgnoreCase(tableName) && "Value".equalsIgnoreCase(columnName) ? String.valueOf(key) : (DisplayType.isText(column.getAD_Reference_ID()) ? key.toString() : Integer.valueOf(key.toString()));
                                }
                            } else {
                                parameters[i] = rsGD.getObject(i + 1);
                                if (rsGD.wasNull()) {
                                    parameters[i] = null;
                                }
                                if (this.p_IsCopyClient) {
                                    String uuidCol = PO.getUUIDColumnName(tableName);
                                    if (columnName.equals(uuidCol)) {
                                        String oldUUID = (String)parameters[i];
                                        String newUUID = DB.getSQLValueStringEx(this.get_TrxName(), queryT_MoveClient, this.getAD_PInstance_ID(), tableName.toUpperCase(), oldUUID);
                                        if (newUUID == null) {
                                            newUUID = UUID.randomUUID().toString();
                                        }
                                        parameters[i] = newUUID;
                                        if (!Util.isEmpty(oldUUID)) {
                                            X_AD_Package_UUID_Map map = new X_AD_Package_UUID_Map(this.getCtx(), 0, this.get_TrxName());
                                            map.setAD_Table_ID(table3.getAD_Table_ID());
                                            map.set_ValueNoCheck("AD_Client_ID", newADClientID);
                                            map.setSource_UUID(oldUUID);
                                            map.setTarget_UUID(newUUID);
                                            map.saveEx();
                                        }
                                    } else if ("AD_Client".equalsIgnoreCase(tableName) && "Value".equalsIgnoreCase(columnName)) {
                                        parameters[i] = this.p_ClientValue;
                                    } else if ("AD_Client".equalsIgnoreCase(tableName) && "Name".equalsIgnoreCase(columnName)) {
                                        parameters[i] = this.p_ClientName;
                                    } else if ("W_Store".equalsIgnoreCase(tableName) && "WebContext".equalsIgnoreCase(columnName) || "AD_User".equalsIgnoreCase(tableName) && "Value".equalsIgnoreCase(columnName)) {
                                        parameters[i] = this.p_ClientValue.toLowerCase();
                                    } else if ("AD_User".equalsIgnoreCase(tableName) && "Password".equalsIgnoreCase(columnName) || "AD_User".equalsIgnoreCase(tableName) && "Salt".equalsIgnoreCase(columnName)) {
                                        parameters[i] = null;
                                    } else if (("AD_Org".equalsIgnoreCase(tableName) && "Value".equalsIgnoreCase(columnName) || "AD_Org".equalsIgnoreCase(tableName) && "Name".equalsIgnoreCase(columnName) || "AD_Role".equalsIgnoreCase(tableName) && "Name".equalsIgnoreCase(columnName) || "AD_Tree".equalsIgnoreCase(tableName) && "Name".equalsIgnoreCase(columnName) || "AD_User".equalsIgnoreCase(tableName) && "Name".equalsIgnoreCase(columnName) || "AD_User".equalsIgnoreCase(tableName) && "Description".equalsIgnoreCase(columnName) || "C_AcctProcessor".equalsIgnoreCase(tableName) && "Name".equalsIgnoreCase(columnName) || "C_AcctSchema".equalsIgnoreCase(tableName) && "Name".equalsIgnoreCase(columnName) || "C_BPartner".equalsIgnoreCase(tableName) && "Value".equalsIgnoreCase(columnName) || "C_BPartner".equalsIgnoreCase(tableName) && "Name".equalsIgnoreCase(columnName) || "C_Calendar".equalsIgnoreCase(tableName) && "Name".equalsIgnoreCase(columnName) || "C_Element".equalsIgnoreCase(tableName) && "Name".equalsIgnoreCase(columnName) || "M_CostType".equalsIgnoreCase(tableName) && "Name".equalsIgnoreCase(columnName) || "R_RequestProcessor".equalsIgnoreCase(tableName) && "Name".equalsIgnoreCase(columnName)) && parameters[i] != null) {
                                        String value = parameters[i].toString();
                                        parameters[i] = value.replaceFirst(oldClientValue, this.p_ClientValue);
                                    }
                                }
                            }
                            ++i;
                        }
                        if (!insertRecord) continue;
                        try {
                            DB.executeUpdateEx(insertSB.toString(), parameters, this.get_TrxName());
                        }
                        catch (Exception e) {
                            throw new AdempiereException("Could not execute: " + String.valueOf(insertSB) + "\nCause = " + e.getLocalizedMessage());
                        }
                    }
                }
                catch (SQLException e) {
                    throw new AdempiereException("Could not execute external query: " + selectGetData + "\nCause = " + e.getLocalizedMessage());
                }
            }
            catch (Throwable throwable) {
                DB.close(rsGD, statement);
                throw throwable;
            }
            DB.close(rsGD, preparedStatement);
        }
        this.statusUpdate("Committing.  Validating foreign keys");
        try {
            this.commitEx();
            return;
        }
        catch (SQLException e) {
            throw new AdempiereException("Could not commit,\nCause: " + e.getLocalizedMessage());
        }
    }

    private boolean canIgnoreNullConvertedId(MTable table2, String tableName, String columnName, String convertTable) {
        if ((("Record_ID".equalsIgnoreCase(columnName) || "Record_UU".equalsIgnoreCase(columnName)) && table2.columnExistsInDB("AD_Table_ID") || "Line_ID".equalsIgnoreCase(columnName) && "Fact_Acct".equalsIgnoreCase(tableName) || ("Node_ID".equalsIgnoreCase(columnName) || "Parent_ID".equalsIgnoreCase(columnName)) && ("AD_TreeNode".equalsIgnoreCase(tableName) || "AD_TreeNodeMM".equalsIgnoreCase(tableName) || "AD_TreeNodeBP".equalsIgnoreCase(tableName) || "AD_TreeNodeCMC".equalsIgnoreCase(tableName) || "AD_TreeNodeCMM".equalsIgnoreCase(tableName) || "AD_TreeNodeCMS".equalsIgnoreCase(tableName) || "AD_TreeNodeCMT".equalsIgnoreCase(tableName) || "AD_TreeNodePR".equalsIgnoreCase(tableName) || "AD_TreeNodeU1".equalsIgnoreCase(tableName) || "AD_TreeNodeU2".equalsIgnoreCase(tableName) || "AD_TreeNodeU3".equalsIgnoreCase(tableName) || "AD_TreeNodeU4".equalsIgnoreCase(tableName) || "AD_Tree_Favorite_Node".equalsIgnoreCase(tableName) || "AD_TreeBar".equalsIgnoreCase(tableName))) && this.p_tablesToExcludeList.contains(convertTable.toUpperCase())) {
            return true;
        }
        return "AD_ChangeLog".equalsIgnoreCase(tableName) || "AD_PInstance".equalsIgnoreCase(tableName) || "AD_PInstance_Log".equalsIgnoreCase(tableName);
    }

    private Object getConvertedId(String convertTable, Object key, String tableName, String columnName) {
        Object convertedId = null;
        try {
            List<Object> list = DB.getSQLValueObjectsEx(this.get_TrxName(), queryT_MoveClient, this.getAD_PInstance_ID(), convertTable.toUpperCase(), String.valueOf(key));
            if (list != null && list.size() == 1) {
                convertedId = list.get(0);
            }
        }
        catch (Exception e) {
            throw new AdempiereException("Could not execute query: SELECT Target_Key FROM T_MoveClient WHERE AD_PInstance_ID=? AND TableName=? AND Source_Key=?\nCause = " + e.getLocalizedMessage());
        }
        if (convertedId == null || convertedId instanceof Number && ((Number)convertedId).intValue() < 0) {
            if (!this.p_IsCopyClient) {
                return key;
            }
            MTable cTable = MTable.get(this.getCtx(), convertTable);
            if (key instanceof String && !cTable.isUUIDKeyTable() && columnName.equals("Record_UU")) {
                convertedId = UUID.randomUUID().toString();
                Object[] objectArray = new Object[5];
                objectArray[0] = this.getAD_PInstance_ID();
                objectArray[1] = convertTable.toUpperCase();
                objectArray[2] = key;
                objectArray[3] = convertedId;
                DB.executeUpdateEx(insertConversionId, objectArray, this.get_TrxName());
            } else {
                convertedId = this.getLocalKeyFor(convertTable, key, tableName);
            }
        }
        return convertedId;
    }

    private String getExternalTableFromTree(int treeId) {
        String tableName = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = this.externalConn.prepareStatement("SELECT CASE          WHEN TreeType = 'AY' THEN 'C_Activity'          WHEN TreeType = 'BB' THEN 'M_BOM'          WHEN TreeType = 'BP' THEN 'C_BPartner'          WHEN TreeType = 'CC' THEN 'CM_Container'          WHEN TreeType = 'CM' THEN 'CM_Media'          WHEN TreeType = 'CS' THEN 'CM_CStage'          WHEN TreeType = 'CT' THEN 'CM_Template'          WHEN TreeType = 'EV' THEN 'C_ElementValue'          WHEN TreeType = 'MC' THEN 'C_Campaign'          WHEN TreeType = 'MM' THEN 'AD_Menu'          WHEN TreeType = 'OO' THEN 'AD_Org'          WHEN TreeType = 'PC' THEN 'M_Product_Category'          WHEN TreeType = 'PJ' THEN 'C_Project'          WHEN TreeType = 'PR' THEN 'M_Product'          WHEN TreeType = 'SR' THEN 'C_SalesRegion'          WHEN TreeType = 'U1' THEN 'C_ElementValue'          WHEN TreeType = 'U2' THEN 'C_ElementValue'          WHEN TreeType = 'U3' THEN 'C_ElementValue'          WHEN TreeType = 'U4' THEN 'C_ElementValue'          WHEN TreeType = 'TL' THEN AD_Table.TableName          ELSE NULL        END FROM   AD_Tree        LEFT JOIN AD_Table ON ( AD_Table.AD_Table_ID = AD_Tree.AD_Table_ID ) WHERE  AD_Tree_ID = ?", 1003, 1007);
                stmt.setInt(1, treeId);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    tableName = rs.getString(1);
                }
            }
            catch (SQLException e) {
                throw new AdempiereException("Could not execute external query: SELECT CASE          WHEN TreeType = 'AY' THEN 'C_Activity'          WHEN TreeType = 'BB' THEN 'M_BOM'          WHEN TreeType = 'BP' THEN 'C_BPartner'          WHEN TreeType = 'CC' THEN 'CM_Container'          WHEN TreeType = 'CM' THEN 'CM_Media'          WHEN TreeType = 'CS' THEN 'CM_CStage'          WHEN TreeType = 'CT' THEN 'CM_Template'          WHEN TreeType = 'EV' THEN 'C_ElementValue'          WHEN TreeType = 'MC' THEN 'C_Campaign'          WHEN TreeType = 'MM' THEN 'AD_Menu'          WHEN TreeType = 'OO' THEN 'AD_Org'          WHEN TreeType = 'PC' THEN 'M_Product_Category'          WHEN TreeType = 'PJ' THEN 'C_Project'          WHEN TreeType = 'PR' THEN 'M_Product'          WHEN TreeType = 'SR' THEN 'C_SalesRegion'          WHEN TreeType = 'U1' THEN 'C_ElementValue'          WHEN TreeType = 'U2' THEN 'C_ElementValue'          WHEN TreeType = 'U3' THEN 'C_ElementValue'          WHEN TreeType = 'U4' THEN 'C_ElementValue'          WHEN TreeType = 'TL' THEN AD_Table.TableName          ELSE NULL        END FROM   AD_Tree        LEFT JOIN AD_Table ON ( AD_Table.AD_Table_ID = AD_Tree.AD_Table_ID ) WHERE  AD_Tree_ID = ?\nCause = " + e.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, stmt);
            throw throwable;
        }
        DB.close(rs, stmt);
        return tableName;
    }

    private String getExternalTableName(int tableId) {
        String tableName = null;
        String sql = DB.getDatabase().convertStatement("SELECT TableName FROM AD_Table WHERE AD_Table_ID=?");
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = this.externalConn.prepareStatement(sql, 1003, 1007);
                stmt.setInt(1, tableId);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    tableName = rs.getString(1);
                }
            }
            catch (SQLException e) {
                throw new AdempiereException("Could not execute external query: " + sql + "\nCause = " + e.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, stmt);
            throw throwable;
        }
        DB.close(rs, stmt);
        return tableName;
    }

    private String getAcctDetailTableName(int tableId) {
        String detailTableName = "";
        switch (tableId) {
            case 53121: {
                detailTableName = "A_Depreciation_Exp";
                break;
            }
            case 735: {
                detailTableName = "C_AllocationLine";
                break;
            }
            case 392: {
                detailTableName = "C_BankStatementLine";
                break;
            }
            case 407: {
                detailTableName = "C_CashLine";
                break;
            }
            case 318: {
                detailTableName = "C_InvoiceLine";
                break;
            }
            case 259: {
                detailTableName = "C_OrderLine";
                break;
            }
            case 623: {
                detailTableName = "C_ProjectIssue";
                break;
            }
            case 224: {
                detailTableName = "GL_JournalLine";
                break;
            }
            case 319: {
                detailTableName = "M_InOutLine";
                break;
            }
            case 321: {
                detailTableName = "M_InventoryLine";
                break;
            }
            case 323: {
                detailTableName = "M_MovementLine";
                break;
            }
            case 325: {
                detailTableName = "M_ProductionLine";
                break;
            }
            case 702: {
                detailTableName = "M_RequisitionLine";
                break;
            }
            case 53137: {
                break;
            }
            case 53127: {
                break;
            }
            case 53275: {
                break;
            }
            case 53128: {
                break;
            }
            case 472: {
                break;
            }
            case 473: {
                break;
            }
            case 335: {
                break;
            }
            default: {
                this.log.warning("Fact_Acct.Line_ID detail table not identified for table ID = " + tableId);
            }
        }
        return detailTableName;
    }

    private void checkSequences() {
        if (this.p_isPreserveAll) {
            for (String tableName : this.p_tablesVerifiedList) {
                MSequence seq = MSequence.get(this.getCtx(), tableName, this.get_TrxName());
                if (seq == null) continue;
                seq.validateTableIDValue();
            }
        } else {
            for (String tableName : this.p_tablesToPreserveIDsList) {
                MSequence seq = MSequence.get(this.getCtx(), tableName, this.get_TrxName());
                if (seq == null) continue;
                seq.validateTableIDValue();
            }
        }
    }

    private Object getLocalKeyFor(String tableName, Object foreign_Key, String tableNameSource) {
        String uuidCol = PO.getUUIDColumnName(tableName);
        MTable table2 = MTable.get(this.getCtx(), tableName);
        String remoteUUID = null;
        if (!table2.isIDKeyTable()) {
            remoteUUID = foreign_Key.toString();
        } else {
            StringBuilder sqlRemoteUUSB = new StringBuilder().append("SELECT ").append(uuidCol).append(" FROM ").append(tableName).append(" WHERE ").append(tableName).append("_ID=?");
            String sqlRemoteUU = DB.getDatabase().convertStatement(sqlRemoteUUSB.toString());
            PreparedStatement stmtUU = null;
            ResultSet rs = null;
            try {
                try {
                    stmtUU = this.externalConn.prepareStatement(sqlRemoteUU, 1003, 1007);
                    stmtUU.setObject(1, foreign_Key);
                    rs = stmtUU.executeQuery();
                    if (rs.next()) {
                        remoteUUID = rs.getString(1);
                    }
                }
                catch (SQLException e) {
                    throw new AdempiereException("Could not execute external query for table " + tableNameSource + ": " + sqlRemoteUU + "\nCause = " + e.getLocalizedMessage());
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, stmtUU);
                throw throwable;
            }
            DB.close(rs, stmtUU);
        }
        Object local_Key = null;
        if (remoteUUID != null) {
            local_Key = this.getFromUUID(tableName, uuidCol, null, null, remoteUUID, foreign_Key);
        }
        return local_Key;
    }

    private Object getFromUUID(String foreignTableName, String uuidCol, String tableName, String columnName, String foreignUU, Object foreign_Key) {
        Object local_Key = null;
        MTable foreignTable = MTable.get(this.getCtx(), foreignTableName);
        StringBuilder sqlCheckLocalUU = new StringBuilder("SELECT ");
        if (foreignTable.isUUIDKeyTable()) {
            sqlCheckLocalUU.append(PO.getUUIDColumnName(foreignTableName));
        } else {
            sqlCheckLocalUU.append(foreignTableName).append("_ID");
        }
        sqlCheckLocalUU.append(" FROM ").append(foreignTableName).append(" WHERE ").append(uuidCol).append("=?");
        List<Object> list = DB.getSQLValueObjectsEx(this.get_TrxName(), sqlCheckLocalUU.toString(), foreignUU);
        if (list != null && list.size() == 1) {
            local_Key = list.get(0);
        }
        String identifier = null;
        if (local_Key == null || local_Key instanceof Number && ((Number)local_Key).intValue() < 0) {
            FallbackRecord fr = MoveClient.getFallbackRecordByTableName(this.p_fallbackRecords, foreignTableName, foreignUU);
            PO po = null;
            if (fr != null) {
                po = fr.getPO();
            }
            if (po == null) {
                String missingFk = foreignTableName + "." + uuidCol + "=" + foreignUU;
                this.p_errorList.add("Column " + tableName + "." + columnName + " has system reference not convertible, " + missingFk);
                if (!this.p_missingFkList.contains(missingFk)) {
                    this.p_missingFkList.add(missingFk);
                }
                return -1;
            }
            local_Key = foreignTable.isIDKeyTable() ? Integer.valueOf(po.get_ID()) : po.get_UUID();
            identifier = this.getIdentifierFromExternalRecord(foreignTable, foreign_Key);
            if (identifier != null && identifier.length() > 4000) {
                identifier = identifier.substring(0, 4000);
            }
        }
        DB.executeUpdateEx(insertConversionId, new Object[]{this.getAD_PInstance_ID(), foreignTableName.toUpperCase(), foreign_Key, local_Key, identifier}, this.get_TrxName());
        this.p_idSystemConversionList.add(foreignTableName.toUpperCase() + "." + String.valueOf(foreign_Key));
        return local_Key;
    }

    public List<FallbackRecord> parseFallbackRecordsString(String fallbackRecordsString) {
        String[] pairs;
        ArrayList<FallbackRecord> records = new ArrayList<FallbackRecord>();
        if (fallbackRecordsString == null || fallbackRecordsString.trim().isEmpty()) {
            return records;
        }
        String[] stringArray = pairs = fallbackRecordsString.split(",");
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            String pair = stringArray[n2];
            String[] parts = pair.split("=");
            if (parts.length == 2) {
                MTable table2;
                String tableName = parts[0].trim();
                String foreignUUID = null;
                if (tableName.contains(".")) {
                    foreignUUID = tableName.substring(tableName.indexOf(".") + 1);
                    tableName = tableName.substring(0, tableName.indexOf("."));
                }
                if ((table2 = MTable.get(this.getCtx(), tableName)) == null) {
                    throw new AdempiereUserError("Fallback Table " + tableName + " not found");
                }
                String id = parts[1].trim();
                int recordId = -1;
                PO po = null;
                if (Util.isUUID(id)) {
                    po = MTable.get(this.getCtx(), tableName).getPOByUU(id, this.get_TrxName());
                } else {
                    try {
                        recordId = Integer.parseInt(id);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new AdempiereUserError("Fallback ID " + id + " is not a valid number for table " + tableName);
                    }
                    po = MTable.get(this.getCtx(), tableName).getPO(recordId, this.get_TrxName());
                }
                if (po == null || po.is_new()) {
                    throw new AdempiereUserError("Fallback record " + id + " not found for table " + tableName);
                }
                records.add(new FallbackRecord(tableName, foreignUUID, po));
            }
            ++n2;
        }
        return records;
    }

    private String getIdentifierFromExternalRecord(MTable table2, Object key) {
        String mapKey = table2.getTableName() + "|" + key.toString();
        if (this.externalIdentifiersMap.containsKey(mapKey)) {
            return (String)this.externalIdentifiersMap.get(mapKey);
        }
        CharSequence[] columns = table2.getIdentifierColumns();
        if (columns.length == 0) {
            this.externalIdentifiersMap.put(mapKey, null);
            return null;
        }
        StringBuilder identifier = new StringBuilder();
        StringBuilder sqlSB = new StringBuilder("SELECT ").append(String.join((CharSequence)",", columns)).append(" FROM ").append(table2.getTableName()).append(" WHERE ");
        int recordId = -1;
        if (Util.isUUID(key.toString())) {
            sqlSB.append(PO.getUUIDColumnName(table2.getTableName()));
        } else {
            sqlSB.append(table2.getKeyColumns()[0]);
            recordId = Integer.valueOf(key.toString());
        }
        sqlSB.append("=?");
        String sql = DB.getDatabase().convertStatement(sqlSB.toString());
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = this.externalConn.prepareStatement(sql, 1003, 1007);
                if (recordId >= 0) {
                    stmt.setInt(1, recordId);
                } else {
                    stmt.setString(1, key.toString());
                }
                rs = stmt.executeQuery();
                if (rs.next()) {
                    int i = 0;
                    while (i < columns.length) {
                        String val = rs.getString(i + 1);
                        if (identifier.length() > 0) {
                            identifier.append(MSysConfig.getValue("IDENTIFIER_SEPARATOR", "_", Env.getAD_Client_ID(Env.getCtx())));
                        }
                        identifier.append(val);
                        ++i;
                    }
                }
            }
            catch (SQLException e) {
                throw new AdempiereException("Could not execute external query: " + sql + "\nCause = " + e.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, stmt);
            throw throwable;
        }
        DB.close(rs, stmt);
        String retValue = identifier.length() == 0 ? null : identifier.toString();
        this.externalIdentifiersMap.put(mapKey, retValue);
        return retValue;
    }

    public static FallbackRecord getFallbackRecordByTableName(List<FallbackRecord> records, String tableName, String foreignUUID) {
        FallbackRecord fr = records.stream().filter(fallbackRecord -> fallbackRecord.getTableName().equalsIgnoreCase(tableName) && foreignUUID != null && fallbackRecord.getForeignUUID() != null && foreignUUID.equals(fallbackRecord.getForeignUUID())).findFirst().orElse(null);
        if (fr == null) {
            fr = records.stream().filter(fallbackRecord -> fallbackRecord.getTableName().equalsIgnoreCase(tableName) && fallbackRecord.getForeignUUID() == null).findFirst().orElse(null);
        }
        return fr;
    }

    public class FallbackRecord {
        private final String tableName;
        private final String foreignUUID;
        private final PO po;

        public FallbackRecord(String tableName, String foreignUUID, PO po) {
            this.tableName = tableName;
            this.foreignUUID = foreignUUID;
            this.po = po;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getForeignUUID() {
            return this.foreignUUID;
        }

        public PO getPO() {
            return this.po;
        }
    }
}

