/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Scheduler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.adempiere.base.Core;
import org.compiere.model.SystemProperties;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CacheChangeListener;
import org.compiere.util.CacheInfo;
import org.compiere.util.CacheInterface;
import org.compiere.util.CacheNewRecordCallable;
import org.compiere.util.ResetCacheCallable;
import org.idempiere.distributed.ICacheService;
import org.idempiere.distributed.IClusterMember;
import org.idempiere.distributed.IClusterService;

public class CacheMgt {
    private static CacheMgt s_cache;
    private ArrayList<CacheInterface> m_instances = new ArrayList();
    private ArrayList<String> m_tableNames = new ArrayList();
    private static CLogger log;
    private List<CacheChangeListener> m_listeners = new ArrayList<CacheChangeListener>();
    public static int MAX_SIZE;
    private static final Set<String> suspendedResetCacheTables;

    static {
        block5: {
            s_cache = null;
            log = CLogger.getCLogger(CacheMgt.class);
            MAX_SIZE = 1000;
            try {
                String maxSize = SystemProperties.getCacheMaxSize();
                if (maxSize == null || maxSize.trim().length() <= 0) break block5;
                int max = 0;
                try {
                    max = Integer.parseInt(maxSize.trim());
                }
                catch (Throwable throwable) {}
                if (max > 0) {
                    MAX_SIZE = max;
                }
            }
            catch (Throwable throwable) {}
        }
        suspendedResetCacheTables = ConcurrentHashMap.newKeySet();
    }

    public static synchronized CacheMgt get() {
        if (s_cache == null) {
            s_cache = new CacheMgt();
        }
        return s_cache;
    }

    private CacheMgt() {
    }

    public synchronized <K, V> Map<K, V> register(CCache<K, V> instance, boolean distributed) {
        IClusterService clusterService;
        ICacheService provider;
        if (instance == null) {
            return null;
        }
        String name = instance.getName();
        String tableName = instance.getTableName();
        if (tableName != null) {
            this.m_tableNames.add(tableName);
        }
        this.m_instances.add(instance);
        if (tableName == null && instance instanceof CacheChangeListener) {
            this.m_listeners.add((CacheChangeListener)((Object)instance));
        }
        Map map = null;
        if (distributed && (provider = Core.getCacheService()) != null && (clusterService = Core.getClusterService()) != null && !clusterService.isStandAlone()) {
            map = provider.getMap(name);
        }
        if (map == null) {
            int maxSize = instance.getMaxSize();
            if (maxSize > 0 || instance.getExpireMinutes() > 0) {
                Caffeine builder = Caffeine.newBuilder();
                if (maxSize > 0) {
                    builder.maximumSize((long)maxSize);
                }
                if (instance.getExpireMinutes() > 0) {
                    builder.scheduler(Scheduler.systemScheduler()).expireAfterAccess((long)instance.getExpireMinutes(), TimeUnit.MINUTES);
                }
                Cache cache = builder.build();
                map = cache.asMap();
            } else {
                map = new ConcurrentHashMap();
            }
        }
        return map;
    }

    public synchronized boolean unregister(CacheInterface instance) {
        if (instance == null) {
            return false;
        }
        boolean found = false;
        int i2 = this.m_instances.size() - 1;
        while (i2 >= 0) {
            CacheInterface stored = this.m_instances.get(i2);
            if (instance.equals(stored)) {
                this.m_instances.remove(i2);
                found = true;
            }
            --i2;
        }
        return found;
    }

    private int clusterReset() {
        return this.clusterReset(null, -1);
    }

    private int clusterReset(String tableName, int recordId) {
        return this.clusterResetInternal(tableName, recordId);
    }

    private int clusterReset(String tableName, String key) {
        return this.clusterResetInternal(tableName, key);
    }

    private <K> int clusterResetInternal(String tableName, K key) {
        int n;
        IClusterService service = Core.getClusterService();
        if (service != null) {
            int n2;
            ResetCacheCallable resetCacheCallable;
            if (key instanceof Integer) {
                Integer id = (Integer)key;
                resetCacheCallable = new ResetCacheCallable(tableName, id);
            } else {
                resetCacheCallable = new ResetCacheCallable(tableName, key.toString());
            }
            ResetCacheCallable callable = resetCacheCallable;
            Map<IClusterMember, Future<Integer>> futureMap = service.execute(callable, service.getMembers());
            if (futureMap != null) {
                int total = 0;
                try {
                    Collection<Future<Integer>> results = futureMap.values();
                    for (Future<Integer> i2 : results) {
                        total += i2.get().intValue();
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    if (e.getCause() != null) {
                        if (e.getCause() instanceof RuntimeException) {
                            throw (RuntimeException)e.getCause();
                        }
                        throw new RuntimeException(e.getCause());
                    }
                    throw new RuntimeException(e);
                }
                return total;
            }
            if (key instanceof Integer) {
                Integer id = (Integer)key;
                n2 = this.resetLocalCache(tableName, id);
            } else {
                n2 = this.resetLocalCache(tableName, key.toString());
            }
            return n2;
        }
        if (key instanceof Integer) {
            Integer id = (Integer)key;
            n = this.resetLocalCache(tableName, id);
        } else {
            n = this.resetLocalCache(tableName, key.toString());
        }
        return n;
    }

    private void clusterNewRecord(String tableName, int recordId) {
        IClusterService service = Core.getClusterService();
        if (service != null) {
            CacheNewRecordCallable callable = new CacheNewRecordCallable(tableName, recordId);
            if (service.execute(callable, service.getMembers()) == null) {
                this.localNewRecord(tableName, recordId);
            }
        } else {
            this.localNewRecord(tableName, recordId);
        }
    }

    public int reset() {
        return this.clusterReset();
    }

    public int reset(String tableName) {
        return this.reset(tableName, -1);
    }

    public int reset(String tableName, int Record_ID) {
        if (suspendedResetCacheTables.contains(tableName)) {
            return 0;
        }
        return this.clusterReset(tableName, Record_ID);
    }

    public int reset(String tableName, String key) {
        if (suspendedResetCacheTables.contains(tableName)) {
            return 0;
        }
        return this.clusterReset(tableName, key);
    }

    public int resetLocalCache() {
        CacheInterface[] instances;
        int counter = 0;
        int total = 0;
        CacheInterface[] cacheInterfaceArray = instances = this.getInstancesAsArray();
        int n = instances.length;
        int n2 = 0;
        while (n2 < n) {
            CacheInterface stored = cacheInterfaceArray[n2];
            if (stored != null && stored.size() > 0) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(stored.toString());
                }
                total += stored.reset();
                ++counter;
            }
            ++n2;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("#" + counter + " (" + total + ")");
        }
        return total;
    }

    public synchronized CacheInterface[] getInstancesAsArray() {
        return this.m_instances.toArray(new CacheInterface[0]);
    }

    protected int resetLocalCache(String tableName, Integer recordId) {
        return this.resetLocalCacheInternal(tableName, recordId);
    }

    protected int resetLocalCache(String tableName, String key) {
        return this.resetLocalCacheInternal(tableName, key);
    }

    private <K> int resetLocalCacheInternal(String tableName, K key) {
        CacheChangeListener[] listeners;
        Integer id;
        CacheInterface[] instances;
        if (tableName == null) {
            return this.resetLocalCache();
        }
        if (!this.m_tableNames.contains(tableName)) {
            return 0;
        }
        int counter = 0;
        int total = 0;
        CacheInterface[] cacheInterfaceArray = instances = this.getInstancesAsArray();
        int n = instances.length;
        int n2 = 0;
        while (n2 < n) {
            CCache cc;
            CacheInterface stored = cacheInterfaceArray[n2];
            if (stored != null && stored instanceof CCache && stored.size() > 0 && (cc = (CCache)stored).getTableName() != null && cc.getTableName().equalsIgnoreCase(tableName)) {
                int n3;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("(all) - " + String.valueOf(stored));
                }
                if (key instanceof Integer) {
                    id = (Integer)key;
                    n3 = stored.reset(id);
                } else {
                    n3 = stored.resetByStringKey(key.toString());
                }
                total += n3;
                ++counter;
            }
            ++n2;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(tableName + ": #" + counter + " (" + total + ")");
        }
        CacheChangeListener[] cacheChangeListenerArray = listeners = this.m_listeners.toArray(new CacheChangeListener[0]);
        int n4 = listeners.length;
        n = 0;
        while (n < n4) {
            CacheChangeListener listener = cacheChangeListenerArray[n];
            if (key instanceof Integer && (id = (Integer)key) == -1 || key.toString().length() == 0) {
                listener.reset(tableName);
            } else {
                listener.reset(tableName, key.toString());
            }
            ++n;
        }
        return total;
    }

    protected void localNewRecord(String tableName, int Record_ID) {
        CacheInterface[] instances;
        if (tableName == null) {
            return;
        }
        if (!this.m_tableNames.contains(tableName)) {
            return;
        }
        CacheInterface[] cacheInterfaceArray = instances = this.getInstancesAsArray();
        int n = instances.length;
        int n2 = 0;
        while (n2 < n) {
            CCache cc;
            CacheInterface stored = cacheInterfaceArray[n2];
            if (stored != null && stored instanceof CCache && (cc = (CCache)stored).getTableName() != null && cc.getTableName().equalsIgnoreCase(tableName)) {
                stored.newRecord(Record_ID);
            }
            ++n2;
        }
    }

    public int getElementCount() {
        CacheInterface[] instances;
        int total = 0;
        CacheInterface[] cacheInterfaceArray = instances = this.getInstancesAsArray();
        int n = instances.length;
        int n2 = 0;
        while (n2 < n) {
            CacheInterface stored = cacheInterfaceArray[n2];
            if (stored != null && stored.size() > 0) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(stored.toString());
                }
                total = stored instanceof CCache ? (total += ((CCache)stored).sizeNoExpire()) : (total += stored.size());
            }
            ++n2;
        }
        return total;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CacheMgt[");
        sb.append("Instances=").append(this.m_instances.size()).append("]");
        return sb.toString();
    }

    public String toStringX() {
        StringBuilder sb = new StringBuilder("CacheMgt[");
        sb.append("Instances=").append(this.m_instances.size()).append(", Elements=").append(this.getElementCount()).append("]");
        return sb.toString();
    }

    public void newRecord(String tableName, int recordId) {
        if (suspendedResetCacheTables.contains(tableName)) {
            return;
        }
        this.clusterNewRecord(tableName, recordId);
    }

    public List<CacheInfo> getCacheInfos() {
        CacheInterface[] instances;
        ArrayList<CacheInfo> infos = new ArrayList<CacheInfo>();
        CacheInterface[] cacheInterfaceArray = instances = this.getInstancesAsArray();
        int n = instances.length;
        int n2 = 0;
        while (n2 < n) {
            CacheInterface ci = cacheInterfaceArray[n2];
            if (ci instanceof CCache) {
                infos.add(new CacheInfo((CCache)ci));
            }
            ++n2;
        }
        return infos;
    }

    public boolean hasCache(String tableName) {
        return this.m_tableNames.contains(tableName);
    }

    public void suspendTableCacheReset(String tableName) {
        suspendedResetCacheTables.add(tableName);
    }

    public void resumeTableCacheReset(String tableName) {
        suspendedResetCacheTables.remove(tableName);
    }
}

