/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.compiere.model.MElementValue;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.Ini;
import org.compiere.util.Util;

public final class NaturalAccountMap<K, V>
extends CCache<K, V> {
    private static final long serialVersionUID = -2193338049120937392L;
    private Properties m_ctx = null;
    private String m_trxName = null;
    private HashMap<String, MElementValue> m_valueMap = new HashMap();
    private static CLogger log = CLogger.getCLogger(NaturalAccountMap.class);

    public NaturalAccountMap(Properties ctx, String trxName) {
        super(null, "NaturalAccountMap", 100, false);
        this.m_ctx = ctx;
        this.m_trxName = trxName;
    }

    public String parseFile(File file) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config(file.getAbsolutePath());
        }
        String line = null;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Ini.getCharset()), 10240);){
                String errMsg = "";
                int lineNo = 1;
                while ((line = in.readLine()) != null && errMsg.length() == 0) {
                    errMsg = this.parseLine(line, lineNo);
                    ++lineNo;
                }
                line = null;
                if (errMsg.length() != 0) {
                    return errMsg;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ioe) {
            String s = ioe.getLocalizedMessage();
            if (s == null || s.length() == 0) {
                s = ioe.toString();
            }
            return "Parse Error: Line=" + line + " - " + s;
        }
        return "";
    }

    public String parseLine(String line, int lineNo) throws Exception {
        if (log.isLoggable(Level.CONFIG)) {
            log.config(lineNo + " : " + line);
        }
        if (line.trim().length() == 0) {
            log.log(Level.WARNING, "Line " + lineNo + " is empty, ignored. ");
            return "";
        }
        StringBuilder newLine = new StringBuilder();
        StringTokenizer st = new StringTokenizer(line, "\"", false);
        if (st == null || st.countTokens() == 0) {
            log.log(Level.SEVERE, "Parse error: No \\\" found in line: " + lineNo);
            return "";
        }
        newLine.append(st.nextToken());
        while (st.hasMoreElements()) {
            String s = st.nextToken();
            newLine.append(s.replace(',', ' '));
            if (!st.hasMoreTokens()) continue;
            newLine.append(st.nextToken());
        }
        newLine.append(" ");
        String pLine = Util.replace(newLine.toString(), ",,", ", ,");
        pLine = Util.replace(pLine, ",,", ", ,");
        st = new StringTokenizer(pLine, ",", false);
        if (st.countTokens() == 1) {
            log.log(Level.SEVERE, "Ignored: Require ',' as separator - " + pLine);
            return "";
        }
        if (st.countTokens() < 9) {
            log.log(Level.SEVERE, "Ignored: FieldNumber wrong: " + st.countTokens() + " - " + pLine);
            return "";
        }
        String Value = null;
        String Name = null;
        String Description = null;
        String AccountType = null;
        String AccountSign = null;
        String IsDocControlled = null;
        String IsSummary = null;
        String Default_Account = null;
        int i = 0;
        while (i < 8 && st.hasMoreTokens()) {
            String s = st.nextToken().trim();
            if (s == null) {
                s = "";
            }
            if (s.startsWith("[") && s.endsWith("]")) {
                return "";
            }
            if (i == 0) {
                Value = s;
            } else if (i == 1) {
                Name = s;
            } else if (i == 2) {
                Description = s;
            } else if (i == 3) {
                AccountType = s.length() > 0 ? String.valueOf(s.charAt(0)) : "E";
            } else if (i == 4) {
                AccountSign = s.length() > 0 ? String.valueOf(s.charAt(0)) : "N";
            } else if (i == 5) {
                IsDocControlled = s.length() > 0 ? String.valueOf(s.charAt(0)) : "N";
            } else if (i == 6) {
                IsSummary = s.length() > 0 ? String.valueOf(s.charAt(0)) : "N";
            } else if (i == 7) {
                Default_Account = s;
            }
            ++i;
        }
        if (!(Value != null && Value.length() != 0 || Name != null && Name.length() != 0)) {
            return "";
        }
        if (Default_Account == null || Default_Account.length() == 0) {
            return "";
        }
        if (IsSummary == null || IsSummary.length() == 0) {
            IsSummary = "N";
        }
        if (!"SUMMARY".equals(Default_Account) && !IsSummary.equals("N")) {
            return "";
        }
        if (AccountType == null || AccountType.length() == 0) {
            AccountType = "E";
        }
        if (AccountSign == null || AccountSign.length() == 0) {
            AccountSign = "N";
        }
        if (IsDocControlled == null || IsDocControlled.length() == 0) {
            IsDocControlled = "N";
        }
        try {
            MElementValue na = this.m_valueMap.get(Value);
            if (na == null) {
                na = new MElementValue(this.m_ctx, Value, Name, Description, AccountType, AccountSign, IsDocControlled.toUpperCase().startsWith("Y"), IsSummary.toUpperCase().startsWith("Y"), this.m_trxName);
                this.m_valueMap.put(Value, na);
            }
            this.put(Default_Account.toUpperCase(), na);
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return "";
    }

    public boolean saveAccounts(int AD_Client_ID, int AD_Org_ID, int C_Element_ID, boolean isActive) {
        log.config("");
        for (MElementValue na : this.values()) {
            na.setAD_Client_ID(AD_Client_ID);
            na.setAD_Org_ID(AD_Org_ID);
            na.setC_Element_ID(C_Element_ID);
            na.setIsActive(isActive);
            if (na.save()) continue;
            return false;
        }
        return true;
    }

    public int getC_ElementValue_ID(String key) {
        MElementValue na = (MElementValue)this.get(key);
        if (na == null) {
            return 0;
        }
        return na.getC_ElementValue_ID();
    }
}

