/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRBaseHyperlink
implements JRHyperlink,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected String linkType;
    protected String linkTarget;
    protected JRExpression hyperlinkReferenceExpression;
    protected JRExpression hyperlinkWhenExpression;
    protected JRExpression hyperlinkAnchorExpression;
    protected JRExpression hyperlinkPageExpression;
    protected JRExpression hyperlinkTooltipExpression;
    protected JRHyperlinkParameter[] hyperlinkParameters;
    private byte hyperlinkTarget;

    public JRBaseHyperlink() {
    }

    protected JRBaseHyperlink(JRHyperlink link, JRBaseObjectFactory factory) {
        factory.put(link, this);
        this.linkType = link.getLinkType();
        this.linkTarget = link.getLinkTarget();
        this.hyperlinkReferenceExpression = factory.getExpression(link.getHyperlinkReferenceExpression());
        this.hyperlinkWhenExpression = factory.getExpression(link.getHyperlinkWhenExpression());
        this.hyperlinkAnchorExpression = factory.getExpression(link.getHyperlinkAnchorExpression());
        this.hyperlinkPageExpression = factory.getExpression(link.getHyperlinkPageExpression());
        this.hyperlinkTooltipExpression = factory.getExpression(link.getHyperlinkTooltipExpression());
        this.hyperlinkParameters = JRBaseHyperlink.copyHyperlinkParameters(link, factory);
    }

    public static JRHyperlinkParameter[] copyHyperlinkParameters(JRHyperlink link, JRBaseObjectFactory factory) {
        JRHyperlinkParameter[] linkParameters = link.getHyperlinkParameters();
        JRHyperlinkParameter[] parameters = null;
        if (linkParameters != null && linkParameters.length > 0) {
            parameters = new JRHyperlinkParameter[linkParameters.length];
            for (int i = 0; i < linkParameters.length; ++i) {
                JRHyperlinkParameter parameter = linkParameters[i];
                parameters[i] = factory.getHyperlinkParameter(parameter);
            }
        }
        return parameters;
    }

    @Override
    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    @Override
    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    @Override
    public JRHyperlinkParameter[] getHyperlinkParameters() {
        return this.hyperlinkParameters;
    }

    @Override
    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    @Override
    public JRExpression getHyperlinkWhenExpression() {
        return this.hyperlinkWhenExpression;
    }

    @Override
    public byte getHyperlinkTarget() {
        return this.getHyperlinkTargetValue().getValue();
    }

    @Override
    public HyperlinkTargetEnum getHyperlinkTargetValue() {
        return JRHyperlinkHelper.getHyperlinkTargetValue(this);
    }

    public byte getHyperlinkType() {
        return this.getHyperlinkTypeValue().getValue();
    }

    @Override
    public HyperlinkTypeEnum getHyperlinkTypeValue() {
        return JRHyperlinkHelper.getHyperlinkTypeValue(this);
    }

    @Override
    public String getLinkType() {
        return this.linkType;
    }

    @Override
    public String getLinkTarget() {
        return this.linkTarget;
    }

    @Override
    public JRExpression getHyperlinkTooltipExpression() {
        return this.hyperlinkTooltipExpression;
    }

    @Override
    public Object clone() {
        JRBaseHyperlink clone = null;
        try {
            clone = (JRBaseHyperlink)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        clone.hyperlinkParameters = (JRHyperlinkParameter[])JRCloneUtils.cloneArray((JRCloneable[])this.hyperlinkParameters);
        clone.hyperlinkReferenceExpression = JRCloneUtils.nullSafeClone(this.hyperlinkReferenceExpression);
        clone.hyperlinkWhenExpression = JRCloneUtils.nullSafeClone(this.hyperlinkWhenExpression);
        clone.hyperlinkAnchorExpression = JRCloneUtils.nullSafeClone(this.hyperlinkAnchorExpression);
        clone.hyperlinkPageExpression = JRCloneUtils.nullSafeClone(this.hyperlinkPageExpression);
        clone.hyperlinkTooltipExpression = JRCloneUtils.nullSafeClone(this.hyperlinkTooltipExpression);
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.linkTarget == null) {
            this.linkTarget = JRHyperlinkHelper.getLinkTarget(HyperlinkTargetEnum.getByValue(this.hyperlinkTarget));
        }
    }
}

