/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl.undo;

import io.keikai.api.CellOperationUtil;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.Sheet;
import io.keikai.ui.impl.undo.AbstractEditTextAction;

public class CellRichTextAction
extends AbstractEditTextAction {
    private static final long serialVersionUID = 2048936590673390771L;
    private final String _richText;
    private final CellOperationUtil.CellStyleApplier _applier;

    public CellRichTextAction(String label, Sheet sheet, int row, int column, int lastRow, int lastColumn, String editText) {
        super(label, sheet, row, column, lastRow, lastColumn);
        this._richText = editText;
        this._applier = null;
    }

    public CellRichTextAction(String label, Sheet sheet, int row, int column, int lastRow, int lastColumn, CellOperationUtil.CellStyleApplier applier) {
        super(label, sheet, row, column, lastRow, lastColumn);
        this._richText = null;
        this._applier = applier;
    }

    @Override
    protected void applyAction() {
        boolean protect = this.isSheetProtected();
        if (!protect) {
            Range r = Ranges.range(this._sheet, this._row, this._column, this._lastRow, this._lastColumn);
            if (this._richText != null) {
                r.setCellRichText(this._richText);
                CellOperationUtil.fitFontHeightPoints(r);
            } else if (this._applier != null) {
                this._applier.apply(r);
            }
        }
    }
}

