/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation.steps.engine;

import com.hazelcast.core.Offloadable;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.map.impl.operation.ForcedEviction;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.operation.steps.UtilSteps;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.memory.NativeOutOfMemoryError;
import com.hazelcast.spi.impl.PartitionSpecificRunnable;
import com.hazelcast.spi.impl.operationservice.impl.OperationRunnerImpl;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class StepSupplier
implements Supplier<Runnable> {
    private final State state;
    private final OperationRunnerImpl operationRunner;
    private volatile Runnable currentRunnable;
    private volatile Step currentStep;
    private volatile boolean firstStep = true;
    private final boolean checkCurrentThread;

    public StepSupplier(MapOperation operation) {
        this(operation, true);
    }

    public StepSupplier(MapOperation operation, boolean checkCurrentThread) {
        assert (operation != null);
        this.state = operation.createState();
        Step injectedStep = operation.getRecordStore().getStorage().newInjectedStep();
        Step currentFirstStep = operation.getStartingStep();
        this.currentStep = injectedStep == null ? currentFirstStep : StepSupplier.setAndGetInjectedStepAsFirstStep(currentFirstStep, injectedStep);
        this.operationRunner = UtilSteps.getPartitionOperationRunner(this.state);
        this.checkCurrentThread = checkCurrentThread;
        assert (this.state != null);
        assert (this.currentStep != null);
    }

    private static Step setAndGetInjectedStepAsFirstStep(final Step currentStep, final Step injectedStep) {
        return new Step<State>(){

            @Override
            public boolean isOffloadStep(State state) {
                return injectedStep.isOffloadStep(state);
            }

            @Override
            public void runStep(State state) {
                injectedStep.runStep(state);
            }

            @Override
            public String getExecutorName(State state) {
                return injectedStep.getExecutorName(state);
            }

            @Override
            @Nullable
            public Step nextStep(State state) {
                return currentStep;
            }
        };
    }

    @Override
    public Runnable get() {
        if (this.currentRunnable == null && this.currentStep != null) {
            this.currentRunnable = this.createRunnable(this.currentStep, this.state);
        }
        return this.currentRunnable;
    }

    private Runnable createRunnable(final Step step, final State state) {
        if (step == null) {
            return null;
        }
        if (step.isOffloadStep(state)) {
            return new ExecutorNameAwareRunnable(){

                @Override
                public String getExecutorName() {
                    return step.getExecutorName(state);
                }

                @Override
                public void run() {
                    if (StepSupplier.this.checkCurrentThread) assert (!ThreadUtil.isRunningOnPartitionThread());
                    StepSupplier.this.runStepWithState(step, state);
                }

                public String toString() {
                    return step.toString();
                }
            };
        }
        return new PartitionSpecificRunnable(){

            @Override
            public void run() {
                if (StepSupplier.this.checkCurrentThread) assert (ThreadUtil.isRunningOnPartitionThread());
                StepSupplier.this.runStepWithState(step, state);
            }

            @Override
            public int getPartitionId() {
                return state.getPartitionId();
            }

            public String toString() {
                return step.toString();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runStepWithState(Step step, State state) {
        boolean runningOnPartitionThread = ThreadUtil.isRunningOnPartitionThread();
        boolean metWithPreconditions = true;
        try {
            state.getRecordStore().beforeOperation();
            try {
                if (runningOnPartitionThread && state.getThrowable() == null) {
                    metWithPreconditions = this.metWithPreconditions();
                }
                if (metWithPreconditions) {
                    step.runStep(state);
                }
            }
            catch (NativeOutOfMemoryError e) {
                ThreadUtil.assertRunningOnPartitionThread();
                this.rerunWithForcedEviction(() -> step.runStep(state));
            }
            finally {
                state.getRecordStore().afterOperation();
            }
        }
        catch (Throwable throwable) {
            if (runningOnPartitionThread) {
                state.getOperation().disposeDeferredBlocks();
            }
            state.setThrowable(throwable);
        }
        finally {
            if (metWithPreconditions) {
                this.currentStep = this.nextStep(step);
                this.currentRunnable = this.createRunnable(this.currentStep, state);
            } else {
                this.currentStep = null;
                this.currentRunnable = null;
            }
        }
    }

    private boolean metWithPreconditions() {
        assert (ThreadUtil.isRunningOnPartitionThread());
        this.operationRunner.ensureNodeAndClusterHealth(this.state.getOperation());
        if (this.firstStep) {
            assert (this.firstStep);
            this.firstStep = false;
            return !this.operationRunner.timeout(this.state.getOperation());
        }
        return true;
    }

    private Step nextStep(Step step) {
        if (this.state.getThrowable() != null && this.currentStep != UtilSteps.HANDLE_ERROR) {
            return UtilSteps.HANDLE_ERROR;
        }
        return step.nextStep(this.state);
    }

    private void rerunWithForcedEviction(Runnable step) {
        ForcedEviction.runStepWithForcedEvictionStrategies(this.state.getOperation(), step);
    }

    public void handleOperationError(Throwable throwable) {
        this.state.setThrowable(throwable);
        this.currentRunnable = null;
        this.currentStep = UtilSteps.HANDLE_ERROR;
    }

    public MapOperation getOperation() {
        return this.state.getOperation();
    }

    private static interface ExecutorNameAwareRunnable
    extends Runnable,
    Offloadable {
    }
}

