/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.db.postgresql.partition;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.db.DB_PostgreSQL;
import org.compiere.db.partition.ITablePartitionService;
import org.compiere.db.partition.RangePartitionColumn;
import org.compiere.db.partition.RangePartitionInterval;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.model.X_AD_TablePartition;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;

public class TablePartitionService
implements ITablePartitionService {
    public boolean isPartitionedTable(MTable table, String trxName) {
        String sql = "\tSELECT 1 FROM pg_partitioned_table\n\tJOIN pg_class parent ON pg_partitioned_table.partrelid = parent.oid\n\tWHERE LOWER(relname) = LOWER(?)\n";
        return DB.getSQLValueEx((String)trxName, (String)sql, (Object[])new Object[]{table.getTableName()}) == 1;
    }

    public String getDefaultPartitionName(MTable table) {
        return this.getDefaultPartitionName(table.getTableName());
    }

    public String getDefaultPartitionName(String tableName) {
        return tableName + "_default_partition";
    }

    private boolean renameOriginalTable(MTable table, String trxName, ProcessInfo processInfo) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ").append(table.getTableName()).append(" RENAME TO ").append(this.getDefaultPartitionName(table));
        DB.executeUpdateEx((String)sql.toString(), (String)trxName);
        if (processInfo != null) {
            processInfo.addLog(0, null, null, sql.toString());
        }
        return true;
    }

    private boolean migrateDBContrainsts(MTable table, String trxName, ProcessInfo pi) {
        StringBuilder alterStmt;
        String constraint_definition;
        String constraint_name;
        ResultSet rs;
        CPreparedStatement pstmt;
        Object var8_12;
        String sql = "\tSELECT COUNT(*)\n\tFROM pg_constraint c\n\tWHERE conrelid = LOWER(?)::regclass\n";
        int count = DB.getSQLValueEx((String)trxName, (String)sql, (Object[])new Object[]{table.getTableName()});
        if (count > 0) {
            return true;
        }
        List partitionKeyColumnNames = table.getPartitionKeyColumnNames();
        sql = "\tSELECT conname AS constraint_name,\n\tpg_get_constraintdef(c.oid) AS constraint_definition\n\tFROM pg_constraint c\n\tWHERE conrelid = LOWER(?)::regclass\n\tORDER BY conname\n";
        try {
            Throwable throwable = null;
            var8_12 = null;
            try {
                pstmt = DB.prepareStatement((String)sql, (String)trxName);
                try {
                    pstmt.setString(1, this.getDefaultPartitionName(table));
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        constraint_name = rs.getString("constraint_name");
                        constraint_definition = rs.getString("constraint_definition");
                        if (!constraint_definition.startsWith("PRIMARY KEY ") && !constraint_definition.startsWith("UNIQUE ")) continue;
                        alterStmt = new StringBuilder();
                        alterStmt.append("ALTER TABLE ").append(this.getDefaultPartitionName(table)).append(" ");
                        alterStmt.append("DROP CONSTRAINT ").append(constraint_name).append(" CASCADE");
                        DB.executeUpdateEx((String)alterStmt.toString(), (String)trxName);
                        if (pi != null) {
                            pi.addLog(0, null, null, alterStmt.toString());
                        }
                        ArrayList<String> lowerCasePartitionKeyColumnNames = new ArrayList<String>();
                        for (String partitionKeyColumnName : partitionKeyColumnNames) {
                            lowerCasePartitionKeyColumnNames.add(partitionKeyColumnName.toLowerCase());
                        }
                        String constraintColumnsStr = constraint_definition.substring(constraint_definition.indexOf("(") + 1, constraint_definition.length() - 1);
                        StringTokenizer st = new StringTokenizer(constraintColumnsStr, ",");
                        while (st.hasMoreTokens()) {
                            String token = st.nextToken().trim();
                            if (!lowerCasePartitionKeyColumnNames.contains(token)) continue;
                            lowerCasePartitionKeyColumnNames.remove(token);
                        }
                        alterStmt = new StringBuilder();
                        alterStmt.append("ALTER TABLE ").append(table.getTableName()).append(" ");
                        alterStmt.append("ADD CONSTRAINT ").append(constraint_name).append(" ");
                        alterStmt.append(constraint_definition.substring(0, constraint_definition.length() - 1));
                        int x = 0;
                        while (x < lowerCasePartitionKeyColumnNames.size()) {
                            alterStmt.append(", ").append((String)lowerCasePartitionKeyColumnNames.get(x));
                            ++x;
                        }
                        alterStmt.append(")");
                        DB.executeUpdateEx((String)alterStmt.toString(), (String)trxName);
                        if (pi == null) continue;
                        pi.addLog(0, null, null, alterStmt.toString());
                    }
                }
                finally {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Exception)e);
        }
        try {
            Throwable e = null;
            var8_12 = null;
            try {
                pstmt = DB.prepareStatement((String)sql, (String)trxName);
                try {
                    pstmt.setString(1, this.getDefaultPartitionName(table));
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        constraint_name = rs.getString("constraint_name");
                        constraint_definition = rs.getString("constraint_definition");
                        if (!constraint_definition.startsWith("CHECK ") && !constraint_definition.startsWith("FOREIGN KEY ")) continue;
                        if (constraint_definition.indexOf(this.getDefaultPartitionName(table).toLowerCase()) >= 0) {
                            constraint_definition = constraint_definition.replace(this.getDefaultPartitionName(table).toLowerCase(), table.getTableName().toLowerCase());
                        }
                        alterStmt = new StringBuilder();
                        alterStmt.append("ALTER TABLE ").append(table.getTableName()).append(" ");
                        alterStmt.append("ADD CONSTRAINT ").append(constraint_name).append(" ");
                        alterStmt.append(constraint_definition);
                        DB.executeUpdateEx((String)alterStmt.toString(), (String)trxName);
                        if (pi == null) continue;
                        pi.addLog(0, null, null, alterStmt.toString());
                    }
                }
                finally {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (SQLException e) {
            throw new DBException((Exception)e);
        }
        return true;
    }

    private boolean migrateDBIndexes(MTable table, String trxName, ProcessInfo pi) {
        String conindid;
        String consql;
        Object indexdef;
        String indexs = "\tselect indexname, indexdef\n\tfrom pg_indexes\n\twhere schemaname='adempiere'\n\tand tablename=?;\n";
        HashMap<String, String> indexMap = new HashMap<String, String>();
        HashMap<String, String> uniqueMap = new HashMap<String, String>();
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (CPreparedStatement stmt = DB.prepareStatement((String)indexs, (String)trxName);){
                stmt.setString(1, this.getDefaultPartitionName(table).toLowerCase());
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    String indexName = rs.getString(1);
                    indexdef = rs.getString(2);
                    boolean unique = ((String)indexdef).contains("UNIQUE INDEX");
                    if (unique) {
                        uniqueMap.put(indexName, (String)indexdef);
                        continue;
                    }
                    indexMap.put(indexName, (String)indexdef);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Exception)e);
        }
        List partitionKeyColumnNames = table.getPartitionKeyColumnNames();
        for (String indexName : uniqueMap.keySet()) {
            consql = "select conindid::regclass from pg_constraint where conrelid = ?::regclass and conindid = ?::regclass";
            conindid = DB.getSQLValueString((String)trxName, (String)consql, (Object[])new Object[]{table.getTableName().toLowerCase(), indexName.toLowerCase()});
            if (conindid != null && conindid.equalsIgnoreCase(indexName)) continue;
            indexdef = (String)uniqueMap.get(indexName);
            for (String partitionKey : partitionKeyColumnNames) {
                if (((String)indexdef).contains(partitionKey.toLowerCase() + ",") || ((String)indexdef).contains(partitionKey.toLowerCase() + ")")) continue;
                int whereIndex = ((String)indexdef).toLowerCase().indexOf(" where ");
                if (whereIndex > 0) {
                    String whereClause = ((String)indexdef).substring(whereIndex);
                    indexdef = ((String)indexdef).substring(0, whereIndex);
                    indexdef = ((String)indexdef).substring(0, ((String)indexdef).length() - 1) + ", " + partitionKey.toLowerCase() + ")";
                    indexdef = (String)indexdef + whereClause;
                    continue;
                }
                indexdef = ((String)indexdef).substring(0, ((String)indexdef).length() - 1) + ", " + partitionKey.toLowerCase() + ")";
            }
            StringBuilder alter = new StringBuilder("DROP INDEX ").append(indexName);
            DB.executeUpdateEx((String)alter.toString(), (String)trxName);
            if (pi != null) {
                pi.addLog(0, null, null, alter.toString());
            }
            indexdef = ((String)indexdef).replace(" ON adempiere." + this.getDefaultPartitionName(table).toLowerCase() + " ", " ON adempiere." + table.getTableName().toLowerCase() + " ");
            DB.executeUpdateEx((String)indexdef, (String)trxName);
            if (pi == null) continue;
            pi.addLog(0, null, null, (String)indexdef);
        }
        for (String indexName : indexMap.keySet()) {
            consql = "select conindid::regclass from pg_constraint where conrelid = ?::regclass and conindid = ?::regclass";
            conindid = DB.getSQLValueString((String)trxName, (String)consql, (Object[])new Object[]{table.getTableName().toLowerCase(), indexName.toLowerCase()});
            if (conindid != null && conindid.equalsIgnoreCase(indexName)) continue;
            indexdef = (String)indexMap.get(indexName);
            StringBuilder alter = new StringBuilder("DROP INDEX ").append(indexName);
            DB.executeUpdateEx((String)alter.toString(), (String)trxName);
            if (pi != null) {
                pi.addLog(0, null, null, alter.toString());
            }
            indexdef = ((String)indexdef).replace(" ON adempiere." + this.getDefaultPartitionName(table).toLowerCase() + " ", " ON adempiere." + table.getTableName().toLowerCase() + " ");
            DB.executeUpdateEx((String)indexdef, (String)trxName);
            if (pi == null) continue;
            pi.addLog(0, null, null, (String)indexdef);
        }
        return true;
    }

    private boolean attachDefaultPartition(MTable table, String trxName, ProcessInfo pi) {
        String sql = "\tSELECT COUNT(*)\n\tFROM pg_class base_tb\n\tJOIN pg_inherits i ON i.inhparent = base_tb.oid\n\tJOIN pg_class pt ON pt.oid = i.inhrelid\n\tWHERE base_tb.oid = LOWER(?)::regclass\n\tAND pt.relname = LOWER(?)\n";
        int count = DB.getSQLValueEx((String)trxName, (String)sql, (Object[])new Object[]{table.getTableName(), this.getDefaultPartitionName(table)});
        if (count > 0) {
            return true;
        }
        StringBuilder alterStmt = new StringBuilder();
        alterStmt.append("ALTER TABLE ").append(table.getTableName()).append(" ");
        alterStmt.append("ATTACH PARTITION ").append(this.getDefaultPartitionName(table)).append(" DEFAULT");
        DB.executeUpdateEx((String)alterStmt.toString(), (String)trxName);
        if (pi != null) {
            pi.addLog(0, null, null, alterStmt.toString());
        }
        table.createTablePartition(this.getDefaultPartitionName(table), "DEFAULT", trxName, (MColumn)table.getPartitionKeyColumns(false).get(0));
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean createPartitionedTable(MTable table, String trxName, ProcessInfo processInfo) {
        if (!this.renameOriginalTable(table, trxName, processInfo)) {
            throw new AdempiereException(Msg.getMsg((Properties)Env.getCtx(), (String)"FailedRenameOriginalTable"));
        }
        String sql = "\tSELECT table_schema, column_name, data_type,\n\tcharacter_maximum_length, numeric_precision, numeric_scale,\n\tis_nullable, column_default\n\tFROM information_schema.columns\n\tWHERE table_name = LOWER(?)\n\tORDER BY ordinal_position\n";
        StringBuilder createStmt = null;
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (CPreparedStatement pstmt = DB.prepareStatement((String)sql, (String)trxName);){
                MColumn partitionKeyColumn;
                block23: {
                    String partitioningMethod;
                    pstmt.setString(1, this.getDefaultPartitionName(table));
                    ResultSet rs = pstmt.executeQuery();
                    while (true) {
                        if (!rs.next()) {
                            if (createStmt == null) return false;
                            createStmt.append(") PARTITION BY ");
                            List partitionKeyColumns = table.getPartitionKeyColumns(false);
                            partitionKeyColumn = (MColumn)partitionKeyColumns.get(0);
                            partitioningMethod = partitionKeyColumn.getPartitioningMethod();
                            if (!partitioningMethod.equals("L")) break;
                            createStmt.append("List");
                            break block23;
                        }
                        String table_schema = rs.getString("table_schema");
                        String column_name = rs.getString("column_name");
                        String data_type = rs.getString("data_type");
                        int character_maximum_length = rs.getInt("character_maximum_length");
                        int numeric_precision = rs.getInt("numeric_precision");
                        int numeric_scale = rs.getInt("numeric_scale");
                        String is_nullable = rs.getString("is_nullable");
                        String column_default = rs.getString("column_default");
                        if (createStmt == null) {
                            createStmt = new StringBuilder();
                            createStmt.append("CREATE TABLE ").append(table_schema).append(".").append(table.getTableName()).append(" (");
                        } else {
                            createStmt.append(", ");
                        }
                        createStmt.append(column_name).append(" ").append(data_type);
                        if (data_type.equals("numeric") && numeric_precision > 0) {
                            createStmt.append("(").append(numeric_precision).append(",").append(numeric_scale).append(")");
                        } else if (data_type.startsWith("character") && character_maximum_length > 0) {
                            createStmt.append("(").append(character_maximum_length).append(")");
                        }
                        if ("NO".equals(is_nullable)) {
                            createStmt.append(" NOT NULL");
                        }
                        if (Util.isEmpty((String)column_default)) continue;
                        createStmt.append(" DEFAULT ").append(column_default);
                    }
                    if (!partitioningMethod.equals("R")) {
                        throw new IllegalArgumentException(Msg.getMsg((Properties)Env.getCtx(), (String)"PartitioningMethodNotSupported", (Object[])new Object[]{partitioningMethod}));
                    }
                    createStmt.append("Range");
                }
                createStmt.append(" (").append(partitionKeyColumn.getColumnName()).append(")");
                DB.executeUpdateEx((String)createStmt.toString(), (String)trxName);
                if (processInfo != null) {
                    processInfo.addLog(0, null, null, createStmt.toString());
                }
                if (!this.migrateDBContrainsts(table, trxName, processInfo)) {
                    throw new AdempiereException(Msg.getMsg((Properties)Env.getCtx(), (String)"FailedMigrateDatabaseConstraints"));
                }
                if (!this.migrateDBIndexes(table, trxName, processInfo)) {
                    throw new AdempiereException(Msg.getMsg((Properties)Env.getCtx(), (String)"FailedMigrateDatabaseConstraints"));
                }
                if (!this.attachDefaultPartition(table, trxName, processInfo)) {
                    throw new AdempiereException(Msg.getMsg((Properties)Env.getCtx(), (String)"FailedAttachDefaultPartition"));
                }
                this.fixView(table, trxName, processInfo);
                return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Exception)e);
        }
    }

    private void fixView(MTable table, String trxName, ProcessInfo pi) {
        String views = "with recursive depv(relname, viewoid, depth) as (\nselect distinct a.relname, a.oid, 1\n\tfrom pg_class a, pg_depend b, pg_depend c, pg_class d, pg_namespace\n\twhere a.oid = b.refobjid\n\tand b.objid = c.objid\n\tand b.refobjid <> c.refobjid\n\tand c.refobjid = d.oid\n\tand d.relname = ?\n\tand d.relkind = 'r'\n\tand a.relkind = 'v'\n\tand a.relnamespace = pg_namespace.oid\n\tand pg_namespace.nspname = lower('adempiere')\n  union all\nselect distinct dependee.relname, dependee.oid, depv.depth+1\n\tfrom pg_depend\n\tjoin pg_rewrite on pg_depend.objid = pg_rewrite.oid\n\tjoin pg_class as dependee on pg_rewrite.ev_class = dependee.oid\n\tjoin pg_class as dependent on pg_depend.refobjid = dependent.oid\n\tjoin pg_attribute ON pg_depend.refobjid = pg_attribute.attrelid and pg_depend.refobjsubid = pg_attribute.attnum and pg_attribute.attnum > 0\n\tjoin depv on dependent.relname = depv.relname\n\tjoin pg_namespace on dependee.relnamespace = pg_namespace.oid\nwhere pg_namespace.nspname = lower('adempiere')\n)\nselect relname, viewoid, max(depth) from depv group by relname, viewoid order by 3 desc\n";
        String defaultPartitionName = this.getDefaultPartitionName(table).toLowerCase();
        String tableName = table.getTableName().toLowerCase();
        ArrayList<String> viewTexts = new ArrayList<String>();
        ArrayList<String> viewNames = new ArrayList<String>();
        ArrayList<String> grants = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var11_13 = null;
            try (CPreparedStatement stmt = DB.prepareStatement((String)views, (String)trxName);){
                String viewName;
                stmt.setString(1, defaultPartitionName);
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    String viewName2 = rs.getString(1);
                    viewNames.add(viewName2);
                    int oid = rs.getInt(2);
                    String viewText = DB.getSQLValueString((String)trxName, (String)"SELECT pg_get_viewdef(?)", (int)oid);
                    viewTexts.add(viewText);
                }
                String grantSQL = "SELECT String_agg('grant ' || privilege_type || ' on ' || table_name || ' to \"' || grantee || '\"', '; ')\nFROM information_schema.role_table_grants\nWHERE table_name=?\tand table_schema='adempiere'\n";
                int i = 0;
                while (i < viewNames.size()) {
                    viewName = (String)viewNames.get(i);
                    Throwable throwable2 = null;
                    Object var18_22 = null;
                    try (CPreparedStatement stmt1 = DB.prepareStatement((String)grantSQL, (String)trxName);){
                        stmt1.setString(1, viewName.toLowerCase());
                        ResultSet rs1 = stmt1.executeQuery();
                        while (rs1.next()) {
                            grants.add(rs1.getString(1));
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                    StringBuilder dropStmt = new StringBuilder("DROP VIEW ").append(viewName);
                    DB.executeUpdateEx((String)dropStmt.toString(), (String)trxName);
                    if (pi != null) {
                        pi.addLog(0, null, null, dropStmt.toString());
                    }
                    ++i;
                }
                i = viewNames.size() - 1;
                while (i >= 0) {
                    viewName = (String)viewNames.get(i);
                    String viewText = (String)viewTexts.get(i);
                    String grant = (String)grants.get(i);
                    StringBuilder createStmt = new StringBuilder("CREATE OR REPLACE VIEW ").append(viewName).append(" AS ");
                    if (viewText.contains(" " + defaultPartitionName + " ")) {
                        viewText = viewText.replace(" " + defaultPartitionName + " ", " " + tableName + " ");
                    }
                    if (viewText.contains(" " + defaultPartitionName + "\n")) {
                        viewText = viewText.replace(" " + defaultPartitionName + "\n", " " + tableName + "\n");
                    }
                    if (viewText.contains(" " + defaultPartitionName + ".")) {
                        viewText = viewText.replace(" " + defaultPartitionName + ".", " " + tableName + ".");
                    }
                    if (viewText.contains("(" + defaultPartitionName + " ")) {
                        viewText = viewText.replace("(" + defaultPartitionName + " ", "(" + tableName + " ");
                    }
                    if (viewText.contains("(" + defaultPartitionName + "\n")) {
                        viewText = viewText.replace("(" + defaultPartitionName + "\n", "(" + tableName + "\n");
                    }
                    if (viewText.contains("(" + defaultPartitionName + ".")) {
                        viewText = viewText.replace("(" + defaultPartitionName + ".", "(" + tableName + ".");
                    }
                    String operators = "=><+-*/|%^&#~!";
                    int j = 0;
                    while (j < operators.length()) {
                        String find = operators.charAt(j) + defaultPartitionName + ".";
                        String replace = operators.charAt(j) + tableName + ".";
                        if (viewText.contains(find)) {
                            viewText = viewText.replace(find, replace);
                        }
                        ++j;
                    }
                    createStmt.append(viewText);
                    DB.executeUpdateEx((String)createStmt.toString(), (String)trxName);
                    if (pi != null) {
                        pi.addLog(0, null, null, "CREATE OR REPLACE VIEW " + viewName);
                    }
                    DB.executeUpdateEx((String)grant, (String)trxName);
                    --i;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Exception)e);
        }
    }

    private String getPartitionKeyDefinition(MTable table, String trxName) {
        String sql = "\tSELECT pg_get_partkeydef(oid) AS partition_key\n\tFROM pg_class\n\tWHERE relkind = 'p'\n\tAND relname = LOWER(?)\n";
        return DB.getSQLValueStringEx((String)trxName, (String)sql.toString(), (Object[])new Object[]{table.getTableName()});
    }

    private String validateConfiguration(MTable table, String trxName) {
        Object currentPartitionKey = null;
        String partitionKey = this.getPartitionKeyDefinition(table, trxName);
        List partitionKeyColumns = table.getPartitionKeyColumns(false);
        if (partitionKeyColumns.size() == 0) {
            return Msg.getMsg((Properties)Env.getCtx(), (String)"PartitionConfigurationChanged") + ": " + partitionKey;
        }
        MColumn partitionKeyColumn = (MColumn)partitionKeyColumns.get(0);
        String partitioningMethod = partitionKeyColumn.getPartitioningMethod();
        if (partitioningMethod.equals("L")) {
            currentPartitionKey = "LIST";
        } else if (partitioningMethod.equals("R")) {
            currentPartitionKey = "RANGE";
        }
        currentPartitionKey = (String)currentPartitionKey + " (" + partitionKeyColumn.getColumnName().toLowerCase() + ")";
        currentPartitionKey = ((String)currentPartitionKey).replace(",", ", ");
        if (!((String)currentPartitionKey).equalsIgnoreCase(partitionKey)) {
            return Msg.getMsg((Properties)Env.getCtx(), (String)"PartitionConfigurationChanged") + ": " + partitionKey;
        }
        return null;
    }

    public boolean addPartitionAndMigrateData(MTable table, String trxName, ProcessInfo pi) {
        String partitioningMethod;
        boolean isUpdated = false;
        String error = this.validateConfiguration(table, trxName);
        if (!Util.isEmpty((String)error)) {
            throw new AdempiereException(error);
        }
        List partitionKeyColumns = table.getPartitionKeyColumns(false);
        MColumn partitionKeyColumn = (MColumn)partitionKeyColumns.get(0);
        MColumn subPartitionColumn = null;
        if (partitionKeyColumns.size() > 1) {
            subPartitionColumn = (MColumn)partitionKeyColumns.get(1);
        }
        if ((partitioningMethod = partitionKeyColumn.getPartitioningMethod()).equals("L")) {
            isUpdated = this.addListPartition(table, partitionKeyColumn, trxName, pi, subPartitionColumn);
        } else if (partitioningMethod.equals("R")) {
            isUpdated = this.addRangePartition(table, partitionKeyColumn, trxName, pi, subPartitionColumn);
        } else {
            throw new IllegalArgumentException(Msg.getMsg((Properties)Env.getCtx(), (String)"PartitioningMethodNotSupported", (Object[])new Object[]{partitioningMethod}));
        }
        return isUpdated;
    }

    private RangePartitionColumn buildRangePartitionColumn(String fromTableName, MColumn partitionKeyColumn, String trxName) {
        String partitionKeyColumnName = partitionKeyColumn.getColumnName();
        String partitionKeyColumnRangeIntervalPattern = partitionKeyColumn.getRangePartitionInterval();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT MIN(").append(partitionKeyColumnName).append(") AS min_value, ");
        sql.append("MAX(").append(partitionKeyColumnName).append(") AS max_value ");
        sql.append("FROM ").append(fromTableName);
        List values = DB.getSQLValueObjectsEx((String)trxName, (String)sql.toString(), (Object[])new Object[0]);
        if (values.get(0) != null && values.get(1) != null) {
            return new RangePartitionColumn(partitionKeyColumnName, partitionKeyColumnRangeIntervalPattern, values.get(0), values.get(1));
        }
        return null;
    }

    private X_AD_TablePartition createNewRangePartition(RangePartitionInterval rangePartitionInterval, List<String> tablePartitionNames, MTable table, MColumn partitionKeyColumn, String partitionNamePrefix, String defaultPartitionName, X_AD_TablePartition parentPartition, String trxName) {
        X_AD_TablePartition partition = null;
        StringBuilder name = new StringBuilder();
        name.append(partitionNamePrefix);
        name.append("_");
        name.append(rangePartitionInterval.getName());
        StringBuilder expression = new StringBuilder();
        expression.append("FOR VALUES FROM (");
        expression.append(rangePartitionInterval.getFrom());
        expression.append(") TO (");
        expression.append(rangePartitionInterval.getTo());
        expression.append(")");
        StringBuilder countStmt = new StringBuilder("SELECT Count(*) FROM ").append(defaultPartitionName).append(" ").append("WHERE ").append(" ").append(partitionKeyColumn.getColumnName()).append(" >= ");
        if (DisplayType.isDate((int)partitionKeyColumn.getAD_Reference_ID()) || DisplayType.isTimestampWithTimeZone((int)partitionKeyColumn.getAD_Reference_ID())) {
            countStmt.append("TO_DATE(").append(rangePartitionInterval.getFrom()).append(",'yyyy-MM-dd') ");
        } else {
            countStmt.append(rangePartitionInterval.getFrom()).append(" ");
        }
        countStmt.append("AND ").append(partitionKeyColumn.getColumnName()).append(" < ");
        if (DisplayType.isDate((int)partitionKeyColumn.getAD_Reference_ID()) || DisplayType.isTimestampWithTimeZone((int)partitionKeyColumn.getAD_Reference_ID())) {
            countStmt.append("TO_DATE(").append(rangePartitionInterval.getTo()).append(",'yyyy-MM-dd') ");
        } else {
            countStmt.append(rangePartitionInterval.getTo()).append(" ");
        }
        int recordCount = DB.getSQLValueEx((String)trxName, (String)countStmt.toString(), (Object[])new Object[0]);
        if (recordCount == 0) {
            Query query;
            X_AD_TablePartition toDelete;
            if (tablePartitionNames.contains(name.toString()) && (toDelete = (X_AD_TablePartition)(query = new Query(Env.getCtx(), "AD_TablePartition", "AD_Table_ID=? AND Name=?", trxName)).setParameters(new Object[]{table.getAD_Table_ID(), name.toString()}).first()) != null) {
                toDelete.deleteEx(true);
            }
            return null;
        }
        if (!tablePartitionNames.contains(name.toString())) {
            partition = table.createTablePartition(name.toString(), expression.toString(), trxName, partitionKeyColumn, parentPartition);
            tablePartitionNames.add(name.toString());
        }
        return partition;
    }

    private void moveDefaultPartitionDataForRange(X_AD_TablePartition partition, MColumn partitionKeyColumn, String tableName, String defaultPartitionName, RangePartitionInterval rangePartitionInterval, ProcessInfo pi, String trxName) {
        StringBuilder updateStmt = new StringBuilder();
        updateStmt.append("WITH x AS ( ");
        updateStmt.append("DELETE FROM ").append(defaultPartitionName).append(" ");
        updateStmt.append("WHERE ").append(" ");
        updateStmt.append(partitionKeyColumn.getColumnName()).append(" >= ");
        if (DisplayType.isDate((int)partitionKeyColumn.getAD_Reference_ID()) || DisplayType.isTimestampWithTimeZone((int)partitionKeyColumn.getAD_Reference_ID())) {
            updateStmt.append("TO_DATE(").append(rangePartitionInterval.getFrom()).append(",'yyyy-MM-dd') ");
        } else {
            updateStmt.append(rangePartitionInterval.getFrom()).append(" ");
        }
        updateStmt.append("AND ").append(partitionKeyColumn.getColumnName()).append(" < ");
        if (DisplayType.isDate((int)partitionKeyColumn.getAD_Reference_ID()) || DisplayType.isTimestampWithTimeZone((int)partitionKeyColumn.getAD_Reference_ID())) {
            updateStmt.append("TO_DATE(").append(rangePartitionInterval.getTo()).append(",'yyyy-MM-dd') ");
        } else {
            updateStmt.append(rangePartitionInterval.getTo()).append(" ");
        }
        updateStmt.append("RETURNING *) ");
        updateStmt.append("INSERT INTO ").append(partition.getName()).append(" ");
        updateStmt.append("SELECT * FROM x");
        int no = DB.executeUpdateEx((String)updateStmt.toString(), (String)trxName);
        if (pi != null) {
            pi.addLog(0, null, null, no + " " + updateStmt.toString());
        }
        StringBuilder alterStmt = new StringBuilder();
        alterStmt.append("ALTER TABLE ").append(tableName).append(" ");
        alterStmt.append("ATTACH PARTITION ").append(partition.getName()).append(" ").append(partition.getExpressionPartition());
        DB.executeUpdateEx((String)alterStmt.toString(), (String)trxName);
        if (pi != null) {
            pi.addLog(0, null, null, alterStmt.toString());
        }
    }

    private boolean addRangePartition(MTable table, MColumn partitionKeyColumn, String trxName, ProcessInfo pi, MColumn subPartitionColumn) {
        boolean isUpdated = false;
        RangePartitionColumn rangePartitionColumn = this.buildRangePartitionColumn(this.getDefaultPartitionName(table), partitionKeyColumn, trxName);
        if (rangePartitionColumn == null) {
            return false;
        }
        List rangePartitionIntervals = RangePartitionInterval.createInterval((MTable)table, (RangePartitionColumn)rangePartitionColumn, (String)trxName);
        ArrayList<String> tablePartitionNames = table.getTablePartitionNames(trxName);
        for (RangePartitionInterval rangePartitionInterval : rangePartitionIntervals) {
            X_AD_TablePartition partition = this.createNewRangePartition(rangePartitionInterval, tablePartitionNames, table, partitionKeyColumn, table.getTableName().toLowerCase(), this.getDefaultPartitionName(table), null, trxName);
            if (partition == null) continue;
            StringBuilder createStmt = new StringBuilder();
            createStmt.append("CREATE TABLE ").append(partition.getName()).append(" (").append(DB_PostgreSQL.NATIVE_MARKER).append("LIKE ");
            createStmt.append(this.getDefaultPartitionName(table)).append(" INCLUDING ALL)");
            if (subPartitionColumn != null) {
                createStmt.append(" PARTITION BY ");
                if ("L".equals(subPartitionColumn.getPartitioningMethod())) {
                    createStmt.append(" LIST(");
                } else if ("R".equals(subPartitionColumn.getPartitioningMethod())) {
                    createStmt.append(" RANGE(");
                } else {
                    throw new IllegalArgumentException(Msg.getMsg((Properties)Env.getCtx(), (String)"PartitioningMethodNotSupported", (Object[])new Object[]{subPartitionColumn.getPartitioningMethod()}));
                }
                createStmt.append(subPartitionColumn.getColumnName());
                createStmt.append(")");
            }
            DB.executeUpdateEx((String)createStmt.toString(), (String)trxName);
            if (pi != null) {
                pi.addLog(0, null, null, createStmt.toString().replace(DB_PostgreSQL.NATIVE_MARKER, ""));
            }
            if (subPartitionColumn != null) {
                this.createSubDefaultPartition(table, subPartitionColumn, partition, pi, trxName);
            }
            this.moveDefaultPartitionDataForRange(partition, partitionKeyColumn, table.getTableName(), this.getDefaultPartitionName(table), rangePartitionInterval, pi, trxName);
            isUpdated = true;
        }
        if (subPartitionColumn != null) {
            Iterator iterator;
            ArrayList<X_AD_TablePartition> partitions = new ArrayList<X_AD_TablePartition>();
            tablePartitionNames = new ArrayList<String>();
            try {
                Object object = null;
                iterator = null;
                try (CPreparedStatement stmt = DB.prepareStatement((String)"SELECT * FROM AD_TablePartition WHERE IsActive='Y' AND AD_Table_ID=? AND AD_Column_ID=? AND IsPartitionAttached='Y'", (String)trxName);){
                    stmt.setInt(1, table.getAD_Table_ID());
                    stmt.setInt(2, partitionKeyColumn.getAD_Column_ID());
                    ResultSet rs = stmt.executeQuery();
                    while (rs.next()) {
                        X_AD_TablePartition partition = new X_AD_TablePartition(Env.getCtx(), rs, trxName);
                        if (partition.getName().toLowerCase().endsWith("_default_partition")) continue;
                        partitions.add(partition);
                        tablePartitionNames.add(partition.getName());
                    }
                }
                catch (Throwable throwable) {
                    if (object == null) {
                        object = throwable;
                    } else if (object != throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    throw object;
                }
            }
            catch (SQLException e) {
                throw new DBException((Exception)e);
            }
            iterator = partitions.iterator();
            while (iterator.hasNext()) {
                String sql = "\tSELECT COUNT(*)\n\tFROM information_schema.columns\n\tWHERE table_name = LOWER(?)\n";
                X_AD_TablePartition partition = (X_AD_TablePartition)iterator.next();
                String subDefaultPartition = partition.getName() + "_default_partition";
                int count = DB.getSQLValueEx((String)trxName, (String)sql, (Object[])new Object[]{subDefaultPartition});
                if (count <= 0) continue;
                if ("L".equals(subPartitionColumn.getPartitioningMethod())) {
                    HashMap<String, Object> subValues = new HashMap<String, Object>();
                    List<X_AD_TablePartition> subPartitions = this.generateListPartition(table, partition.getName(), subDefaultPartition, subPartitionColumn, subValues, partition, trxName);
                    for (X_AD_TablePartition subPartition : subPartitions) {
                        StringBuilder createStmt = new StringBuilder();
                        createStmt.append("CREATE TABLE ").append(subPartition.getName()).append(" (").append(DB_PostgreSQL.NATIVE_MARKER).append("LIKE ");
                        createStmt.append(subDefaultPartition).append(" INCLUDING ALL)");
                        DB.executeUpdateEx((String)createStmt.toString(), (String)trxName);
                        if (pi != null) {
                            pi.addLog(0, null, null, createStmt.toString().replace(DB_PostgreSQL.NATIVE_MARKER, ""));
                        }
                        Object subValue = subValues.get(subPartition.getName());
                        this.moveDefaultPartitionDataForList(subPartition, subPartitionColumn, partition.getName(), subDefaultPartition, subValue, pi, trxName);
                    }
                    continue;
                }
                if (!"R".equals(subPartitionColumn.getPartitioningMethod()) || (rangePartitionColumn = this.buildRangePartitionColumn(partition.getName(), subPartitionColumn, trxName)) == null) continue;
                rangePartitionIntervals = RangePartitionInterval.createInterval((MTable)table, (RangePartitionColumn)rangePartitionColumn, (String)trxName);
                for (RangePartitionInterval rangePartitionInterval : rangePartitionIntervals) {
                    X_AD_TablePartition subPartition;
                    subPartition = this.createNewRangePartition(rangePartitionInterval, tablePartitionNames, table, subPartitionColumn, partition.getName(), subDefaultPartition, partition, trxName);
                    if (subPartition == null) continue;
                    StringBuilder createStmt = new StringBuilder();
                    createStmt.append("CREATE TABLE ").append(subPartition.getName()).append(" (").append(DB_PostgreSQL.NATIVE_MARKER).append("LIKE ");
                    createStmt.append(subDefaultPartition).append(" INCLUDING ALL)");
                    DB.executeUpdateEx((String)createStmt.toString(), (String)trxName);
                    if (pi != null) {
                        pi.addLog(0, null, null, createStmt.toString().replace(DB_PostgreSQL.NATIVE_MARKER, ""));
                    }
                    this.moveDefaultPartitionDataForRange(subPartition, subPartitionColumn, partition.getName(), subDefaultPartition, rangePartitionInterval, pi, trxName);
                }
            }
        }
        return isUpdated;
    }

    private List<X_AD_TablePartition> generateListPartition(MTable table, String partitionNamePrefix, String fromPartitionTable, MColumn partitionKeyColumn, HashMap<String, Object> columnValues, X_AD_TablePartition parentPartition, String trxName) {
        ArrayList<X_AD_TablePartition> partitions = new ArrayList<X_AD_TablePartition>();
        String nameColumn = "'" + partitionNamePrefix + "_' || " + partitionKeyColumn.getColumnName();
        String expressionColumn = "'FOR VALUES IN (''' || " + partitionKeyColumn.getColumnName() + " || ''')'";
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT DISTINCT ").append(nameColumn).append(" AS name, ");
        sql.append(expressionColumn).append(" AS expression, ");
        sql.append(partitionKeyColumn.getColumnName()).append(" ");
        sql.append("FROM ").append(fromPartitionTable).append(" ");
        try {
            Throwable throwable = null;
            Object var13_15 = null;
            try (CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), (String)trxName);){
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    String name = rs.getString("name");
                    String expression = rs.getString("expression");
                    Object value = new ArrayList();
                    value = rs.getObject(partitionKeyColumn.getColumnName());
                    columnValues.put(name, value);
                    X_AD_TablePartition partition = table.createTablePartition(name, expression, trxName, partitionKeyColumn, parentPartition);
                    partitions.add(partition);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Exception)e);
        }
        return partitions;
    }

    private void moveDefaultPartitionDataForList(X_AD_TablePartition partition, MColumn partitionKeyColumn, String tableName, String defaultPartitionName, Object listValue, ProcessInfo pi, String trxName) {
        StringBuilder updateStmt = new StringBuilder();
        updateStmt.append("WITH x AS ( ");
        updateStmt.append("DELETE FROM ").append(defaultPartitionName).append(" ");
        updateStmt.append("WHERE ").append(" ");
        updateStmt.append(partitionKeyColumn.getColumnName()).append("=");
        if (DisplayType.isText((int)partitionKeyColumn.getAD_Reference_ID()) || partitionKeyColumn.getAD_Reference_ID() == 20 || DisplayType.isList((int)partitionKeyColumn.getAD_Reference_ID()) || "EntityType".equals(partitionKeyColumn.getColumnName()) || "AD_Language".equals(partitionKeyColumn.getColumnName())) {
            updateStmt.append("'").append(listValue).append("' ");
        } else {
            updateStmt.append(listValue).append(" ");
        }
        updateStmt.append("RETURNING *) ");
        updateStmt.append("INSERT INTO ").append(partition.getName()).append(" ");
        updateStmt.append("SELECT * FROM x");
        int no = DB.executeUpdateEx((String)updateStmt.toString(), (String)trxName);
        if (pi != null) {
            pi.addLog(0, null, null, no + " " + updateStmt.toString());
        }
        StringBuilder alterStmt = new StringBuilder();
        alterStmt.append("ALTER TABLE ").append(tableName).append(" ");
        alterStmt.append("ATTACH PARTITION ").append(partition.getName()).append(" ").append(partition.getExpressionPartition());
        DB.executeUpdateEx((String)alterStmt.toString(), (String)trxName);
        if (pi != null) {
            pi.addLog(0, null, null, alterStmt.toString());
        }
    }

    private boolean addListPartition(MTable table, MColumn partitionKeyColumn, String trxName, ProcessInfo pi, MColumn subPartitionColumn) {
        boolean isUpdated = false;
        HashMap<String, Object> columnValues = new HashMap<String, Object>();
        List<X_AD_TablePartition> partitions = this.generateListPartition(table, table.getTableName().toLowerCase(), this.getDefaultPartitionName(table), partitionKeyColumn, columnValues, null, trxName);
        for (X_AD_TablePartition partition : partitions) {
            Object value = columnValues.get(partition.getName());
            StringBuilder createStmt = new StringBuilder();
            createStmt.append("CREATE TABLE ").append(partition.getName()).append(" (").append(DB_PostgreSQL.NATIVE_MARKER).append("LIKE ");
            createStmt.append(this.getDefaultPartitionName(table)).append(" INCLUDING ALL)");
            if (subPartitionColumn != null) {
                createStmt.append(" PARTITION BY ");
                if ("L".equals(subPartitionColumn.getPartitioningMethod())) {
                    createStmt.append(" LIST(");
                } else if ("R".equals(subPartitionColumn.getPartitioningMethod())) {
                    createStmt.append(" RANGE(");
                } else {
                    throw new IllegalArgumentException(Msg.getMsg((Properties)Env.getCtx(), (String)"PartitioningMethodNotSupported", (Object[])new Object[]{subPartitionColumn.getPartitioningMethod()}));
                }
                createStmt.append(subPartitionColumn.getColumnName());
                createStmt.append(")");
            }
            DB.executeUpdateEx((String)createStmt.toString(), (String)trxName);
            if (pi != null) {
                pi.addLog(0, null, null, createStmt.toString().replace(DB_PostgreSQL.NATIVE_MARKER, ""));
            }
            if (subPartitionColumn != null) {
                this.createSubDefaultPartition(table, subPartitionColumn, partition, pi, trxName);
            }
            this.moveDefaultPartitionDataForList(partition, partitionKeyColumn, table.getTableName(), this.getDefaultPartitionName(table), value, pi, trxName);
            isUpdated = true;
        }
        if (subPartitionColumn != null) {
            Iterator<X_AD_TablePartition> iterator;
            ArrayList<String> tablePartitionNames = new ArrayList<String>();
            partitions = new ArrayList<X_AD_TablePartition>();
            try {
                Object object = null;
                iterator = null;
                try (CPreparedStatement stmt = DB.prepareStatement((String)"SELECT * FROM AD_TablePartition WHERE IsActive='Y' AND AD_Table_ID=? AND AD_Column_ID=? AND IsPartitionAttached='Y'", (String)trxName);){
                    stmt.setInt(1, table.getAD_Table_ID());
                    stmt.setInt(2, partitionKeyColumn.getAD_Column_ID());
                    ResultSet rs = stmt.executeQuery();
                    while (rs.next()) {
                        X_AD_TablePartition partition = new X_AD_TablePartition(Env.getCtx(), rs, trxName);
                        if (partition.getName().toLowerCase().endsWith("_default_partition")) continue;
                        partitions.add(partition);
                        tablePartitionNames.add(partition.getName());
                    }
                }
                catch (Throwable throwable) {
                    if (object == null) {
                        object = throwable;
                    } else if (object != throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    throw object;
                }
            }
            catch (SQLException e) {
                throw new DBException((Exception)e);
            }
            iterator = partitions.iterator();
            while (iterator.hasNext()) {
                RangePartitionColumn rangePartitionColumn;
                String sql = "\tSELECT COUNT(*)\n\tFROM information_schema.columns\n\tWHERE table_name = LOWER(?)\n";
                X_AD_TablePartition partition = iterator.next();
                String subDefaultPartition = partition.getName() + "_default_partition";
                int count = DB.getSQLValueEx((String)trxName, (String)sql, (Object[])new Object[]{subDefaultPartition});
                if (count <= 0) continue;
                if ("L".equals(subPartitionColumn.getPartitioningMethod())) {
                    HashMap<String, Object> subValues = new HashMap<String, Object>();
                    List<X_AD_TablePartition> subPartitions = this.generateListPartition(table, partition.getName(), subDefaultPartition, subPartitionColumn, subValues, partition, trxName);
                    for (X_AD_TablePartition subPartition : subPartitions) {
                        StringBuilder createStmt = new StringBuilder();
                        createStmt.append("CREATE TABLE ").append(subPartition.getName()).append(" (").append(DB_PostgreSQL.NATIVE_MARKER).append("LIKE ");
                        createStmt.append(subDefaultPartition).append(" INCLUDING ALL)");
                        DB.executeUpdateEx((String)createStmt.toString(), (String)trxName);
                        if (pi != null) {
                            pi.addLog(0, null, null, createStmt.toString().replace(DB_PostgreSQL.NATIVE_MARKER, ""));
                        }
                        Object subValue = subValues.get(subPartition.getName());
                        this.moveDefaultPartitionDataForList(subPartition, subPartitionColumn, partition.getName(), subDefaultPartition, subValue, pi, trxName);
                    }
                    continue;
                }
                if (!"R".equals(subPartitionColumn.getPartitioningMethod()) || (rangePartitionColumn = this.buildRangePartitionColumn(partition.getName(), subPartitionColumn, trxName)) == null) continue;
                List rangePartitionIntervals = RangePartitionInterval.createInterval((MTable)table, (RangePartitionColumn)rangePartitionColumn, (String)trxName);
                for (RangePartitionInterval rangePartitionInterval : rangePartitionIntervals) {
                    X_AD_TablePartition subPartition = this.createNewRangePartition(rangePartitionInterval, tablePartitionNames, table, subPartitionColumn, partition.getName(), subDefaultPartition, partition, trxName);
                    if (subPartition == null) continue;
                    StringBuilder createStmt = new StringBuilder();
                    createStmt.append("CREATE TABLE ").append(subPartition.getName()).append(" (").append(DB_PostgreSQL.NATIVE_MARKER).append("LIKE ");
                    createStmt.append(subDefaultPartition).append(" INCLUDING ALL)");
                    DB.executeUpdateEx((String)createStmt.toString(), (String)trxName);
                    if (pi != null) {
                        pi.addLog(0, null, null, createStmt.toString().replace(DB_PostgreSQL.NATIVE_MARKER, ""));
                    }
                    this.moveDefaultPartitionDataForRange(subPartition, subPartitionColumn, partition.getName(), subDefaultPartition, rangePartitionInterval, pi, trxName);
                }
            }
        }
        return isUpdated;
    }

    private void createSubDefaultPartition(MTable table, MColumn subPartitionColumn, X_AD_TablePartition partition, ProcessInfo pi, String trxName) {
        StringBuilder subStmt = new StringBuilder("CREATE TABLE ").append(partition.getName()).append("_default_partition (").append(DB_PostgreSQL.NATIVE_MARKER).append("LIKE ").append(partition.getName()).append(" INCLUDING ALL)");
        DB.executeUpdateEx((String)subStmt.toString(), (String)trxName);
        if (pi != null) {
            pi.addLog(0, null, null, subStmt.toString());
        }
        subStmt = new StringBuilder("ALTER TABLE ").append(partition.getName()).append(" ATTACH PARTITION ").append(partition.getName()).append("_default_partition DEFAULT ");
        DB.executeUpdateEx((String)subStmt.toString(), (String)trxName);
        if (pi != null) {
            pi.addLog(0, null, null, subStmt.toString().replace(DB_PostgreSQL.NATIVE_MARKER, ""));
        }
        table.createTablePartition(partition.getName() + "_default_partition", "DEFAULT", trxName, subPartitionColumn, partition);
    }

    public boolean runPostPartitionProcess(MTable table, String trxName, ProcessInfo processInfo) {
        StringBuilder stmt = new StringBuilder();
        stmt.append("VACUUM ANALYZE ").append(table.getTableName());
        DB.executeUpdateEx((String)stmt.toString(), (String)trxName);
        if (processInfo != null) {
            processInfo.addLog(0, null, null, stmt.toString());
        }
        return true;
    }

    public String isValidConfiguration(MTable table) {
        String trxName = table.get_TrxName();
        if (!this.isPartitionedTable(table, trxName)) {
            return null;
        }
        if (!table.isPartition()) {
            return Msg.getMsg((Properties)Env.getCtx(), (String)"PartitionConfigurationChanged") + " [IsPartition]";
        }
        List partitionKeyColumns = table.getPartitionKeyColumns(false);
        MColumn partitionKeyColumn = (MColumn)partitionKeyColumns.get(0);
        String currentPartitionKey = null;
        String partitioningMethod = partitionKeyColumn.getPartitioningMethod();
        if (partitioningMethod.equals("L")) {
            currentPartitionKey = "LIST";
        } else if (partitioningMethod.equals("R")) {
            currentPartitionKey = "RANGE";
        }
        String partitionKey = this.getPartitionKeyDefinition(table, trxName);
        if (!partitionKey.toLowerCase().startsWith(currentPartitionKey.toLowerCase())) {
            return Msg.getMsg((Properties)Env.getCtx(), (String)"PartitionConfigurationChanged") + " [PartitioningMethod]";
        }
        return null;
    }

    public String isValidConfiguration(MColumn column) {
        String error;
        String trxName = column.get_TrxName();
        MTable table = MTable.get((Properties)Env.getCtx(), (int)column.getAD_Table_ID(), (String)trxName);
        List partitionKeyColumns = table.getPartitionKeyColumns(true);
        if (column.isActive() && column.isPartitionKey()) {
            if (!partitionKeyColumns.contains(column)) {
                partitionKeyColumns.add(column);
            }
        } else if (partitionKeyColumns.contains(column)) {
            partitionKeyColumns.remove(column);
        }
        if (partitionKeyColumns.size() > 2) {
            return Msg.getMsg((Properties)Env.getCtx(), (String)"OnlyTwoPartitionKeyAllowed");
        }
        if (column.isActive() && column.isPartitionKey() && column.getPartitioningMethod().equals("R") && !Util.isEmpty((String)(error = RangePartitionInterval.validateIntervalPattern((MColumn)column)))) {
            return error;
        }
        if (!this.isPartitionedTable(table, trxName)) {
            return null;
        }
        if (column.is_ValueChanged("IsPartitionKey") || column.isPartitionKey() && column.is_ValueChanged("IsActive") || column.isPartitionKey() && column.is_ValueChanged("PartitioningMethod")) {
            if (partitionKeyColumns.size() == 2 || partitionKeyColumns.size() == 1 && !column.isPartitionKey() && column.is_ValueChanged("IsPartitionKey")) {
                return Msg.getMsg((Properties)Env.getCtx(), (String)"PartitionConfigurationChanged");
            }
            return this.validateConfiguration(table, trxName);
        }
        if (column.isPartitionKey() && column.is_ValueChanged("SeqNoPartition") && partitionKeyColumns.size() == 2) {
            int otherSeq;
            int oldSeq = column.get_ValueOldAsInt("SeqNoPartition");
            int newSeq = column.getSeqNoPartition();
            int n = otherSeq = ((MColumn)partitionKeyColumns.get(0)).getAD_Column_ID() == column.getAD_Column_ID() ? ((MColumn)partitionKeyColumns.get(1)).getSeqNoPartition() : ((MColumn)partitionKeyColumns.get(0)).getSeqNoPartition();
            if (!(newSeq < otherSeq && oldSeq < otherSeq || oldSeq > otherSeq && newSeq > otherSeq)) {
                return Msg.getMsg((Properties)Env.getCtx(), (String)"PartitionConfigurationChanged");
            }
        }
        if (column.isPartitionKey() && column.is_ValueChanged("RangePartitionInterval")) {
            return Msg.getMsg((Properties)Env.getCtx(), (String)"PartitionConfigurationChanged") + " [RangePartitionInterval]";
        }
        return null;
    }

    public void detachPartition(MTable table, X_AD_TablePartition partition, String trxName, ProcessInfo processInfo) {
        if (partition.isPartitionAttached()) {
            if (!"default".equalsIgnoreCase(partition.getExpressionPartition())) {
                StringBuilder alter = new StringBuilder("ALTER TABLE ");
                if (partition.getParent_TablePartition_ID() > 0) {
                    X_AD_TablePartition parentPartition = new X_AD_TablePartition(Env.getCtx(), partition.getParent_TablePartition_ID(), trxName);
                    alter.append(parentPartition.getName()).append(" ");
                } else {
                    alter.append(table.getTableName()).append(" ");
                }
                alter.append("DETACH PARTITION ").append(partition.getName());
                DB.executeUpdateEx((String)alter.toString(), (String)trxName);
                if (processInfo != null) {
                    processInfo.addLog(0, null, null, alter.toString());
                }
                partition.setIsPartitionAttached(false);
                partition.saveEx();
            } else {
                throw new AdempiereException(Msg.getMsg((Properties)Env.getCtx(), (String)"CantDetachReattachDefaultPartition"));
            }
        }
    }

    public void reattachPartition(MTable table, X_AD_TablePartition partition, String trxName, ProcessInfo processInfo) {
        if (!partition.isPartitionAttached()) {
            if (!"default".equalsIgnoreCase(partition.getExpressionPartition())) {
                StringBuilder alter = new StringBuilder("ALTER TABLE ");
                if (partition.getParent_TablePartition_ID() > 0) {
                    X_AD_TablePartition parentPartition = new X_AD_TablePartition(Env.getCtx(), partition.getParent_TablePartition_ID(), trxName);
                    alter.append(parentPartition.getName()).append(" ");
                } else {
                    alter.append(table.getTableName()).append(" ");
                }
                alter.append("ATTACH PARTITION ").append(partition.getName()).append(" ").append(partition.getExpressionPartition());
                boolean success = true;
                try {
                    DB.executeUpdateEx((String)alter.toString(), (String)trxName);
                    if (processInfo != null) {
                        processInfo.addLog(0, null, null, alter.toString());
                    }
                }
                catch (RuntimeException runtimeException) {
                    success = false;
                    Trx.get((String)trxName, (boolean)false).rollback();
                }
                if (success) {
                    partition.setIsPartitionAttached(true);
                    partition.saveEx();
                } else {
                    StringBuilder updateStmt = new StringBuilder();
                    updateStmt.append("WITH x AS ( ");
                    updateStmt.append("DELETE FROM ").append(partition.getName()).append(" ");
                    updateStmt.append("RETURNING *) ");
                    updateStmt.append("INSERT INTO ").append(table.getTableName()).append(" ");
                    updateStmt.append("SELECT * FROM x");
                    int no = DB.executeUpdateEx((String)updateStmt.toString(), (String)trxName);
                    if (processInfo != null) {
                        processInfo.addLog(0, null, null, no + " " + updateStmt.toString());
                    }
                    alter = new StringBuilder("DROP TABLE ").append(partition.getName());
                    DB.executeUpdateEx((String)alter.toString(), (String)trxName);
                    if (processInfo != null) {
                        processInfo.addLog(0, null, null, alter.toString());
                    }
                    try {
                        Trx.get((String)trxName, (boolean)false).commit(true);
                    }
                    catch (SQLException e) {
                        throw new DBException((Exception)e);
                    }
                    partition.deleteEx(true);
                    table.getTablePartitions(true, trxName);
                    this.addPartitionAndMigrateData(table, trxName, processInfo);
                }
            } else {
                throw new AdempiereException(Msg.getMsg((Properties)Env.getCtx(), (String)"CantDetachReattachDefaultPartition"));
            }
        }
    }
}

