/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.form.WCreateFromForm;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListModelTable;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.editor.WDateEditor;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WNumberEditor;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.editor.WStringEditor;
import org.adempiere.webui.editor.WTableDirEditor;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.IFormController;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.compiere.apps.form.CreateFromForm;
import org.compiere.apps.form.StatementCreateFromBatch;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.GridTab;
import org.compiere.model.Lookup;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.idempiere.ui.zk.annotation.Form;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Space;

@Form
public class WStatementCreateFromBatch
extends StatementCreateFromBatch
implements IFormController,
EventListener<Event> {
    private WCreateFromForm form;
    private int p_WindowNo;
    protected Label bankAccountLabel = new Label();
    protected WTableDirEditor bankAccountField;
    protected Label documentNoLabel = new Label(Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo"));
    protected WStringEditor documentNoField = new WStringEditor();
    protected Label documentTypeLabel = new Label();
    protected WTableDirEditor documentTypeField;
    protected Label authorizationLabel = new Label();
    protected WStringEditor authorizationField = new WStringEditor();
    protected Label tenderTypeLabel = new Label();
    protected WTableDirEditor tenderTypeField;
    protected Label amtFromLabel = new Label(Msg.translate((Properties)Env.getCtx(), (String)"PayAmt"));
    protected WNumberEditor amtFromField = new WNumberEditor("AmtFrom", false, false, true, 12, Msg.translate((Properties)Env.getCtx(), (String)"AmtFrom"));
    protected Label amtToLabel = new Label("-");
    protected WNumberEditor amtToField = new WNumberEditor("AmtTo", false, false, true, 12, Msg.translate((Properties)Env.getCtx(), (String)"AmtTo"));
    protected Label BPartner_idLabel = new Label(Msg.translate((Properties)Env.getCtx(), (String)"BPartner"));
    protected WEditor bPartnerLookup;
    protected Label dateFromLabel = new Label(Msg.translate((Properties)Env.getCtx(), (String)"DateTrx"));
    protected WDateEditor dateFromField = new WDateEditor("DateFrom", false, false, true, Msg.translate((Properties)Env.getCtx(), (String)"DateFrom"));
    protected Label dateToLabel = new Label("-");
    protected WDateEditor dateToField = new WDateEditor("DateTo", false, false, true, Msg.translate((Properties)Env.getCtx(), (String)"DateTo"));
    protected Checkbox createLinePerPayment = new Checkbox();
    protected Grid parameterBankLayout;

    public WStatementCreateFromBatch() {
        this.form = new WCreateFromForm((CreateFromForm)this);
    }

    public void initForm() {
        try {
            this.p_WindowNo = this.form.getGridTab() != null ? this.form.getGridTab().getWindowNo() : this.form.getWindowNo();
            if (!this.dynInit()) {
                return;
            }
            this.zkInit();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", (Throwable)e);
        }
    }

    protected boolean dynInit() throws Exception {
        super.dynInit();
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("");
        }
        Button refreshButton = this.form.getConfirmPanel().createButton("Refresh");
        refreshButton.addEventListener("onClick", this);
        this.form.getConfirmPanel().addButton(refreshButton);
        if (this.form.getGridTab() != null && this.form.getGridTab().getValue("C_BankStatement_ID") == null) {
            Dialog.error(0, "SaveErrorRowNotFound");
            return false;
        }
        this.form.setTitle(this.getTitle());
        int AD_Column_ID = 4917;
        MLookup lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)0, (int)AD_Column_ID, (int)19);
        this.bankAccountField = new WTableDirEditor("C_BankAccount_ID", true, false, true, (Lookup)lookup);
        int C_BankAccount_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"C_BankAccount_ID");
        this.bankAccountField.setValue(C_BankAccount_ID);
        this.authorizationField = new WStringEditor("authorization", false, false, true, 10, 30, null, null);
        this.authorizationField.getComponent().addEventListener("onChange", (EventListener)this);
        lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)0, (int)MColumn.getColumn_ID((String)"C_Payment", (String)"C_DocType_ID"), (int)19);
        this.documentTypeField = new WTableDirEditor("C_DocType_ID", false, false, true, (Lookup)lookup);
        this.documentTypeField.getComponent().addEventListener("onChange", this);
        lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)0, (int)MColumn.getColumn_ID((String)"C_Payment", (String)"TenderType"), (int)17);
        this.tenderTypeField = new WTableDirEditor("TenderType", false, false, true, (Lookup)lookup);
        this.tenderTypeField.getComponent().addEventListener("onChange", this);
        lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)0, (int)3499, (int)30);
        this.bPartnerLookup = new WSearchEditor("C_BPartner_ID", false, false, true, (Lookup)lookup);
        Timestamp date = Env.getContextAsDate((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"StatementDate");
        this.dateToField.setValue(date);
        this.createLinePerPayment.setSelected(false);
        this.createLinePerPayment.addActionListener(this);
        this.form.postQueryEvent();
        return true;
    }

    protected void onClientInfo() {
        org.zkoss.zul.Rows rows;
        if (ClientInfo.isMobile() && this.parameterBankLayout != null && this.parameterBankLayout.getColumns() != null && (rows = this.parameterBankLayout.getRows()) != null) {
            int nc = ClientInfo.maxWidth(500) ? 2 : 4;
            int cc = rows.getFirstChild().getChildren().size();
            if (cc != nc) {
                this.parameterBankLayout.getColumns().detach();
                this.setupColumns(this.parameterBankLayout);
                if (cc > nc) {
                    LayoutUtils.compactTo(this.parameterBankLayout, nc);
                } else {
                    LayoutUtils.expandTo(this.parameterBankLayout, nc);
                }
                ZKUpdateUtil.setCSSHeight((HtmlBasedComponent)this.form);
                ZKUpdateUtil.setCSSWidth((HtmlBasedComponent)this.form);
                this.form.invalidate();
            }
        }
    }

    protected void zkInit() throws Exception {
        this.bankAccountLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_BankAccount_ID"));
        this.authorizationLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"R_AuthCode"));
        this.documentTypeLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_DocType_ID"));
        this.tenderTypeLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"TenderType"));
        this.dateFromField.getComponent().setTooltiptext(Msg.translate((Properties)Env.getCtx(), (String)"DateFrom"));
        this.dateToField.getComponent().setTooltiptext(Msg.translate((Properties)Env.getCtx(), (String)"DateTo"));
        this.amtFromField.getComponent().setTooltiptext(Msg.translate((Properties)Env.getCtx(), (String)"AmtFrom"));
        this.amtToField.getComponent().setTooltiptext(Msg.translate((Properties)Env.getCtx(), (String)"AmtTo"));
        this.createLinePerPayment.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"CreateLinePerPayment", (boolean)true));
        this.createLinePerPayment.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"CreateLinePerPayment", (boolean)false));
        Panel parameterPanel = this.form.getParameterPanel();
        this.parameterBankLayout = GridFactory.newGridLayout();
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.parameterBankLayout, "min");
        parameterPanel.appendChild((Component)this.parameterBankLayout);
        this.setupColumns(this.parameterBankLayout);
        Rows rows = this.parameterBankLayout.newRows();
        Row row = rows.newRow();
        row.appendChild(this.bankAccountLabel.rightAlign());
        row.appendChild((Component)this.bankAccountField.getComponent());
        row.appendChild(this.documentNoLabel.rightAlign());
        row.appendChild((Component)this.documentNoField.getComponent());
        row = rows.newRow();
        row.appendChild(this.documentTypeLabel.rightAlign());
        row.appendChild((Component)this.documentTypeField.getComponent());
        row.appendChild(this.authorizationLabel.rightAlign());
        row.appendChild((Component)this.authorizationField.getComponent());
        row = rows.newRow();
        row.appendChild(this.tenderTypeLabel.rightAlign());
        row.appendChild((Component)this.tenderTypeField.getComponent());
        row.appendChild(this.amtFromLabel.rightAlign());
        Hbox hbox = new Hbox();
        hbox.appendChild((Component)this.amtFromField.getComponent());
        hbox.appendChild(this.amtToLabel.rightAlign());
        hbox.appendChild((Component)this.amtToField.getComponent());
        row.appendChild((Component)hbox);
        row = rows.newRow();
        row.appendChild(this.BPartner_idLabel.rightAlign());
        row.appendChild(this.bPartnerLookup.getComponent());
        row.appendChild(this.dateFromLabel.rightAlign());
        hbox = new Hbox();
        hbox.appendChild((Component)this.dateFromField.getComponent());
        hbox.appendChild(this.dateToLabel.rightAlign());
        hbox.appendChild((Component)this.dateToField.getComponent());
        row.appendChild((Component)hbox);
        row = rows.newRow();
        row.appendChild((Component)new Space());
        row.appendChild((Component)this.createLinePerPayment);
        if (ClientInfo.isMobile()) {
            if (ClientInfo.maxWidth(500)) {
                LayoutUtils.compactTo(this.parameterBankLayout, 2);
            }
            ClientInfo.onClientInfo((Component)this.form, this::onClientInfo);
        }
    }

    protected void setupColumns(Grid parameterBankLayout) {
        Columns columns = new Columns();
        parameterBankLayout.appendChild((Component)columns);
        if (ClientInfo.maxWidth(500)) {
            Column column = new Column();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "35%");
            columns.appendChild((Component)column);
            column = new Column();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "65%");
            columns.appendChild((Component)column);
        } else {
            Column column = new Column();
            columns.appendChild((Component)column);
            column = new Column();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "15%");
            columns.appendChild((Component)column);
            ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "35%");
            column = new Column();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "15%");
            columns.appendChild((Component)column);
            column = new Column();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "35%");
            columns.appendChild((Component)column);
        }
    }

    public void onEvent(Event e) throws Exception {
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("Action=" + e.getTarget().getId());
        }
        if (e.getTarget().equals((Object)this.form.getConfirmPanel().getButton("Refresh"))) {
            this.form.postQueryEvent();
            this.form.tableChanged(null);
        }
    }

    public void executeQuery() {
        this.loadTableOIS(this.getBankAccountData((Integer)this.bankAccountField.getValue(), (Integer)this.bPartnerLookup.getValue(), this.documentNoField.getValue().toString(), this.dateFromField.getValue(), this.dateToField.getValue(), this.amtFromField.getValue(), this.amtToField.getValue(), (Integer)this.documentTypeField.getValue(), (String)this.tenderTypeField.getValue(), this.authorizationField.getValue().toString(), this.form.getGridTab()));
    }

    protected void loadTableOIS(Vector<?> data) {
        this.form.getWListbox().clear();
        this.form.getWListbox().getModel().removeTableModelListener(this.form);
        ListModelTable model = new ListModelTable(data);
        model.addTableModelListener(this.form);
        this.form.getWListbox().setData(model, this.getOISColumnNames());
        this.configureMiniTable(this.form.getWListbox());
    }

    public boolean save(IMiniTable miniTable, String trxName, GridTab gridTab) {
        if (this.createLinePerPayment.isSelected()) {
            return super.save(miniTable, trxName, gridTab);
        }
        int C_BankStatement_ID = (Integer)gridTab.getValue("C_BankStatement_ID");
        MBankStatement bs = new MBankStatement(Env.getCtx(), C_BankStatement_ID, trxName);
        int C_Currency_ID = bs.getBankAccount().getC_Currency_ID();
        int i = 0;
        while (i < miniTable.getRowCount()) {
            if (((Boolean)miniTable.getValueAt(i, 0)).booleanValue()) {
                Timestamp DateTrx = (Timestamp)miniTable.getValueAt(i, 1);
                KeyNamePair pp = (KeyNamePair)miniTable.getValueAt(i, 2);
                int C_DepositBatch_ID = pp.getKey();
                BigDecimal TrxAmt = (BigDecimal)miniTable.getValueAt(i, 4);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Line Date=" + String.valueOf(DateTrx) + ", DepositBatch=" + C_DepositBatch_ID + ", Currency=" + C_Currency_ID + ", Amt=" + String.valueOf(TrxAmt));
                }
                MBankStatementLine bsl = new MBankStatementLine(bs);
                bsl.setStatementLineDate(DateTrx);
                bsl.setC_DepositBatch_ID(C_DepositBatch_ID);
                bsl.setTrxAmt(TrxAmt);
                bsl.setStmtAmt(TrxAmt);
                bsl.setC_Currency_ID(C_Currency_ID);
                if (!bsl.save()) {
                    this.log.log(Level.SEVERE, "Line not created # " + i);
                }
            }
            ++i;
        }
        return true;
    }

    @Override
    public ADForm getForm() {
        return this.form;
    }
}

