/*
 * Decompiled with CFR 0.152.
 */
package org.castor.core.annotationprocessing;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.castor.core.annotationprocessing.AnnotationProcessor;
import org.castor.core.annotationprocessing.AnnotationTargetException;
import org.castor.core.annotationprocessing.BaseAnnotationProcessingService;
import org.castor.core.annotationprocessing.TargetAwareAnnotationProcessingService;
import org.castor.core.annotationprocessing.TargetAwareAnnotationProcessor;
import org.castor.core.nature.BaseNature;

public class BaseTargetAwareAnnotationProcessingService
extends BaseAnnotationProcessingService
implements TargetAwareAnnotationProcessingService {
    private Map<Class<? extends Annotation>, TargetAwareAnnotationProcessor> _taAnnotationProcessorMap = new HashMap<Class<? extends Annotation>, TargetAwareAnnotationProcessor>();

    @Override
    public void addAnnotationProcessor(TargetAwareAnnotationProcessor taAnnotationProcessor) {
        if (taAnnotationProcessor != null) {
            this._taAnnotationProcessorMap.put(taAnnotationProcessor.forAnnotationClass(), taAnnotationProcessor);
        }
    }

    @Override
    public Set<AnnotationProcessor> getAllAnnotationProcessors() {
        HashSet<AnnotationProcessor> result = new HashSet<AnnotationProcessor>(super.getAnnotationProcessors());
        result.addAll(this._taAnnotationProcessorMap.values());
        return result;
    }

    @Override
    public Set<TargetAwareAnnotationProcessor> getTargetAwareAnnotationProcessors() {
        HashSet<TargetAwareAnnotationProcessor> result = new HashSet<TargetAwareAnnotationProcessor>(this._taAnnotationProcessorMap.values());
        return result;
    }

    @Override
    public <I extends BaseNature, A extends Annotation> boolean processAnnotation(I info, A annotation, AnnotatedElement target) throws AnnotationTargetException {
        boolean processed = false;
        TargetAwareAnnotationProcessor annotationProcessor = this._taAnnotationProcessorMap.get(annotation.annotationType());
        if (annotationProcessor != null) {
            processed = annotationProcessor.processAnnotation(info, annotation, target);
        }
        return processed;
    }

    @Override
    public <I extends BaseNature> Annotation[] processAnnotations(I info, Annotation[] annotations, AnnotatedElement target) throws AnnotationTargetException {
        ArrayList<Annotation> unprocessed = new ArrayList<Annotation>();
        for (int i = 0; i < annotations.length; ++i) {
            if (this.processAnnotation(info, annotations[i], target)) continue;
            unprocessed.add(annotations[i]);
        }
        Annotation[] arrReturn = new Annotation[unprocessed.size()];
        return unprocessed.toArray(arrReturn);
    }

    @Override
    public <I extends BaseNature, A extends Annotation> boolean processAnnotation(I info, A annotation) {
        boolean superReturn = super.processAnnotation(info, annotation);
        if (!superReturn) {
            boolean processed = false;
            AnnotationProcessor annotationProcessor = this._taAnnotationProcessorMap.get(annotation.annotationType());
            if (annotationProcessor != null) {
                processed = annotationProcessor.processAnnotation(info, annotation);
            }
            return processed;
        }
        return superReturn;
    }

    @Override
    public <I extends BaseNature> Annotation[] processAnnotations(I info, Annotation[] annotations) {
        Annotation[] superUnprocessed = super.processAnnotations(info, annotations);
        ArrayList<Annotation> unprocessed = new ArrayList<Annotation>();
        for (int i = 0; i < superUnprocessed.length; ++i) {
            if (this.processAnnotation(info, superUnprocessed[i])) continue;
            unprocessed.add(superUnprocessed[i]);
        }
        Annotation[] arrReturn = new Annotation[unprocessed.size()];
        return unprocessed.toArray(arrReturn);
    }
}

