/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.model.MSysConfig;
import org.compiere.util.AmtInWords;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;

public final class Msg {
    private static final int MAP_SIZE = 2000;
    private static final String SEPARATOR = Env.NL + Env.NL;
    private static Msg s_msg = null;
    private static CLogger s_log = CLogger.getCLogger(Msg.class);
    private Map<String, CCache<String, String>> m_languages = new HashMap<String, CCache<String, String>>();
    private Map<String, CCache<String, String>> m_elementNameCache = new HashMap<String, CCache<String, String>>();
    private Map<String, CCache<String, String>> m_elementPrintNameCache = new HashMap<String, CCache<String, String>>();

    public static synchronized Msg get() {
        if (s_msg == null) {
            s_msg = new Msg();
        }
        return s_msg;
    }

    private Msg() {
    }

    public synchronized CCache<String, String> getMsgMap(String ad_language) {
        CCache<String, String> retValue;
        String AD_Language = ad_language;
        if (AD_Language == null || AD_Language.length() == 0) {
            AD_Language = Language.getBaseAD_Language();
        }
        if ((retValue = this.m_languages.get(AD_Language)) != null && retValue.size() > 0) {
            return retValue;
        }
        if ((retValue = this.initMsg(AD_Language, retValue)) != null) {
            this.m_languages.put(AD_Language, retValue);
            return retValue;
        }
        return retValue;
    }

    public synchronized CCache<String, String> getElementMap(String ad_language) {
        CCache<String, String> retValue;
        String AD_Language = ad_language;
        if (AD_Language == null || AD_Language.length() == 0) {
            AD_Language = Language.getBaseAD_Language();
        }
        if ((retValue = this.m_elementNameCache.get(AD_Language)) != null) {
            return retValue;
        }
        retValue = new CCache("AD_Element", "AD_Element|" + AD_Language, 100, 0, false, 0);
        this.m_elementNameCache.put(AD_Language, retValue);
        return retValue;
    }

    public synchronized CCache<String, String> getElementPrintNameMap(String ad_language) {
        CCache<String, String> retValue;
        String AD_Language = ad_language;
        if (AD_Language == null || AD_Language.length() == 0) {
            AD_Language = Language.getBaseAD_Language();
        }
        if ((retValue = this.m_elementPrintNameCache.get(AD_Language)) != null) {
            return retValue;
        }
        retValue = new CCache("AD_Element", "AD_Element|" + AD_Language, 100, 0, false, 0);
        this.m_elementPrintNameCache.put(AD_Language, retValue);
        return retValue;
    }

    private CCache<String, String> initMsg(String AD_Language, CCache<String, String> msg) {
        if (msg == null) {
            msg = new CCache("AD_Message", "AD_Message|" + AD_Language, 2000, 0, false, 0);
        }
        if (!DB.isConnected()) {
            s_log.log(Level.SEVERE, "No DB Connection");
            return null;
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                if (AD_Language == null || AD_Language.length() == 0 || Env.isBaseLanguage(AD_Language, "AD_Language")) {
                    pstmt = DB.prepareStatement("SELECT Value, MsgText, MsgTip FROM AD_Message WHERE IsActive ='Y'", null);
                } else {
                    pstmt = DB.prepareStatement("SELECT m.Value, t.MsgText, t.MsgTip FROM AD_Message_Trl t, AD_Message m WHERE m.AD_Message_ID=t.AD_Message_ID AND t.AD_Client_ID = 0 AND m.IsActive ='Y' AND t.IsActive ='Y' AND t.AD_Language=?", null);
                    pstmt.setString(1, AD_Language);
                }
                rs = pstmt.executeQuery();
                this.addMessagesInCache(rs, msg);
                DB.close(rs, pstmt);
                pstmt = DB.prepareStatement("SELECT t.AD_Client_ID || '|' || m.Value, t.MsgText, t.MsgTip FROM AD_Message_Trl t, AD_Message m WHERE m.AD_Message_ID=t.AD_Message_ID AND t.AD_Client_ID != 0 AND m.IsActive ='Y' AND t.IsActive ='Y' AND t.AD_Language=?", null);
                pstmt.setString(1, AD_Language);
                rs = pstmt.executeQuery();
                this.addMessagesInCache(rs, msg);
            }
            catch (SQLException e) {
                s_log.log(Level.SEVERE, "initMsg", e);
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return null;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (msg.size() < 100) {
            s_log.log(Level.SEVERE, "Too few (" + msg.size() + ") Records found for " + AD_Language);
            return null;
        }
        if (s_log.isLoggable(Level.INFO)) {
            s_log.info("Records=" + msg.size() + " - " + AD_Language);
        }
        return msg;
    }

    private void addMessagesInCache(ResultSet rs, CCache<String, String> msg) throws SQLException {
        while (rs.next()) {
            String AD_Message = rs.getString(1);
            StringBuilder MsgText = new StringBuilder();
            MsgText.append(rs.getString(2));
            String MsgTip = rs.getString(3);
            if (MsgTip != null) {
                MsgText.append(" ").append(SEPARATOR).append(MsgTip);
            }
            msg.put(AD_Message, MsgText.toString());
        }
    }

    public synchronized void reset() {
        if (this.m_languages == null) {
            return;
        }
        for (CCache<String, String> hm : this.m_languages.values()) {
            hm.reset();
        }
    }

    public synchronized String[] getLanguages() {
        if (this.m_languages == null) {
            return null;
        }
        String[] retValue = new String[this.m_languages.size()];
        this.m_languages.keySet().toArray(retValue);
        return retValue;
    }

    public synchronized boolean isLoaded(String language) {
        if (this.m_languages == null) {
            return false;
        }
        return this.m_languages.get(language) != null && !this.m_languages.get(language).isEmpty();
    }

    private String lookup(String AD_Language, String text) {
        String msg;
        if (text == null) {
            return null;
        }
        if (AD_Language == null || AD_Language.length() == 0) {
            return text;
        }
        if (text.equals("/") || text.equals("\\")) {
            return File.separator;
        }
        if (text.equals(";") || text.equals(":")) {
            return File.pathSeparator;
        }
        if (text.equals("IDEMPIERE_HOME")) {
            return Adempiere.getAdempiereHome();
        }
        if (text.equals("bat") || text.equals("sh")) {
            if (System.getProperty("os.name").startsWith("Win")) {
                return "bat";
            }
            return "sh";
        }
        if (text.equals("CopyRight")) {
            return "\u00a9 1999-2025 iDempiere\u00ae";
        }
        CCache<String, String> langMap = this.getMsgMap(AD_Language);
        if (langMap == null) {
            return null;
        }
        if (MSysConfig.getBooleanValue("MESSAGES_AT_TENANT_LEVEL", false, Env.getAD_Client_ID(Env.getCtx())) && !Util.isEmpty(msg = langMap.get(Env.getAD_Client_ID(Env.getCtx()) + "|" + text))) {
            return msg;
        }
        return langMap.get(text);
    }

    public static String getMsg(String ad_language, String AD_Message) {
        String retStr;
        if (AD_Message == null || AD_Message.length() == 0) {
            return "";
        }
        String AD_Language = ad_language;
        if (AD_Language == null || AD_Language.length() == 0) {
            AD_Language = Language.getBaseAD_Language();
        }
        if ((retStr = Msg.get().lookup(AD_Language, AD_Message)) == null || retStr.length() == 0) {
            s_log.warning("NOT found: " + AD_Message);
            return AD_Message;
        }
        return retStr;
    }

    public static String getMsg(Properties ctx, String AD_Message) {
        return Msg.getMsg(Env.getAD_Language(ctx), AD_Message);
    }

    public static String getMsg(Language language, String AD_Message) {
        return Msg.getMsg(language.getAD_Language(), AD_Message);
    }

    public static ValueNamePair splitToMsgTip(String msgFull) {
        int pos = msgFull.indexOf(SEPARATOR);
        String msg = "";
        String tip = "";
        if (pos == -1) {
            msg = msgFull;
        } else {
            msg = msgFull.substring(0, pos);
            int start = pos + SEPARATOR.length();
            tip = msgFull.substring(start);
        }
        return new ValueNamePair(msg, tip);
    }

    public static String getMsg(String ad_language, String AD_Message, boolean getText) {
        String retStr = Msg.getMsg(ad_language, AD_Message);
        ValueNamePair msgTipPair = Msg.splitToMsgTip(retStr);
        if (getText) {
            return msgTipPair.getValue();
        }
        return msgTipPair.getName();
    }

    public static String getMsg(Properties ctx, String AD_Message, boolean getText) {
        return Msg.getMsg(Env.getAD_Language(ctx), AD_Message, getText);
    }

    public static String getMsg(Language language, String AD_Message, boolean getText) {
        return Msg.getMsg(language.getAD_Language(), AD_Message, getText);
    }

    public static String getMsg(Properties ctx, String AD_Message, Object[] args) {
        return Msg.getMsg(Env.getAD_Language(ctx), AD_Message, args);
    }

    public static String getMsg(Language language, String AD_Message, Object[] args) {
        return Msg.getMsg(language.getAD_Language(), AD_Message, args);
    }

    public static String getMsg(String ad_language, String AD_Message, Object[] args) {
        String msg;
        String retStr = msg = Msg.getMsg(ad_language, AD_Message);
        try {
            retStr = new MessageFormat(msg, Language.getLocale(ad_language)).format(args);
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, msg, e);
        }
        return retStr;
    }

    public static String getAmtInWords(Language language, String amount) {
        if (amount == null || language == null) {
            return amount;
        }
        Object className = "org.compiere.util.AmtInWords_";
        try {
            className = (String)className + language.getLanguageCode().toUpperCase();
            Class<?> clazz = Class.forName((String)className);
            AmtInWords aiw = (AmtInWords)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return aiw.getAmtInWords(amount);
        }
        catch (ClassNotFoundException classNotFoundException) {
            s_log.warning("Class not found: " + (String)className);
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, (String)className, e);
        }
        StringBuilder sb = new StringBuilder();
        int pos = amount.lastIndexOf(46);
        int pos2 = amount.lastIndexOf(44);
        if (pos2 > pos) {
            pos = pos2;
        }
        int i2 = 0;
        while (i2 < amount.length()) {
            if (pos == i2) {
                String cents = amount.substring(i2 + 1);
                sb.append(' ').append(cents).append("/100");
                break;
            }
            char c = amount.charAt(i2);
            if (c != ',' && c != '.') {
                if (sb.length() > 0) {
                    sb.append("*");
                }
                sb.append(Msg.getMsg(language, String.valueOf(c)));
            }
            ++i2;
        }
        return sb.toString();
    }

    public static String getElement(String ad_language, String ColumnName, boolean isSOTrx) {
        return Msg.getElement(ad_language, ColumnName, isSOTrx, false);
    }

    public static String getElement(String ad_language, String ColumnName, boolean isSOTrx, boolean isPrintName) {
        String key;
        if (ColumnName == null || ColumnName.equals("")) {
            return "";
        }
        String AD_Language = ad_language;
        if (AD_Language == null || AD_Language.length() == 0) {
            AD_Language = Language.getBaseAD_Language();
        }
        Msg msg = Msg.get();
        CCache<String, String> cache = isPrintName ? msg.getElementPrintNameMap(AD_Language) : msg.getElementMap(AD_Language);
        String retStr = cache.get(key = ColumnName + "|" + isSOTrx);
        if (retStr != null) {
            return retStr;
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                if (AD_Language == null || AD_Language.length() == 0 || Env.isBaseLanguage(AD_Language, "AD_Element")) {
                    sql = new StringBuilder("SELECT").append(isPrintName ? " PrintName, PO_PrintName" : " Name, PO_Name").append(" FROM AD_Element WHERE UPPER(ColumnName)=?");
                    pstmt = DB.prepareStatement(sql.toString(), null);
                } else {
                    sql = new StringBuilder("SELECT").append(isPrintName ? " t.PrintName, t.PO_PrintName" : " t.Name, t.PO_Name").append(" FROM AD_Element_Trl t, AD_Element e").append(" WHERE t.AD_Element_ID=e.AD_Element_ID AND UPPER(e.ColumnName)=?").append(" AND t.AD_Language=?");
                    pstmt = DB.prepareStatement(sql.toString(), null);
                    pstmt.setString(2, AD_Language);
                }
                pstmt.setString(1, ColumnName.toUpperCase());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    String temp;
                    retStr = rs.getString(1);
                    if (!isSOTrx && (temp = rs.getString(2)) != null && temp.length() > 0) {
                        retStr = temp;
                    }
                }
            }
            catch (SQLException e) {
                s_log.log(Level.SEVERE, "getElement", e);
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return "";
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        retStr = retStr == null ? "" : retStr.trim();
        cache.put(key, retStr);
        return retStr;
    }

    public static String getElement(Properties ctx, String ColumnName) {
        return Msg.getElement(Env.getAD_Language(ctx), ColumnName, true);
    }

    public static String getElement(Properties ctx, String ColumnName, boolean isSOTrx) {
        return Msg.getElement(Env.getAD_Language(ctx), ColumnName, isSOTrx);
    }

    public static String translate(String ad_language, boolean isSOTrx, String text) {
        return Msg.translate(ad_language, isSOTrx, text, false);
    }

    public static String translate(String ad_language, boolean isSOTrx, String text, boolean isPrintName) {
        String retStr;
        if (text == null || text.equals("")) {
            return "";
        }
        String AD_Language = ad_language;
        if (AD_Language == null || AD_Language.length() == 0) {
            AD_Language = Language.getBaseAD_Language();
        }
        if ((retStr = Msg.get().lookup(AD_Language, text)) != null) {
            return retStr;
        }
        retStr = Msg.getElement(AD_Language, text, isSOTrx, isPrintName);
        if (!retStr.equals("")) {
            return retStr.trim();
        }
        if (!text.startsWith("*")) {
            s_log.warning("NOT found: " + text);
        }
        return text;
    }

    public static String translate(String ad_language, String text) {
        return Msg.translate(ad_language, true, text);
    }

    public static String translate(Properties ctx, String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        String s = ctx.getProperty(text);
        if (s != null && s.length() > 0) {
            return s;
        }
        return Msg.translate(Env.getAD_Language(ctx), Env.isSOTrx(ctx), text);
    }

    public static String translate(Language language, String text) {
        return Msg.translate(language.getAD_Language(), false, text);
    }

    public static String parseTranslation(Properties ctx, String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        Object inStr = text;
        StringBuilder outStr = new StringBuilder();
        int i2 = ((String)inStr).indexOf(64);
        while (i2 != -1) {
            outStr.append(((String)inStr).substring(0, i2));
            inStr = ((String)inStr).substring(i2 + 1, ((String)inStr).length());
            int j = ((String)inStr).indexOf(64);
            if (j < 0) {
                inStr = "@" + (String)inStr;
                break;
            }
            String token = ((String)inStr).substring(0, j);
            outStr.append(Msg.translate(ctx, token));
            inStr = ((String)inStr).substring(j + 1, ((String)inStr).length());
            i2 = ((String)inStr).indexOf(64);
        }
        outStr.append((String)inStr);
        return outStr.toString();
    }

    public static boolean hasTranslation(String adLanguage, String text) {
        String retStr;
        if (Util.isEmpty(text, true)) {
            return false;
        }
        String AD_Language = adLanguage;
        if (AD_Language == null || AD_Language.length() == 0) {
            AD_Language = Language.getBaseAD_Language();
        }
        if (!Util.isEmpty(retStr = Msg.get().lookup(AD_Language, text), true)) {
            return true;
        }
        retStr = Msg.getElement(AD_Language, text, false);
        return !Util.isEmpty(retStr, true);
    }

    public static String getCleanMsg(Properties ctx, String string) {
        return Util.cleanAmp(Msg.getMsg(Env.getAD_Language(ctx), string));
    }
}

