/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.zk.billboard.chart;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MChart;
import org.compiere.model.MChartDatasource;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.idempiere.zk.billboard.Billboard;
import org.zkoss.zul.CategoryModel;
import org.zkoss.zul.ChartModel;
import org.zkoss.zul.PieModel;
import org.zkoss.zul.SimpleCategoryModel;
import org.zkoss.zul.SimplePieModel;
import org.zkoss.zul.SimpleXYModel;
import org.zkoss.zul.XYModel;

public class ChartBuilder {
    private static final CLogger log = CLogger.getCLogger(ChartBuilder.class);
    protected final SimpleDateFormat tsDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private MChart mChart;
    private HashMap<String, MQuery> queries;
    private ChartModel chartModel;
    private java.util.Date minDate;
    private java.util.Date maxDate;

    public ChartBuilder(MChart chart) {
        this.mChart = chart;
    }

    public Billboard createChart() {
        String type = this.mChart.getChartType();
        if ("BC".equals(type)) {
            if (this.mChart.isTimeSeries()) {
                return this.createXYBarChart();
            }
            return this.createBarChart();
        }
        if ("B3".equals(type)) {
            return this.create3DBarChart();
        }
        if ("BS".equals(type)) {
            if (this.mChart.isTimeSeries()) {
                return this.createXYBarChart();
            }
            return this.createStackedBarChart();
        }
        if ("B4".equals(type)) {
            return this.create3DStackedBarChart();
        }
        if ("P3".equals(type)) {
            return this.create3DPieChart();
        }
        if ("PC".equals(type)) {
            return this.createPieChart();
        }
        if ("L3".equals(type)) {
            return this.create3DLineChart();
        }
        if ("AC".equals(type)) {
            return this.createAreaChart();
        }
        if ("AS".equals(type)) {
            return this.createStackedAreaChart();
        }
        if ("LC".equals(type)) {
            if (this.mChart.isTimeSeries()) {
                return this.createTimeSeriesChart();
            }
            return this.createLineChart();
        }
        if ("RC".equals(type)) {
            return this.createRingChart();
        }
        if ("WC".equals(type)) {
            return this.createWaterfallChart();
        }
        throw new IllegalArgumentException("unknown chart type=" + type);
    }

    public void loadData() {
        this.queries = new HashMap();
        for (MChartDatasource ds : this.mChart.getDatasources()) {
            this.addData(ds);
        }
    }

    private void addData(MChartDatasource ds) {
        String where;
        Object category;
        String value = ds.getValueColumn();
        String unit = "D";
        if (!this.mChart.isTimeSeries()) {
            category = ds.getCategoryColumn();
        } else {
            if (this.mChart.getTimeUnit().equals("W")) {
                unit = "W";
            } else if (this.mChart.getTimeUnit().equals("M")) {
                unit = "MM";
            } else if (this.mChart.getTimeUnit().equals("Q")) {
                unit = "Q";
            } else if (this.mChart.getTimeUnit().equals("Y")) {
                unit = "Y";
            }
            category = " TRUNC(" + ds.getDateColumn() + ", '" + unit + "') ";
        }
        String series = DB.TO_STRING((String)ds.get_Translation("Name"));
        boolean hasSeries = false;
        if (ds.getSeriesColumn() != null) {
            series = ds.getSeriesColumn();
            hasSeries = true;
        }
        if (!Util.isEmpty((String)(where = ds.getWhereClause()))) {
            where = Env.parseContext((Properties)Env.getCtx(), (int)this.mChart.getWindowNo(), (String)where, (boolean)true);
        }
        boolean hasWhere = false;
        Object sql = "SELECT " + value + ", " + (String)category + ", " + series + " FROM " + ds.getFromClause();
        if (!Util.isEmpty((String)where)) {
            sql = (String)sql + " WHERE " + where;
            hasWhere = true;
        }
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        java.util.Date startDate = null;
        java.util.Date endDate = null;
        int scope = this.mChart.getTimeScope();
        int offset = ds.getTimeOffset();
        if (this.mChart.isTimeSeries() && scope != 0) {
            startDate = this.increment(currentDate, this.mChart.getTimeUnit(), offset += -scope);
            endDate = this.increment(startDate, this.mChart.getTimeUnit(), scope);
        }
        if (startDate != null && endDate != null) {
            sql = (String)sql + (hasWhere ? " AND " : " WHERE ");
            sql = (String)sql + (String)category + ">=TRUNC(" + DB.TO_DATE((Timestamp)new Timestamp(startDate.getTime())) + ", '" + unit + "') AND ";
            sql = (String)sql + (String)category + "<=TRUNC(" + DB.TO_DATE((Timestamp)new Timestamp(endDate.getTime())) + ", '" + unit + "') ";
        }
        if (((String)sql).indexOf(64) >= 0) {
            sql = Env.parseContext((Properties)Env.getCtx(), (int)0, (String)sql, (boolean)false, (boolean)true);
        }
        MRole role = MRole.getDefault((Properties)Env.getCtx(), (boolean)false);
        sql = role.addAccessSQL((String)sql, null, true, false);
        sql = hasSeries ? (String)sql + " GROUP BY " + series + ", " + (String)category + " ORDER BY " + series + ", " + (String)category : (String)sql + " GROUP BY " + (String)category + " ORDER BY " + (String)category;
        log.log(Level.FINE, (String)sql);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        ChartModel dataset = this.getChartModel();
        this.minDate = null;
        this.maxDate = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String key = rs.getString(2);
                    String seriesName = rs.getString(3);
                    if (seriesName == null) {
                        seriesName = ds.getName();
                    }
                    Object queryWhere = "";
                    if (hasWhere) {
                        queryWhere = (String)queryWhere + where + " AND ";
                    }
                    queryWhere = (String)queryWhere + series + " = " + DB.TO_STRING((String)seriesName) + " AND " + (String)category + " = ";
                    if (this.mChart.isTimeSeries()) {
                        Date date = rs.getDate(2);
                        if (this.minDate == null || this.minDate.compareTo(date) > 0) {
                            this.minDate = date;
                        }
                        if (this.maxDate == null || this.maxDate.compareTo(date) < 0) {
                            this.maxDate = date;
                        }
                    }
                    if (this.mChart.isTimeSeries() && dataset instanceof XYModel) {
                        XYModel xy = (XYModel)dataset;
                        Date date = rs.getDate(2);
                        BigDecimal tsvalue = rs.getBigDecimal(1);
                        xy.addValue((Comparable)((Object)seriesName), (Number)date.getTime(), (Number)tsvalue);
                        key = this.tsDateFormat.format(date);
                        queryWhere = (String)queryWhere + DB.TO_DATE((Timestamp)new Timestamp(date.getTime()));
                    } else {
                        queryWhere = (String)queryWhere + DB.TO_STRING((String)key);
                    }
                    MQuery query = new MQuery(ds.getAD_Table_ID());
                    String keyCol = MTable.get((Properties)Env.getCtx(), (int)ds.getAD_Table_ID()).getKeyColumns()[0];
                    String whereClause = keyCol + " IN (SELECT " + ds.getKeyColumn() + " FROM " + ds.getFromClause() + " WHERE " + (String)queryWhere + " )";
                    query.addRestriction(whereClause.toString());
                    query.setRecordCount(1);
                    HashMap<String, MQuery> map = this.getQueries();
                    if (dataset instanceof PieModel) {
                        ((PieModel)dataset).setValue((Comparable)((Object)key), (Number)rs.getBigDecimal(1));
                        map.put(key, query);
                        continue;
                    }
                    if (dataset instanceof CategoryModel) {
                        ((CategoryModel)dataset).setValue((Comparable)((Object)seriesName), (Comparable)((Object)key), (Number)rs.getBigDecimal(1));
                        map.put(seriesName + "__" + key, query);
                        continue;
                    }
                    if (!(dataset instanceof XYModel)) continue;
                    map.put(seriesName + "__" + key, query);
                }
            }
            catch (SQLException e) {
                throw new DBException(e, (String)sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
    }

    private java.util.Date increment(java.util.Date lastDate, String timeUnit, int qty) {
        if (lastDate == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(lastDate);
        if (timeUnit.equals("D")) {
            cal.add(6, qty);
        } else if (timeUnit.equals("W")) {
            cal.add(3, qty);
        } else if (timeUnit.equals("M")) {
            cal.add(2, qty);
        } else if (timeUnit.equals("Q")) {
            cal.add(2, 3 * qty);
        } else if (timeUnit.equals("Y")) {
            cal.add(1, qty);
        }
        return cal.getTime();
    }

    public CategoryModel getCategoryModel() {
        this.chartModel = new SimpleCategoryModel();
        this.loadData();
        return (CategoryModel)this.chartModel;
    }

    public XYModel getXYModel() {
        this.chartModel = new SimpleXYModel();
        this.loadData();
        return (XYModel)this.chartModel;
    }

    public PieModel getPieModel() {
        this.chartModel = new SimplePieModel();
        this.loadData();
        return (PieModel)this.chartModel;
    }

    public ChartModel getChartModel() {
        return this.chartModel;
    }

    public HashMap<String, MQuery> getQueries() {
        return this.queries;
    }

    public MQuery getQuery(String key) {
        if (this.queries.containsKey(key)) {
            return this.queries.get(key);
        }
        return null;
    }

    private Billboard createXYBarChart() {
        Billboard billboard = this.newBillboard("bar");
        XYModel xymodel = this.getXYModel();
        SimpleCategoryModel model = new SimpleCategoryModel();
        Collection seriesList = xymodel.getSeries();
        for (Comparable series : seriesList) {
            int count = xymodel.getDataCount(series);
            int i = 0;
            while (i < count) {
                Number value = xymodel.getY(series, i);
                Number category = xymodel.getX(series, i);
                java.util.Date date = new java.util.Date(category.longValue());
                String categoryLabel = null;
                categoryLabel = this.tsDateFormat.format(date);
                Number oldValue = model.getValue(series, (Comparable)((Object)categoryLabel));
                if (oldValue != null) {
                    value = oldValue.doubleValue() + value.doubleValue();
                }
                model.setValue(series, (Comparable)((Object)categoryLabel), value);
                ++i;
            }
        }
        billboard.setModel((ChartModel)model);
        return billboard;
    }

    private Billboard createTimeSeriesChart() {
        Billboard billboard = this.newBillboard("line");
        XYModel xymodel = this.getXYModel();
        SimpleCategoryModel model = new SimpleCategoryModel();
        Collection seriesList = xymodel.getSeries();
        for (Comparable series : seriesList) {
            int count = xymodel.getDataCount(series);
            int i = 0;
            while (i < count) {
                Number value = xymodel.getY(series, i);
                Number category = xymodel.getX(series, i);
                java.util.Date date = new java.util.Date(category.longValue());
                String categoryLabel = null;
                categoryLabel = this.tsDateFormat.format(date);
                Number oldValue = model.getValue(series, (Comparable)((Object)categoryLabel));
                if (oldValue != null) {
                    value = oldValue.doubleValue() + value.doubleValue();
                }
                model.setValue(series, (Comparable)((Object)categoryLabel), value);
                ++i;
            }
        }
        billboard.setModel((ChartModel)model);
        return billboard;
    }

    private Billboard createWaterfallChart() {
        Billboard billboard = this.newBillboard("waterfall");
        CategoryModel model = this.getCategoryModel();
        SimpleCategoryModel waterfallModel = new SimpleCategoryModel();
        Collection seriesList = model.getSeries();
        HashMap<Comparable, BigDecimal> valueMap = new HashMap<Comparable, BigDecimal>();
        Collection categories = model.getCategories();
        for (Comparable series : seriesList) {
            for (Comparable category : categories) {
                BigDecimal value;
                BigDecimal diff = value = (BigDecimal)model.getValue(series, category);
                BigDecimal oldValue = (BigDecimal)valueMap.get(series);
                if (oldValue != null) {
                    diff = diff.subtract(oldValue);
                }
                valueMap.put(series, value);
                waterfallModel.setValue(series, category, (Number)diff);
            }
        }
        billboard.setModel((ChartModel)waterfallModel);
        return billboard;
    }

    private Billboard newBillboard(String type) {
        Billboard billboard = new Billboard();
        billboard.setLegend(this.mChart.isDisplayLegend(), false);
        billboard.setTickAxisLabel(this.mChart.get_Translation("DomainLabel"));
        billboard.setValueAxisLabel(this.mChart.get_Translation("RangeLabel"));
        billboard.setTitle(this.mChart.get_Translation("Name"));
        billboard.setType(type);
        billboard.setLocale(Env.getContext((Properties)Env.getCtx(), (String)"#Locale"));
        return billboard;
    }

    private Billboard createRingChart() {
        Billboard billboard = this.newBillboard("donut");
        billboard.setModel((ChartModel)this.getPieModel());
        return billboard;
    }

    private Billboard createPieChart() {
        Billboard billboard = this.newBillboard("pie");
        billboard.setModel((ChartModel)this.getPieModel());
        return billboard;
    }

    private Billboard create3DPieChart() {
        return this.createPieChart();
    }

    private Billboard createBarChart() {
        Billboard billboard = this.newBillboard("bar");
        billboard.setModel((ChartModel)this.getCategoryModel());
        if ("V".equals(this.mChart.getChartOrientation())) {
            billboard.setOrient("vertical");
        } else if ("H".equals(this.mChart.getChartOrientation())) {
            billboard.setOrient("horizontal");
        }
        return billboard;
    }

    private Billboard create3DBarChart() {
        return this.createBarChart();
    }

    private Billboard createStackedBarChart() {
        Billboard billboard = this.newBillboard("stacked_bar");
        billboard.setModel((ChartModel)this.getCategoryModel());
        if ("V".equals(this.mChart.getChartOrientation())) {
            billboard.setOrient("vertical");
        } else if ("H".equals(this.mChart.getChartOrientation())) {
            billboard.setOrient("horizontal");
        }
        return billboard;
    }

    private Billboard create3DStackedBarChart() {
        return this.createStackedBarChart();
    }

    private Billboard createAreaChart() {
        Billboard billboard = this.newBillboard("area");
        billboard.setModel((ChartModel)this.getCategoryModel());
        return billboard;
    }

    private Billboard createStackedAreaChart() {
        Billboard billboard = this.newBillboard("stacked_area");
        billboard.setModel((ChartModel)this.getCategoryModel());
        return billboard;
    }

    private Billboard createLineChart() {
        Billboard billboard = this.newBillboard("line");
        billboard.setModel((ChartModel)this.getCategoryModel());
        return billboard;
    }

    private Billboard create3DLineChart() {
        return this.createLineChart();
    }

    public java.util.Date getMinDate() {
        return this.minDate;
    }

    public void setMinDate(java.util.Date minDate) {
        this.minDate = minDate;
    }

    public java.util.Date getMaxDate() {
        return this.maxDate;
    }

    public void setMaxDate(java.util.Date maxDate) {
        this.maxDate = maxDate;
    }
}

