/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.model;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.base.AnnotationBasedColumnCalloutFactory;
import org.adempiere.base.Core;
import org.adempiere.base.IColumnCallout;
import org.adempiere.base.IColumnCalloutFactory;
import org.adempiere.base.annotation.Callout;
import org.adempiere.base.annotation.Callouts;
import org.adempiere.model.CalloutInfoWindow;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.TestActivator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.mockito.Mockito;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class AnnotationColumnCalloutFactoryTest
extends AbstractTestCase {
    @Test
    @Order(value=1)
    public void testRepeatableAnnotationCalloutFactory() throws ClassNotFoundException, InterruptedException {
        List list;
        Optional<IColumnCallout> optional;
        BundleContext bc = TestActivator.context;
        TestAnnotationBasedColumnCalloutFactory factory = new TestAnnotationBasedColumnCalloutFactory();
        ComponentContext mockContext = (ComponentContext)Mockito.mock(ComponentContext.class);
        Mockito.when((Object)mockContext.getBundleContext()).thenReturn((Object)bc);
        factory.activate(mockContext);
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
        ((Dictionary)properties).put("service.ranking", 1);
        bc.registerService(IColumnCalloutFactory.class, (Object)factory, properties);
        do {
            Thread.sleep(1000L);
            list = Core.findCallout((String)"AD_Tab", (String)"Name");
        } while (!(optional = list.stream().filter(TestNonRepeatableAnnotatedCallout.class::isInstance).findFirst()).isPresent());
        list = Core.findCallout((String)"AD_InfoWindow", (String)"AD_Table_ID");
        optional = list.stream().filter(TestRepeatableAnnotatedCallout.class::isInstance).findFirst();
        Assertions.assertTrue((boolean)optional.isPresent(), (String)"Can't find TestRepeatableAnnotatedCallout column callout for AD_InfoWindow.AD_Table_ID");
        list = Core.findCallout((String)"AD_InfoWindow", (String)"AD_Table_ID");
        optional = list.stream().filter(CalloutInfoWindow.class::isInstance).findFirst();
        Assertions.assertTrue((boolean)optional.isPresent(), (String)"Can't find CalloutInfoWindow column callout for AD_InfoWindow.AD_Table_ID");
    }

    private static final class TestAnnotationBasedColumnCalloutFactory
    extends AnnotationBasedColumnCalloutFactory {
        private TestAnnotationBasedColumnCalloutFactory() {
        }

        protected String[] getPackages() {
            return new String[]{TestRepeatableAnnotatedCallout.class.getPackageName()};
        }
    }

    @Callout(tableName={"AD_Tab"}, columnName={"Name", "SeqNo"})
    public static class TestNonRepeatableAnnotatedCallout
    implements IColumnCallout {
        public String start(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
            return null;
        }
    }

    @Callouts(value={@Callout(tableName={"AD_InfoWindow"}, columnName={"AD_Table_ID"}), @Callout(tableName={"AD_InfoColumn"}, columnName={"AD_Element_ID", "AD_Reference_ID"})})
    public static class TestRepeatableAnnotatedCallout
    implements IColumnCallout {
        public String start(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
            return null;
        }
    }
}

