/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.base;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import org.adempiere.apps.graph.ChartBuilder;
import org.compiere.model.MChart;
import org.compiere.model.MChartDatasource;
import org.idempiere.test.AbstractTestCase;
import org.jfree.chart.JFreeChart;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class JfreeChartBuilderTest
extends AbstractTestCase {
    @Mock
    private MChart chartModel;
    private ChartBuilder chartBuilder;

    @BeforeEach
    public void setUp() {
        this.chartBuilder = new ChartBuilder(this.chartModel);
    }

    @Test
    void createChartReturnsBarChartForBarChartType() {
        Mockito.when((Object)this.chartModel.getChartType()).thenReturn((Object)"BC");
        Mockito.when((Object)this.chartModel.isTimeSeries()).thenReturn((Object)false);
        JFreeChart chart = this.chartBuilder.createChart();
        Assertions.assertNotNull((Object)chart);
    }

    @Test
    void createChartReturns3DBarChartFor3DBarChartType() {
        Mockito.when((Object)this.chartModel.getChartType()).thenReturn((Object)"B3");
        JFreeChart chart = this.chartBuilder.createChart();
        Assertions.assertNotNull((Object)chart);
    }

    @Test
    void createChartThrowsExceptionForUnknownChartType() {
        Mockito.when((Object)this.chartModel.getChartType()).thenReturn((Object)"UnknownType");
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            JFreeChart jFreeChart = this.chartBuilder.createChart();
        });
    }

    @Test
    void loadDataPopulatesQueries() {
        MChartDatasource ds = (MChartDatasource)Mockito.mock(MChartDatasource.class);
        Mockito.when((Object)this.chartModel.getDatasources()).thenReturn(Collections.singletonList(ds));
        Mockito.when((Object)this.chartModel.isTimeSeries()).thenReturn((Object)true);
        Mockito.when((Object)this.chartModel.getTimeUnit()).thenReturn((Object)"M");
        Mockito.when((Object)ds.getValueColumn()).thenReturn((Object)"sum(c_orderline.qtyEntered)");
        Mockito.when((Object)ds.getDateColumn()).thenReturn((Object)"c_orderline.created");
        Mockito.when((Object)ds.getSeriesColumn()).thenReturn((Object)"m_product_category.name");
        Mockito.when((Object)ds.getFromClause()).thenReturn((Object)"C_OrderLine INNER JOIN m_product ON (c_orderline.m_product_id = m_product.m_product_id) INNER JOIN m_product_category ON (m_product.m_product_category_id = m_product_category.m_product_category_id) ");
        Mockito.when((Object)ds.getAD_Table_ID()).thenReturn((Object)260);
        Mockito.when((Object)ds.getKeyColumn()).thenReturn((Object)"C_OrderLine_ID");
        Assertions.assertNotNull((Object)this.chartBuilder.getXYDataset());
        Assertions.assertFalse((boolean)this.chartBuilder.getQueries().isEmpty());
    }

    @Test
    void getCategoryDatasetReturnsNonNullDataset() {
        CategoryDataset dataset = this.chartBuilder.getCategoryDataset();
        Assertions.assertNotNull((Object)dataset);
    }

    @Test
    void getXYDatasetReturnsNonNullDataset() {
        IntervalXYDataset dataset = this.chartBuilder.getXYDataset();
        Assertions.assertNotNull((Object)dataset);
    }

    @Test
    void getPieDatasetReturnsNonNullDataset() {
        PieDataset dataset = this.chartBuilder.getPieDataset();
        Assertions.assertNotNull((Object)dataset);
    }

    @Test
    void incrementReturnsCorrectDateForDayUnit() {
        Date date = new Date();
        Date incrementedDate = this.chartBuilder.increment(date, "D", 5);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(6, 5);
        Assertions.assertEquals((Object)cal.getTime(), (Object)incrementedDate);
    }

    @Test
    void incrementReturnsCorrectDateForMonthUnit() {
        Date date = new Date();
        Date incrementedDate = this.chartBuilder.increment(date, "M", 2);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, 2);
        Assertions.assertEquals((Object)cal.getTime(), (Object)incrementedDate);
    }
}

