/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.base;

import org.adempiere.base.IModelFactory;
import org.adempiere.base.IModelValidatorFactory;
import org.adempiere.base.IServiceHolder;
import org.adempiere.base.IServicesHolder;
import org.adempiere.base.ServiceQuery;
import org.adempiere.base.ds.DynamicServiceLocator;
import org.adempiere.base.ds.ServiceRankingComparator;
import org.adempiere.exceptions.AdempiereException;
import org.assertj.core.api.Assertions;
import org.compiere.db.AdempiereDatabase;
import org.idempiere.model.IMappedModelFactory;
import org.junit.jupiter.api.Test;
import org.osgi.framework.ServiceReference;

public class DynamicServiceLocatorTest {
    private DynamicServiceLocator dynamicServiceLocator = new DynamicServiceLocator();

    @Test
    void locateReturnsServiceHolderForValidType() {
        IServiceHolder result = this.dynamicServiceLocator.locate(IModelValidatorFactory.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result.getService());
        result = this.dynamicServiceLocator.locate(this.getClass());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
        org.junit.jupiter.api.Assertions.assertNull((Object)result.getService());
        org.junit.jupiter.api.Assertions.assertNull((Object)result.getServiceReference());
    }

    @Test
    void locateReturnsServiceHolderForTypeAndQuery() {
        ServiceQuery query = new ServiceQuery();
        query.put((Object)"id", (Object)"PostgreSQL");
        IServiceHolder result = this.dynamicServiceLocator.locate(AdempiereDatabase.class, query);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result.getService());
        result = this.dynamicServiceLocator.locate(IMappedModelFactory.class, null);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result.getService());
    }

    @Test
    void locateReturnsServiceHolderForTypeServiceIdAndQuery() {
        IServiceHolder result = this.dynamicServiceLocator.locate(IMappedModelFactory.class, null, null);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result.getService());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result.getServiceReference());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result.getServiceReference().getServiceReference());
        ServiceReference serviceReference = result.getServiceReference().getServiceReference();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ServiceRankingComparator.INSTANCE.compare(serviceReference, serviceReference));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ServiceRankingComparator.INSTANCE.compare(serviceReference, null));
        result = this.dynamicServiceLocator.locate(IMappedModelFactory.class, "org.idempiere.model.MappedModelFactory", null);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result.getService());
        ServiceQuery query = new ServiceQuery();
        query.put((Object)"id", (Object)"PostgreSQL");
        result = this.dynamicServiceLocator.locate(AdempiereDatabase.class, "org.compiere.db.DB_PostgreSQL", query);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result.getService());
    }

    @Test
    void listReturnsServicesHolderForValidType() {
        IServicesHolder result = this.dynamicServiceLocator.list(IModelValidatorFactory.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result.getServices());
        org.junit.jupiter.api.Assertions.assertTrue((result.getServices().size() > 0 ? 1 : 0) != 0);
        result = this.dynamicServiceLocator.list(IModelFactory.class, null);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result.getServices());
        org.junit.jupiter.api.Assertions.assertTrue((result.getServices().size() > 0 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result.getServiceReferences());
        org.junit.jupiter.api.Assertions.assertTrue((result.getServiceReferences().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    void listReturnsServicesHolderForTypeAndQuery() {
        ServiceQuery query = new ServiceQuery();
        query.put((Object)"id", (Object)"PostgreSQL");
        IServicesHolder result = this.dynamicServiceLocator.list(AdempiereDatabase.class, query);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result.getServices());
        org.junit.jupiter.api.Assertions.assertTrue((result.getServices().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    void listReturnsServicesHolderForTypeServiceIdAndQuery() {
        String serviceId = "org.compiere.db.DB_PostgreSQL";
        ServiceQuery query = new ServiceQuery();
        query.put((Object)"id", (Object)"PostgreSQL");
        IServicesHolder result = this.dynamicServiceLocator.list(AdempiereDatabase.class, serviceId, query);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result.getServices());
        org.junit.jupiter.api.Assertions.assertTrue((result.getServices().size() > 0 ? 1 : 0) != 0);
        result = this.dynamicServiceLocator.list(AdempiereDatabase.class, serviceId, null);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result.getServices());
        org.junit.jupiter.api.Assertions.assertTrue((result.getServices().size() > 0 ? 1 : 0) != 0);
        result = this.dynamicServiceLocator.list(AdempiereDatabase.class, null, null);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result.getServices());
        org.junit.jupiter.api.Assertions.assertTrue((result.getServices().size() > 0 ? 1 : 0) != 0);
        Assertions.assertThatExceptionOfType(AdempiereException.class).isThrownBy(() -> {
            IServicesHolder iServicesHolder = this.dynamicServiceLocator.list(AdempiereDatabase.class, ")", null);
        });
    }
}

