/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.base;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.Util;
import org.idempiere.test.AbstractTestCase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UtilTest
extends AbstractTestCase {
    @Test
    void replace() {
        Assertions.assertEquals((Object)"This is a test.", (Object)Util.replace((String)"This is a test.", (String)"old", (String)"new"));
        Assertions.assertEquals((Object)"This is a new.", (Object)Util.replace((String)"This is a old.", (String)"old", (String)"new"));
        Assertions.assertEquals((Object)"This is a .", (Object)Util.replace((String)"This is a old.", (String)"old", (String)""));
        Assertions.assertEquals((Object)"This is a .", (Object)Util.replace((String)"This is a old.", (String)"old", null));
        Assertions.assertEquals((Object)"This is a old.", (Object)Util.replace((String)"This is a old.", null, (String)"new"));
        Assertions.assertEquals((Object)"This is a old.", (Object)Util.replace((String)"This is a old.", (String)"", (String)"new"));
        Assertions.assertEquals((Object)"", (Object)Util.replace((String)"", (String)"old", (String)"new"));
        Assertions.assertNull((Object)Util.replace(null, (String)"old", (String)"new"));
        Assertions.assertEquals((Object)"newnewnew", (Object)Util.replace((String)"oldoldold", (String)"old", (String)"new"));
    }

    @Test
    void removeCRLF() {
        Assertions.assertEquals((Object)"Thisisatest.", (Object)Util.removeCRLF((String)"This\nis\ra\ntest."));
        Assertions.assertEquals((Object)"NoCRLF", (Object)Util.removeCRLF((String)"NoCRLF"));
        Assertions.assertEquals((Object)"", (Object)Util.removeCRLF((String)"\n\r\n\r"));
    }

    @Test
    void cleanWhitespace() {
        Assertions.assertEquals((Object)"This is a test.", (Object)Util.cleanWhitespace((String)"This   is  a    test."));
        Assertions.assertEquals((Object)" This is a test. ", (Object)Util.cleanWhitespace((String)"  This   is  a    test.  "));
        Assertions.assertEquals((Object)"NoWhitespace", (Object)Util.cleanWhitespace((String)"NoWhitespace"));
        Assertions.assertEquals((Object)" ", (Object)Util.cleanWhitespace((String)"     "));
        Assertions.assertEquals((Object)"", (Object)Util.cleanWhitespace((String)""));
    }

    @Test
    void maskHTML() {
        Assertions.assertEquals((Object)"&lt;html&gt;", (Object)Util.maskHTML((String)"<html>"));
        Assertions.assertEquals((Object)"&lt;html&gt;&amp;&quot;&#039;", (Object)Util.maskHTML((String)"<html>&\"'"));
        Assertions.assertEquals((Object)"Normal", (Object)Util.maskHTML((String)"Normal"));
        Assertions.assertEquals((Object)"&lt;br&gt;", (Object)Util.maskHTML((String)"<br>"));
        Assertions.assertEquals((Object)"&#55357;&#56832;", (Object)Util.maskHTML((String)"\ud83d\ude00"));
        Assertions.assertEquals((Object)"Line1<br>Line2", (Object)Util.maskHTML((String)"Line1\nLine2", (boolean)true));
        Assertions.assertEquals((Object)"Line1Line2", (Object)Util.maskHTML((String)"Line1\nLine2", (boolean)false));
        Assertions.assertNull((Object)Util.maskHTML(null, (boolean)true));
        Assertions.assertNull((Object)Util.maskHTML(null));
    }

    @Test
    void getCount() {
        Assertions.assertEquals((int)3, (int)Util.getCount((String)"This is a test.", (char)'s'));
        Assertions.assertEquals((int)0, (int)Util.getCount((String)"This is a test.", (char)'z'));
        Assertions.assertEquals((int)0, (int)Util.getCount(null, (char)'s'));
        Assertions.assertEquals((int)0, (int)Util.getCount((String)"", (char)'a'));
        Assertions.assertEquals((int)3, (int)Util.getCount((String)"aaa", (char)'a'));
    }

    @Test
    void isEmpty() {
        Assertions.assertTrue((boolean)Util.isEmpty(null));
        Assertions.assertTrue((boolean)Util.isEmpty((String)""));
        Assertions.assertFalse((boolean)Util.isEmpty((String)" "));
        Assertions.assertFalse((boolean)Util.isEmpty((String)"test"));
        Assertions.assertTrue((boolean)Util.isEmpty(null, (boolean)true));
        Assertions.assertTrue((boolean)Util.isEmpty((String)"", (boolean)true));
        Assertions.assertTrue((boolean)Util.isEmpty((String)" ", (boolean)true));
        Assertions.assertFalse((boolean)Util.isEmpty((String)" test ", (boolean)true));
        Assertions.assertFalse((boolean)Util.isEmpty((String)"test", (boolean)true));
    }

    @Test
    void deleteAccents() {
        Assertions.assertEquals((Object)"aAaaeeiioouu", (Object)Util.deleteAccents((String)"\u00e0\u00c1\u00e2\u00e4\u00e8\u00e9\u00ee\u00ef\u00f6\u00f4\u00fc\u00fb"));
        Assertions.assertEquals((Object)"This is a test.", (Object)Util.deleteAccents((String)"This is a test."));
        Assertions.assertEquals((Object)"", (Object)Util.deleteAccents((String)""));
    }

    @Test
    void findIndexOf() {
        Assertions.assertEquals((int)-1, (int)Util.findIndexOf((String)"abc'd'efg", (char)'d'));
        Assertions.assertEquals((int)6, (int)Util.findIndexOf((String)"abc'd'efg", (char)'d', (char)'e'));
        Assertions.assertEquals((int)8, (int)Util.findIndexOf((String)"abc(def)g", (char)'g'));
        Assertions.assertEquals((int)11, (int)Util.findIndexOf((String)"abc(def(g))h", (char)'h'));
        Assertions.assertEquals((int)11, (int)Util.findIndexOf((String)"abc(def)(g)h", (char)'h'));
        Assertions.assertEquals((int)-1, (int)Util.findIndexOf(null, (char)'a'));
        Assertions.assertEquals((int)-1, (int)Util.findIndexOf((String)"abc'd'efg", (char)'z'));
        Assertions.assertEquals((int)11, (int)Util.findIndexOf((String)"abc(def)(g)h", (char)'h', (char)'g'));
        Assertions.assertEquals((int)-1, (int)Util.findIndexOf(null, (char)'a', (char)'b'));
        Assertions.assertEquals((int)-1, (int)Util.findIndexOf((String)"abc'd'efg", (char)'z', (char)'d'));
    }

    @Test
    void findIndexOfString() {
        Assertions.assertEquals((int)8, (int)Util.findIndexOf((String)"abc(def)ghi", (String)"ghi"));
        Assertions.assertEquals((int)8, (int)Util.findIndexOf((String)"abc'ghi'jkl", (String)"jkl"));
        Assertions.assertEquals((int)13, (int)Util.findIndexOf((String)"abc(def)(ghi)jkl", (String)"jkl"));
        Assertions.assertEquals((int)-1, (int)Util.findIndexOf(null, (String)"ghi"));
        Assertions.assertEquals((int)-1, (int)Util.findIndexOf((String)"abc(def)ghi", null));
        Assertions.assertEquals((int)-1, (int)Util.findIndexOf((String)"abc(def)ghi", (String)""));
        Assertions.assertEquals((int)-1, (int)Util.findIndexOf((String)"abc'ghi'jkl", (String)"ghi"));
        Assertions.assertEquals((int)-1, (int)Util.findIndexOf((String)"abc(def)(ghi)jkl", (String)"ghi"));
    }

    @Test
    void toHex() {
        Assertions.assertEquals((Object)"00", (Object)Util.toHex((byte)0));
        Assertions.assertEquals((Object)"ff", (Object)Util.toHex((byte)-1));
        Assertions.assertEquals((Object)"7f", (Object)Util.toHex((byte)127));
        Assertions.assertEquals((Object)"80", (Object)Util.toHex((byte)-128));
        Assertions.assertEquals((Object)"0000", (Object)Util.toHex((char)'\u0000'));
        Assertions.assertEquals((Object)"ffff", (Object)Util.toHex((char)'\uffff'));
        Assertions.assertEquals((Object)"7fff", (Object)Util.toHex((char)Short.MAX_VALUE));
    }

    @Test
    void initCap() {
        Assertions.assertEquals((Object)"This Is A Test", (Object)Util.initCap((String)"this is a test"));
        Assertions.assertEquals((Object)"This", (Object)Util.initCap((String)"this"));
        Assertions.assertEquals((Object)" ", (Object)Util.initCap((String)" "));
        Assertions.assertEquals((Object)"This Is A Test", (Object)Util.initCap((String)"THIS IS A TEST"));
        Assertions.assertEquals((Object)"", (Object)Util.initCap((String)""));
        Assertions.assertNull((Object)Util.initCap(null));
    }

    @Test
    void is8Bit() {
        Assertions.assertTrue((boolean)Util.is8Bit((String)"abc"));
        Assertions.assertTrue((boolean)Util.is8Bit((String)""));
        Assertions.assertTrue((boolean)Util.is8Bit(null));
        Assertions.assertFalse((boolean)Util.is8Bit((String)"a\ud83d\ude00"));
    }

    @Test
    void cleanAmp() {
        Assertions.assertEquals((Object)"abc", (Object)Util.cleanAmp((String)"&abc"));
        Assertions.assertEquals((Object)"abc", (Object)Util.cleanAmp((String)"abc"));
        Assertions.assertEquals((Object)"abc", (Object)Util.cleanAmp((String)"a&bc"));
        Assertions.assertEquals((Object)"a&bc", (Object)Util.cleanAmp((String)"&a&bc"));
        Assertions.assertEquals((Object)"", (Object)Util.cleanAmp((String)""));
        Assertions.assertNull((Object)Util.cleanAmp(null));
    }

    @Test
    void trimLength() {
        Assertions.assertEquals((Object)"test", (Object)Util.trimLength((String)"test", (int)4));
        Assertions.assertEquals((Object)"tes", (Object)Util.trimLength((String)"test", (int)3));
        Assertions.assertEquals((Object)"t", (Object)Util.trimLength((String)"test", (int)1));
        Assertions.assertEquals((Object)"test", (Object)Util.trimLength((String)"test", (int)10));
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            String string = Util.trimLength((String)"test", (int)0);
        });
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            String string = Util.trimLength((String)"test", (int)-1);
        });
        Assertions.assertNull((Object)Util.trimLength(null, (int)10));
    }

    @Test
    void size() {
        Assertions.assertEquals((int)0, (int)Util.size(null));
        Assertions.assertEquals((int)4, (int)Util.size((String)"test"));
        Assertions.assertEquals((int)2, (int)Util.size((String)"\u00a9"));
        Assertions.assertEquals((int)4, (int)Util.size((String)"\ud83d\ude00"));
        Assertions.assertEquals((int)1, (int)Util.size((String)"a"));
    }

    @Test
    void trimSize() {
        Assertions.assertEquals((Object)"test", (Object)Util.trimSize((String)"test", (int)4));
        Assertions.assertEquals((Object)"tes", (Object)Util.trimSize((String)"test", (int)3));
        Assertions.assertEquals((Object)"t", (Object)Util.trimSize((String)"test", (int)1));
        Assertions.assertEquals((Object)"test", (Object)Util.trimSize((String)"test", (int)10));
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            String string = Util.trimSize((String)"test", (int)0);
        });
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            String string = Util.trimSize((String)"test", (int)-1);
        });
        Assertions.assertNull((Object)Util.trimSize(null, (int)10));
        Assertions.assertEquals((Object)"\u00a9", (Object)Util.trimSize((String)"\u00a9", (int)2));
    }

    @Test
    void removeTime() {
        Timestamp ts = Timestamp.valueOf("2023-10-27 10:30:00");
        Timestamp expected = Timestamp.valueOf("2023-10-27 00:00:00");
        Assertions.assertEquals((Object)expected, (Object)Util.removeTime((Timestamp)ts));
        ts = Timestamp.valueOf("2023-10-27 00:00:00");
        Assertions.assertEquals((Object)expected, (Object)Util.removeTime((Timestamp)ts));
    }

    @Test
    void setFilenameCorrect() {
        Assertions.assertEquals((Object)"test", (Object)Util.setFilenameCorrect((String)"test"));
        Assertions.assertEquals((Object)"test-test", (Object)Util.setFilenameCorrect((String)"test/test"));
        Assertions.assertEquals((Object)"test-test", (Object)Util.setFilenameCorrect((String)"test:test"));
        Assertions.assertEquals((Object)"test-test", (Object)Util.setFilenameCorrect((String)"test*test"));
        Assertions.assertEquals((Object)"test-test", (Object)Util.setFilenameCorrect((String)"test<test"));
        Assertions.assertEquals((Object)"test-test", (Object)Util.setFilenameCorrect((String)"test>test"));
        Assertions.assertEquals((Object)"test-test", (Object)Util.setFilenameCorrect((String)"test%test"));
        Assertions.assertEquals((Object)"test", (Object)Util.setFilenameCorrect((String)" test "));
        Assertions.assertEquals((Object)"a", (Object)Util.setFilenameCorrect((String)"\u00e0"));
    }

    @Test
    void isUUID() {
        Assertions.assertTrue((boolean)Util.isUUID((String)"123e4567-e89b-12d3-a456-426614174000"));
        Assertions.assertTrue((boolean)Util.isUUID((String)"123E4567-E89B-12D3-A456-426614174000"));
        Assertions.assertFalse((boolean)Util.isUUID((String)"123E4567-E89B-12D3-A456-42661417400"));
        Assertions.assertFalse((boolean)Util.isUUID((String)"123E4567-E89B-12D3-A456-42661417400g"));
        Assertions.assertFalse((boolean)Util.isUUID(null));
    }

    @Test
    void mergePdf_ValidInput_MergesFiles() throws Exception {
        Path tempDir = Files.createTempDirectory("mergePdfTest", new FileAttribute[0]);
        File pdf1 = this.createDummyPdf(tempDir, "pdf1.pdf");
        File pdf2 = this.createDummyPdf(tempDir, "pdf2.pdf");
        File pdf3 = this.createDummyPdf(tempDir, "pdf3.pdf");
        List<File> pdfList = Arrays.asList(pdf1, pdf2, pdf3);
        File mergedPdf = new File(tempDir.toFile(), "merged.pdf");
        Util.mergePdf(pdfList, (File)mergedPdf);
        Assertions.assertTrue((boolean)mergedPdf.exists());
        Assertions.assertTrue((mergedPdf.length() > 0L ? 1 : 0) != 0);
        Files.delete(pdf1.toPath());
        Files.delete(pdf2.toPath());
        Files.delete(pdf3.toPath());
        Files.delete(mergedPdf.toPath());
        Files.delete(tempDir);
    }

    @Test
    void prettifyJSONString() {
        String json = "{ \"name\":\"John\", \"age\":30, \"car\":null }";
        String expected = "{\n  \"name\": \"John\",\n  \"age\": 30,\n  \"car\": null\n}";
        String res = Util.prettifyJSONString((String)json);
        Assertions.assertEquals((Object)expected, (Object)res);
        String json2 = "invalid json";
        Assertions.assertThrows(AdempiereException.class, () -> {
            String string2 = Util.prettifyJSONString((String)json2);
        });
    }

    private File createDummyPdf(Path tempDir, String filename) throws IOException {
        File file = new File(tempDir.toFile(), filename);
        Files.createFile(file.toPath(), new FileAttribute[0]);
        Document document = new Document();
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(file));
            document.open();
            document.add((Element)new Paragraph("This is a dummy PDF file created with openPDF."));
            document.close();
        }
        catch (DocumentException | IOException e) {
            e.printStackTrace();
        }
        return file;
    }
}

