/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.CyclicTimeouts;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.quic.common.QuicConfiguration;
import org.eclipse.jetty.quic.common.QuicConnection;
import org.eclipse.jetty.quic.common.QuicSession;
import org.eclipse.jetty.quic.quiche.QuicheConfig;
import org.eclipse.jetty.quic.quiche.QuicheConnection;
import org.eclipse.jetty.quic.server.ServerQuicConfiguration;
import org.eclipse.jetty.quic.server.ServerQuicSession;
import org.eclipse.jetty.quic.server.internal.SimpleTokenMinter;
import org.eclipse.jetty.quic.server.internal.SimpleTokenValidator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerQuicConnection
extends QuicConnection {
    private static final Logger LOG = LoggerFactory.getLogger(ServerQuicConnection.class);
    private final Map<SocketAddress, InetSocketAddress> remoteSocketAddresses = new ConcurrentHashMap<SocketAddress, InetSocketAddress>();
    private final Connector connector;
    private final ServerQuicConfiguration quicConfiguration;
    private final SessionTimeouts sessionTimeouts;
    private final InetSocketAddress inetLocalAddress;

    public ServerQuicConnection(Connector connector, ServerQuicConfiguration quicConfiguration, EndPoint endPoint) {
        super(connector.getExecutor(), connector.getScheduler(), connector.getByteBufferPool(), endPoint);
        InetSocketAddress inet;
        this.connector = connector;
        this.quicConfiguration = quicConfiguration;
        this.sessionTimeouts = new SessionTimeouts(connector.getScheduler());
        SocketAddress socketAddress = endPoint.getLocalSocketAddress();
        this.inetLocalAddress = socketAddress instanceof InetSocketAddress ? (inet = (InetSocketAddress)socketAddress) : new InetSocketAddress(InetAddress.getLoopbackAddress(), 443);
    }

    public Connector getQuicServerConnector() {
        return this.connector;
    }

    public void onOpen() {
        super.onOpen();
        this.fillInterested();
    }

    private InetSocketAddress toInetSocketAddress(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inet = (InetSocketAddress)socketAddress;
            return inet;
        }
        return this.remoteSocketAddresses.computeIfAbsent(socketAddress, key -> new InetSocketAddress(InetAddress.getLoopbackAddress(), 64147));
    }

    protected QuicSession createSession(SocketAddress remoteAddress, ByteBuffer cipherBuffer) throws IOException {
        InetSocketAddress inetRemote = this.toInetSocketAddress(remoteAddress);
        ByteBufferPool bufferPool = this.getByteBufferPool();
        QuicheConnection quicheConnection = QuicheConnection.tryAccept((QuicheConfig)this.newQuicheConfig(), (QuicheConnection.TokenValidator)new SimpleTokenValidator(inetRemote), (ByteBuffer)cipherBuffer, (SocketAddress)this.inetLocalAddress, (SocketAddress)inetRemote);
        if (quicheConnection == null) {
            RetainableByteBuffer negotiationBuffer = bufferPool.acquire(this.getOutputBufferSize(), true);
            ByteBuffer byteBuffer = negotiationBuffer.getByteBuffer();
            int pos = BufferUtil.flipToFill((ByteBuffer)byteBuffer);
            if (!QuicheConnection.negotiate((QuicheConnection.TokenMinter)new SimpleTokenMinter(inetRemote), (ByteBuffer)cipherBuffer, (ByteBuffer)byteBuffer)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("QUIC connection negotiation failed, dropping packet");
                }
                negotiationBuffer.release();
                return null;
            }
            BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)pos);
            this.write(Callback.from(() -> ((RetainableByteBuffer)negotiationBuffer).release()), remoteAddress, new ByteBuffer[]{byteBuffer});
            if (LOG.isDebugEnabled()) {
                LOG.debug("QUIC connection negotiation packet sent");
            }
            return null;
        }
        ServerQuicSession session = this.newQuicSession(remoteAddress, quicheConnection);
        session.flush();
        return session;
    }

    protected ServerQuicSession newQuicSession(SocketAddress remoteAddress, QuicheConnection quicheConnection) {
        return new ServerQuicSession(this.getExecutor(), this.getScheduler(), this.getByteBufferPool(), quicheConnection, this, remoteAddress, this.getQuicServerConnector());
    }

    public InetSocketAddress getLocalInetSocketAddress() {
        return this.inetLocalAddress;
    }

    protected Runnable process(QuicSession session, SocketAddress remoteAddress, ByteBuffer cipherBuffer) {
        InetSocketAddress inetRemote = this.toInetSocketAddress(remoteAddress);
        return super.process(session, (SocketAddress)inetRemote, cipherBuffer);
    }

    private QuicheConfig newQuicheConfig() {
        SslContextFactory.Server sslContextFactory;
        QuicheConfig quicheConfig = new QuicheConfig();
        Map implConfig = this.quicConfiguration.getImplementationConfiguration();
        Path privateKeyPath = (Path)implConfig.get(QuicConfiguration.PRIVATE_KEY_PEM_PATH_KEY);
        quicheConfig.setPrivKeyPemPath(privateKeyPath.toString());
        Path certificatesPath = (Path)implConfig.get(QuicConfiguration.CERTIFICATE_CHAIN_PEM_PATH_KEY);
        quicheConfig.setCertChainPemPath(certificatesPath.toString());
        Path trustedCertificatesPath = (Path)implConfig.get(QuicConfiguration.TRUSTED_CERTIFICATES_PEM_PATH_KEY);
        if (trustedCertificatesPath != null) {
            quicheConfig.setTrustedCertsPemPath(trustedCertificatesPath.toString());
        }
        quicheConfig.setVerifyPeer(Boolean.valueOf((sslContextFactory = this.quicConfiguration.getSslContextFactory()).getNeedClientAuth() || sslContextFactory.getWantClientAuth()));
        quicheConfig.setMaxIdleTimeout(Long.valueOf(0L));
        quicheConfig.setInitialMaxData(Long.valueOf(this.quicConfiguration.getSessionRecvWindow()));
        quicheConfig.setInitialMaxStreamDataBidiLocal(Long.valueOf(this.quicConfiguration.getBidirectionalStreamRecvWindow()));
        quicheConfig.setInitialMaxStreamDataBidiRemote(Long.valueOf(this.quicConfiguration.getBidirectionalStreamRecvWindow()));
        quicheConfig.setInitialMaxStreamDataUni(Long.valueOf(this.quicConfiguration.getUnidirectionalStreamRecvWindow()));
        quicheConfig.setInitialMaxStreamsUni(Long.valueOf(this.quicConfiguration.getMaxUnidirectionalRemoteStreams()));
        quicheConfig.setInitialMaxStreamsBidi(Long.valueOf(this.quicConfiguration.getMaxBidirectionalRemoteStreams()));
        quicheConfig.setCongestionControl(QuicheConfig.CongestionControl.CUBIC);
        List protocols = this.connector.getProtocols();
        protocols.add(0, "http/0.9");
        quicheConfig.setApplicationProtos((String[])protocols.toArray(String[]::new));
        return quicheConfig;
    }

    public void schedule(ServerQuicSession session) {
        this.sessionTimeouts.schedule(session);
    }

    public boolean onIdleExpired(TimeoutException timeoutException) {
        return false;
    }

    public void outwardClose(QuicSession session, Throwable failure) {
        super.outwardClose(session, failure);
    }

    private class SessionTimeouts
    extends CyclicTimeouts<ServerQuicSession> {
        private SessionTimeouts(Scheduler scheduler) {
            super(scheduler);
        }

        protected Iterator<ServerQuicSession> iterator() {
            return ServerQuicConnection.this.getQuicSessions().stream().map(ServerQuicSession.class::cast).iterator();
        }

        protected boolean onExpired(ServerQuicSession session) {
            session.onIdleTimeout();
            return false;
        }
    }
}

