/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.dbPort;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.Adempiere;
import org.compiere.db.Database;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Util;

public abstract class Convert {
    public static final int REGEX_FLAGS = 34;
    protected Statement m_stmt = null;
    protected String m_conversionError = null;
    protected Exception m_exception = null;
    protected boolean m_verbose = true;
    private static final CLogger log = CLogger.getCLogger(Convert.class);
    private static File fileOr = null;
    private static FileOutputStream fosScriptOr = null;
    private static Writer writerOr = null;
    private static File filePg = null;
    private static FileOutputStream fosScriptPg = null;
    private static Writer writerPg = null;
    private static String[] dontLogTables = new String[]{"AD_ACCESSLOG", "AD_ALERTPROCESSORLOG", "AD_CHANGELOG", "AD_DOCUMENT_ACTION_ACCESS", "AD_FORM_ACCESS", "AD_INFOWINDOW_ACCESS", "AD_ISSUE", "AD_LDAPPROCESSORLOG", "AD_PACKAGE_IMP", "AD_PACKAGE_IMP_BACKUP", "AD_PACKAGE_IMP_DETAIL", "AD_PACKAGE_IMP_INST", "AD_PACKAGE_IMP_PROC", "AD_PINSTANCE", "AD_PINSTANCE_LOG", "AD_PINSTANCE_PARA", "AD_PREFERENCE", "AD_PROCESS_ACCESS", "AD_RECENTITEM", "AD_REPLICATION_LOG", "AD_SCHEDULERLOG", "AD_SESSION", "AD_WINDOW_ACCESS", "AD_WLISTBOX_CUSTOMIZATION", "AD_WORKFLOW_ACCESS", "AD_WORKFLOWPROCESSORLOG", "AD_USERPREFERENCE", "CM_WEBACCESSLOG", "C_ACCTPROCESSORLOG", "K_INDEXLOG", "R_REQUESTPROCESSORLOG", "T_AGING", "T_ALTER_COLUMN", "T_DISTRIBUTIONRUNDETAIL", "T_INVENTORYVALUE", "T_INVOICEGL", "T_REPLENISH", "T_REPORT", "T_REPORTSTATEMENT", "T_SELECTION", "T_SELECTION2", "T_SPOOL", "T_TRANSACTION", "T_TRIALBALANCE"};

    public void setVerbose(boolean verbose) {
        this.m_verbose = verbose;
    }

    public boolean execute(String sqlStatements, Connection conn) {
        if (conn == null) {
            throw new IllegalStateException("Require connection");
        }
        String[] sql = this.convert(sqlStatements);
        this.m_exception = null;
        if (this.m_conversionError != null || sql == null) {
            return false;
        }
        boolean ok = true;
        int i2 = 0;
        String statement = null;
        try {
            if (this.m_stmt == null) {
                this.m_stmt = conn.createStatement();
            }
            i2 = 0;
            while (ok && i2 < sql.length) {
                block25: {
                    statement = sql[i2];
                    if (statement.length() == 0) {
                        if (this.m_verbose && log.isLoggable(Level.FINER)) {
                            log.finer("Skipping empty (" + i2 + ")");
                        }
                    } else {
                        if (this.m_verbose) {
                            if (log.isLoggable(Level.INFO)) {
                                log.info("Executing (" + i2 + ") <<" + statement + ">>");
                            }
                        } else if (log.isLoggable(Level.INFO)) {
                            log.info("Executing " + i2);
                        }
                        try {
                            this.m_stmt.clearWarnings();
                            int no = this.m_stmt.executeUpdate(statement);
                            SQLWarning warn = this.m_stmt.getWarnings();
                            if (warn != null) {
                                if (this.m_verbose) {
                                    if (log.isLoggable(Level.INFO)) {
                                        log.info("- " + String.valueOf(warn));
                                    }
                                } else if (log.isLoggable(Level.INFO)) {
                                    log.info("Executing (" + i2 + ") <<" + statement + ">>");
                                    log.info("- " + String.valueOf(warn));
                                }
                            }
                            if (this.m_verbose && log.isLoggable(Level.FINE)) {
                                log.fine("- ok " + no);
                            }
                        }
                        catch (SQLException ex) {
                            if (!statement.startsWith("DROP ")) {
                                ok = false;
                                this.m_exception = ex;
                            }
                            if (!this.m_verbose && log.isLoggable(Level.INFO)) {
                                log.info("Executing (" + i2 + ") <<" + statement + ">>");
                            }
                            if (!log.isLoggable(Level.INFO)) break block25;
                            log.info("Error executing " + i2 + "/" + sql.length + " = " + String.valueOf(ex));
                        }
                    }
                }
                ++i2;
            }
        }
        catch (SQLException e) {
            this.m_exception = e;
            if (!this.m_verbose && log.isLoggable(Level.INFO)) {
                log.info("Executing (" + i2 + ") <<" + statement + ">>");
            }
            if (log.isLoggable(Level.INFO)) {
                log.info("Error executing " + i2 + "/" + sql.length + " = " + String.valueOf(e));
            }
            return false;
        }
        return ok;
    }

    public Exception getException() {
        return this.m_exception;
    }

    public boolean hasError() {
        return this.m_exception != null || this.m_conversionError != null;
    }

    public String convertAll(String sqlStatements) {
        String[] sql = this.convert(sqlStatements);
        StringBuilder sb = new StringBuilder(sqlStatements.length() + 10);
        int i2 = 0;
        while (i2 < sql.length) {
            sb.append(sql[i2]).append("\n/\n");
            if (this.m_verbose && log.isLoggable(Level.INFO)) {
                log.info("Statement " + i2 + ": " + sql[i2]);
            }
            ++i2;
        }
        return sb.toString();
    }

    public String[] convert(String sqlStatements) {
        this.m_conversionError = null;
        if (sqlStatements == null || sqlStatements.length() == 0) {
            this.m_conversionError = "SQL_Statement is null or has zero length";
            log.info(this.m_conversionError);
            return null;
        }
        return this.convertIt(sqlStatements);
    }

    public String getConversionError() {
        return this.m_conversionError;
    }

    protected String[] convertIt(String sqlStatements) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.convertStatement(sqlStatements));
        String[] sql = new String[result.size()];
        result.toArray(sql);
        return sql;
    }

    protected String cleanUpStatement(String statement) {
        String clean = statement.trim();
        Matcher m = Pattern.compile("\\s+").matcher(clean);
        clean = m.replaceAll(" ");
        clean = clean.trim();
        return clean;
    }

    protected String replaceQuotedStrings(String inputValue, Vector<String> retVars, String nonce) {
        retVars.clear();
        String quoteMarker = "<--QUOTE" + nonce + "-->";
        inputValue = inputValue.replace("''", quoteMarker);
        Pattern p2 = Pattern.compile("'[[^']*]*'");
        Matcher m = p2.matcher(inputValue);
        int i2 = 0;
        StringBuilder retValue = new StringBuilder(inputValue.length());
        while (m.find()) {
            String var = inputValue.substring(m.start(), m.end()).replace(quoteMarker, "''");
            retVars.addElement(var);
            m.appendReplacement(retValue, "<--QS" + i2 + "QS" + nonce + "-->");
            ++i2;
        }
        m.appendTail(retValue);
        return retValue.toString().replace(quoteMarker, "''");
    }

    protected String recoverQuotedStrings(String retValue, Vector<String> retVars, String nonce) {
        int i2 = 0;
        while (i2 < retVars.size()) {
            String replacement = retVars.get(i2);
            replacement = this.escapeQuotedString(replacement);
            retValue = retValue.replace("<--QS" + i2 + "QS" + nonce + "-->", replacement);
            ++i2;
        }
        return retValue;
    }

    protected String escapeQuotedString(String in) {
        return in;
    }

    private String applyConvertMap(String sqlStatement) {
        if (sqlStatement.toUpperCase().indexOf("EXCEPTION WHEN") != -1) {
            String error = "Exception clause needs to be converted: " + sqlStatement;
            if (log.isLoggable(Level.INFO)) {
                log.info(error);
            }
            this.m_conversionError = error;
            return sqlStatement;
        }
        String retValue = sqlStatement;
        Map<String, String> convertMap = this.getConvertMap();
        if (convertMap != null) {
            for (String regex : convertMap.keySet()) {
                String replacement = convertMap.get(regex);
                try {
                    Pattern p2 = Pattern.compile(regex, 34);
                    Matcher m = p2.matcher(retValue);
                    retValue = m.replaceAll(replacement);
                }
                catch (Exception e) {
                    String error = "Error expression: " + regex + " - " + String.valueOf(e);
                    log.warning(error);
                    this.m_conversionError = error;
                }
            }
        }
        return retValue;
    }

    protected String convertWithConvertMap(String sqlStatement) {
        try {
            sqlStatement = this.applyConvertMap(this.cleanUpStatement(sqlStatement));
        }
        catch (RuntimeException e) {
            log.warning(e.getLocalizedMessage());
            this.m_exception = e;
        }
        return sqlStatement;
    }

    protected Map<String, String> getConvertMap() {
        return null;
    }

    protected abstract ArrayList<String> convertStatement(String var1);

    public abstract boolean isOracle();

    public static synchronized void logMigrationScript(String oraStatement, String pgStatement) {
        boolean logMigrationScript = Convert.isLogMigrationScript();
        if (logMigrationScript) {
            if (Convert.dontLog(oraStatement)) {
                return;
            }
            String fileName = null;
            String folderOr = null;
            String folderPg = null;
            String prm_COMMENT = null;
            try {
                if (fosScriptOr == null || fosScriptPg == null) {
                    prm_COMMENT = Env.getContext(Env.getCtx(), "MigrationScriptComment");
                    fileName = Convert.getMigrationScriptFileName(prm_COMMENT);
                    folderOr = Convert.getMigrationScriptFolder("oracle");
                    folderPg = Convert.getMigrationScriptFolder("postgresql");
                    Files.createDirectories(Paths.get(folderOr, new String[0]), new FileAttribute[0]);
                    Files.createDirectories(Paths.get(folderPg, new String[0]), new FileAttribute[0]);
                }
                if (fosScriptOr == null) {
                    fileOr = new File(folderOr + fileName);
                    fosScriptOr = new FileOutputStream(fileOr, true);
                    writerOr = new BufferedWriter(new OutputStreamWriter((OutputStream)fosScriptOr, "UTF8"));
                    writerOr.append("-- ");
                    writerOr.append(prm_COMMENT);
                    writerOr.append("\nSELECT register_migration_script('").append(fileName).append("') FROM dual;\n\n");
                    writerOr.append("SET SQLBLANKLINES ON\nSET DEFINE OFF\n\n");
                }
                Convert.writeLogMigrationScript(writerOr, oraStatement);
                if (pgStatement == null) {
                    Convert convert = Database.getDatabase(Database.DB_POSTGRESQL).getConvert();
                    String[] r = convert.convert(oraStatement);
                    pgStatement = r[0];
                }
                if (fosScriptPg == null) {
                    filePg = new File(folderPg + fileName);
                    fosScriptPg = new FileOutputStream(filePg, true);
                    writerPg = new BufferedWriter(new OutputStreamWriter((OutputStream)fosScriptPg, "UTF8"));
                    writerPg.append("-- ");
                    writerPg.append(prm_COMMENT);
                    writerPg.append("\nSELECT register_migration_script('").append(fileName).append("') FROM dual;\n\n");
                }
                Convert.writeLogMigrationScript(writerPg, pgStatement);
            }
            catch (IOException e) {
                throw new AdempiereException(e);
            }
        }
    }

    public static String getMigrationScriptFileName(String ticketComment) {
        String now = new SimpleDateFormat("yyyyMMddHHmm").format(new Date());
        String pattern = "(IDEMPIERE-[0-9]*)";
        Pattern p2 = Pattern.compile(pattern);
        Matcher m = p2.matcher(ticketComment);
        String ticket = null;
        if (m.find()) {
            ticket = m.group(1);
        }
        if (ticket == null) {
            ticket = "PlaceholderForTicket";
        }
        String fileName = now + "_" + ticket + ".sql";
        return fileName;
    }

    public static String getMigrationScriptFolder(String dbtype) {
        String version = Adempiere.MAIN_VERSION.substring(8);
        String homeScript = Util.isDeveloperMode() ? Adempiere.getAdempiereHome() + File.separator : System.getProperty("java.io.tmpdir") + File.separator;
        return homeScript + "migration" + File.separator + "iD" + version + File.separator + dbtype + File.separator;
    }

    public static boolean isLogMigrationScript() {
        String sysProperty;
        boolean logMigrationScript = false;
        logMigrationScript = Ini.isClient() ? Ini.isPropertyBool("LogMigrationScript") : "y".equalsIgnoreCase(sysProperty = Env.getCtx().getProperty("LogMigrationScript", "N")) || "true".equalsIgnoreCase(sysProperty);
        return logMigrationScript;
    }

    public static boolean isDontLogTable(String tableName) {
        if (Util.isEmpty(tableName)) {
            return false;
        }
        if (tableName.endsWith("_TRL")) {
            return true;
        }
        String[] stringArray = dontLogTables;
        int n = dontLogTables.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            if (t.equalsIgnoreCase(tableName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean dontLog(String statement) {
        String uppStmt = statement.toUpperCase().trim();
        if (uppStmt.startsWith("SELECT ")) {
            return true;
        }
        if (uppStmt.startsWith("UPDATE AD_PROCESS SET STATISTIC_")) {
            return true;
        }
        if (uppStmt.startsWith("UPDATE C_ACCTPROCESSOR SET DATENEXTRUN")) {
            return true;
        }
        if (uppStmt.startsWith("UPDATE R_REQUESTPROCESSOR SET DATELASTRUN")) {
            return true;
        }
        if (uppStmt.startsWith("UPDATE AD_SEQUENCE SET CURRENTNEXT")) {
            return true;
        }
        if (uppStmt.startsWith("DELETE FROM ") && uppStmt.endsWith(" WHERE AD_TABLE_ID=? AND RECORD_ID=?")) {
            return true;
        }
        if (uppStmt.matches("UPDATE .*_TRL SET .*")) {
            return true;
        }
        if (uppStmt.matches("INSERT INTO .*_TRL .*")) {
            return true;
        }
        if (uppStmt.matches("DELETE FROM .*_TRL .*")) {
            return true;
        }
        if (uppStmt.startsWith("INSERT INTO AD_TREENODE ") && uppStmt.contains(" AND T.TREETYPE='TL' AND T.AD_TABLE_ID=")) {
            return true;
        }
        int i2 = 0;
        while (i2 < dontLogTables.length) {
            if (uppStmt.startsWith("INSERT INTO " + dontLogTables[i2] + " ")) {
                return true;
            }
            if (uppStmt.startsWith("DELETE FROM " + dontLogTables[i2] + " ")) {
                return true;
            }
            if (uppStmt.startsWith("DELETE " + dontLogTables[i2] + " ")) {
                return true;
            }
            if (uppStmt.startsWith("UPDATE " + dontLogTables[i2] + " ")) {
                return true;
            }
            if (uppStmt.startsWith("INSERT INTO " + dontLogTables[i2] + "(")) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private static void writeLogMigrationScript(Writer w, String statement) throws IOException {
        SimpleDateFormat format = DisplayType.getDateFormat(16);
        String dateTimeText = format.format(new Timestamp(System.currentTimeMillis()));
        w.append("-- ");
        w.append(dateTimeText);
        w.append("\n");
        w.append(statement);
        w.append("\n;\n\n");
        w.flush();
    }

    public static void closeLogMigrationScript() {
        try {
            if (writerOr != null) {
                writerOr.flush();
                writerOr.close();
                writerOr = null;
            }
            if (writerPg != null) {
                writerPg.flush();
                writerPg.close();
                writerPg = null;
            }
            if (fosScriptOr != null) {
                fosScriptOr.flush();
                fosScriptOr.close();
                fosScriptOr = null;
            }
            if (fosScriptPg != null) {
                fosScriptPg.flush();
                fosScriptPg.close();
                fosScriptPg = null;
            }
            fileOr = null;
            filePg = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getGeneratedMigrationScriptFileName() {
        if (filePg != null) {
            return filePg.getName();
        }
        return null;
    }
}

