/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.ComponentNotFoundException;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.sys.RequestQueue;

public class RequestQueueImpl
implements RequestQueue {
    private static final Logger log = LoggerFactory.getLogger(RequestQueueImpl.class);
    private final List<AuRequest> _requests = new LinkedList<AuRequest>();
    private List<String> _pfreqIds;

    @Override
    public void addPerfRequestId(String requestId) {
        if (this._pfreqIds == null) {
            this._pfreqIds = new LinkedList<String>();
        }
        this._pfreqIds.add(requestId);
    }

    @Override
    public Collection<String> clearPerfRequestIds() {
        List<String> old = this._pfreqIds;
        this._pfreqIds = null;
        return old;
    }

    @Override
    public boolean isEmpty() {
        while (!this._requests.isEmpty()) {
            if (RequestQueueImpl.isObsolete(this._requests.get(0))) {
                this._requests.remove(0);
                continue;
            }
            return false;
        }
        return true;
    }

    private static boolean isObsolete(AuRequest request) {
        Component comp = request.getComponent();
        if (comp != null) {
            Desktop dt = comp.getDesktop();
            return dt != null && dt != request.getDesktop();
        }
        return false;
    }

    @Override
    public AuRequest nextRequest() {
        while (!this._requests.isEmpty()) {
            AuRequest request = this._requests.remove(0);
            if (RequestQueueImpl.isObsolete(request)) continue;
            return request;
        }
        return null;
    }

    @Override
    public void addRequests(Collection<AuRequest> requests) {
        for (AuRequest request : requests) {
            try {
                request.activate();
                if (RequestQueueImpl.isObsolete(request)) continue;
                this.addRequest(request);
            }
            catch (ComponentNotFoundException ex) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Ignore request: " + ex.getMessage());
            }
        }
    }

    private void addRequest(AuRequest request) {
        int last;
        AuRequest req2;
        int last2 = this._requests.size() - 1;
        if (last2 < 0) {
            this._requests.add(request);
            return;
        }
        AuRequest req22 = this._requests.get(last2);
        if ((req22.getOptions() & 0x1000) != 0) {
            this._requests.remove(last2);
            if (last2 == 0) {
                this._requests.add(request);
                return;
            }
        }
        String name = request.getCommand();
        int opts = request.getOptions();
        if ((opts & 0x2000) != 0) {
            String uuid = this.getUuid(request);
            Iterator<AuRequest> it = this._requests.iterator();
            while (it.hasNext()) {
                AuRequest req23 = it.next();
                if (!req23.getCommand().equals(name) || !Objects.equals((Object)this.getUuid(req23), (Object)uuid)) continue;
                it.remove();
                break;
            }
        } else if ((opts & 0x4000) != 0 && (req2 = this._requests.get(last = this._requests.size() - 1)).getCommand().equals(name) && Objects.equals((Object)this.getUuid(req2), (Object)this.getUuid(request))) {
            this._requests.remove(last);
        }
        this._requests.add(request);
    }

    private String getUuid(AuRequest request) {
        Component comp = request.getComponent();
        if (comp != null) {
            return comp.getUuid();
        }
        Page page = request.getPage();
        if (page != null) {
            return page.getUuid();
        }
        return null;
    }
}

