/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util.media;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import org.zkoss.io.Files;
import org.zkoss.io.NullInputStream;
import org.zkoss.io.NullReader;
import org.zkoss.io.RepeatableInputStream;
import org.zkoss.io.RepeatableReader;
import org.zkoss.lang.Library;
import org.zkoss.lang.SystemException;
import org.zkoss.util.media.ContentTypes;
import org.zkoss.util.media.Media;

public class AMedia
implements Media,
Serializable {
    protected static final InputStream DYNAMIC_STREAM = new NullInputStream();
    protected static final Reader DYNAMIC_READER = new NullReader();
    private byte[] _bindata;
    private String _strdata;
    protected transient InputStream _isdata;
    protected transient Reader _rddata;
    private String _ctype;
    private String _format;
    private String _name;
    private boolean _cntDisposition = true;

    public AMedia(String name, String format, String ctype, byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data");
        }
        this._bindata = data;
        this.setup(name, format, ctype);
    }

    public AMedia(String name, String format, String ctype, String data) {
        if (data == null) {
            throw new IllegalArgumentException("data");
        }
        this._strdata = data;
        this.setup(name, format, ctype);
    }

    public AMedia(String name, String format, String ctype, InputStream data) {
        if (data == null) {
            throw new IllegalArgumentException("data");
        }
        this._isdata = data;
        this.setup(name, format, ctype);
    }

    public AMedia(String name, String format, String ctype, Reader data) {
        if (data == null) {
            throw new IllegalArgumentException("data");
        }
        this._rddata = data;
        this.setup(name, format, ctype);
    }

    public AMedia(String name, String format, String ctype, File file, boolean binary) throws FileNotFoundException {
        this(name, format, ctype, file, binary ? null : "UTF-8");
    }

    public AMedia(String name, String format, String ctype, File file, String charset) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("file");
        }
        if (charset == null) {
            this._isdata = RepeatableInputStream.getInstance(file);
        } else {
            this._rddata = RepeatableReader.getInstance(file, charset);
        }
        if (name == null) {
            name = file.getName();
        }
        this.setup(name, format, ctype);
    }

    public AMedia(File file, String ctype, String charset) throws FileNotFoundException {
        this(null, null, ctype, file, charset);
    }

    public AMedia(String name, String format, String ctype, URL url, String charset) throws FileNotFoundException {
        int j;
        if (url == null) {
            throw new IllegalArgumentException("url");
        }
        if (charset == null) {
            this._isdata = RepeatableInputStream.getInstance(url);
        } else {
            this._rddata = RepeatableReader.getInstance(url, charset);
        }
        if (name == null && (j = (name = url.toExternalForm()).lastIndexOf(47)) >= 0 && j < name.length() - 1) {
            name = name.substring(j + 1);
        }
        this.setup(name, format, ctype);
    }

    public AMedia(URL url, String ctype, String charset) throws FileNotFoundException {
        this(null, null, ctype, url, charset);
    }

    private void setup(String name, String format, String ctype) {
        int j;
        if (ctype != null && !Boolean.parseBoolean(Library.getProperty("org.zkoss.zul.Filedownload.contentTypeAsIs")) && (j = ctype.indexOf(59)) >= 0) {
            ctype = ctype.substring(0, j);
        }
        if (ctype != null && format == null) {
            format = ContentTypes.getFormat(ctype);
        } else if (ctype == null && format != null) {
            ctype = ContentTypes.getContentType(format);
        }
        if (name != null && format == null && (j = name.lastIndexOf(46)) >= 0) {
            format = name.substring(j + 1);
            if (ctype == null) {
                ctype = ContentTypes.getContentType(format);
            }
        }
        this._name = name;
        this._format = format;
        this._ctype = ctype;
    }

    public void setContentDisposition(boolean cntDisposition) {
        this._cntDisposition = cntDisposition;
    }

    @Override
    public boolean isBinary() {
        return this._bindata != null || this._isdata != null;
    }

    @Override
    public boolean inMemory() {
        return this._bindata != null || this._strdata != null;
    }

    @Override
    public byte[] getByteData() {
        InputStream is;
        if (this._bindata != null) {
            return this._bindata;
        }
        InputStream inputStream = is = this._isdata == DYNAMIC_STREAM ? this.getStreamData() : this._isdata;
        if (is != null) {
            try {
                byte[] bs = Files.readAll(is);
                is.close();
                return bs;
            }
            catch (IOException ex) {
                throw SystemException.Aide.wrap(ex);
            }
        }
        throw this.newIllegalStateException();
    }

    @Override
    public String getStringData() {
        Reader reader;
        if (this._strdata != null) {
            return this._strdata;
        }
        Reader reader2 = reader = this._rddata == DYNAMIC_READER ? this.getReaderData() : this._rddata;
        if (reader != null) {
            try {
                String ct = Files.readAll(reader).toString();
                reader.close();
                return ct;
            }
            catch (IOException ex) {
                throw SystemException.Aide.wrap(ex);
            }
        }
        throw this.newIllegalStateException();
    }

    @Override
    public InputStream getStreamData() {
        if (this._isdata != null) {
            return this._isdata;
        }
        if (this._bindata != null) {
            return new ByteArrayInputStream(this._bindata);
        }
        throw this.newIllegalStateException();
    }

    @Override
    public Reader getReaderData() {
        if (this._rddata != null) {
            return this._rddata;
        }
        if (this._strdata != null) {
            return new StringReader(this._strdata);
        }
        throw this.newIllegalStateException();
    }

    private IllegalStateException newIllegalStateException() {
        return new IllegalStateException("Use get" + (this._bindata != null ? "Byte" : (this._strdata != null ? "String" : (this._isdata != null ? "Stream" : "Reader"))) + "Data() instead");
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getFormat() {
        return this._format;
    }

    @Override
    public String getContentType() {
        return this._ctype;
    }

    @Override
    public boolean isContentDisposition() {
        return this._cntDisposition;
    }

    public String toString() {
        return this._name != null ? this._name : "Media " + this._format;
    }
}

