/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zsoup.parser;

import org.zkoss.zsoup.helper.DescendableLinkedList;
import org.zkoss.zsoup.helper.Validate;
import org.zkoss.zsoup.nodes.Document;
import org.zkoss.zsoup.nodes.Element;
import org.zkoss.zsoup.parser.CharacterReader;
import org.zkoss.zsoup.parser.ParseErrorList;
import org.zkoss.zsoup.parser.Token;
import org.zkoss.zsoup.parser.Tokeniser;

abstract class TreeBuilder {
    CharacterReader reader;
    Tokeniser tokeniser;
    protected Document doc;
    protected DescendableLinkedList<Element> stack;
    protected String baseUri;
    protected Token currentToken;
    protected ParseErrorList errors;

    TreeBuilder() {
    }

    protected void initialiseParse(String input, String baseUri, ParseErrorList errors) {
        Validate.notNull(input, "String input must not be null");
        Validate.notNull(baseUri, "BaseURI must not be null");
        this.doc = new Document(baseUri);
        this.reader = new CharacterReader(input);
        this.errors = errors;
        this.tokeniser = new Tokeniser(this.reader, errors);
        this.stack = new DescendableLinkedList();
        this.baseUri = baseUri;
    }

    Document parse(String input, String baseUri) {
        return this.parse(input, baseUri, ParseErrorList.noTracking());
    }

    Document parse(String input, String baseUri, ParseErrorList errors) {
        this.initialiseParse(input, baseUri, errors);
        this.runParser();
        return this.doc;
    }

    protected void runParser() {
        Token token;
        do {
            token = this.tokeniser.read();
            this.process(token);
        } while (token.type != Token.TokenType.EOF);
    }

    protected abstract boolean process(Token var1);

    protected Element currentElement() {
        return (Element)this.stack.getLast();
    }
}

