/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public interface ILog {
    public void addLogListener(ILogListener var1);

    public Bundle getBundle();

    public void log(IStatus var1);

    public void removeLogListener(ILogListener var1);

    default public void info(String message) {
        this.log((IStatus)new Status(1, this.getBundle().getSymbolicName(), message));
    }

    default public void info(String message, Throwable throwable) {
        this.log((IStatus)new Status(1, this.getBundle().getSymbolicName(), message, throwable));
    }

    default public void warn(String message) {
        this.log((IStatus)new Status(2, this.getBundle().getSymbolicName(), message));
    }

    default public void warn(String message, Throwable throwable) {
        this.log((IStatus)new Status(2, this.getBundle().getSymbolicName(), message, throwable));
    }

    default public void error(String message) {
        this.log((IStatus)new Status(4, this.getBundle().getSymbolicName(), message));
    }

    default public void error(String message, Throwable throwable) {
        this.log((IStatus)new Status(4, this.getBundle().getSymbolicName(), message, throwable));
    }

    public static ILog of(Bundle bundle) {
        return InternalPlatform.getDefault().getLog(bundle);
    }

    public static ILog of(Class<?> clazz) {
        Bundle bundle = FrameworkUtil.getBundle(clazz);
        return InternalPlatform.getDefault().getLog(bundle);
    }

    public static ILog get() {
        try {
            return ILog.of(InternalPlatform.STACK_WALKER.getCallerClass());
        }
        catch (IllegalCallerException illegalCallerException) {
            return ILog.of(ILog.class);
        }
    }
}

