/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.au.http;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload2.core.RequestContext;

class ServletRequestContext
implements RequestContext {
    private final HttpServletRequest _request;

    public ServletRequestContext(HttpServletRequest request) {
        this._request = request;
    }

    public String getCharacterEncoding() {
        return this._request.getCharacterEncoding();
    }

    public String getContentType() {
        return this._request.getContentType();
    }

    public long getContentLength() {
        long size;
        try {
            size = Long.parseLong(this._request.getHeader("Content-length"));
        }
        catch (NumberFormatException e) {
            size = this._request.getContentLength();
        }
        return size;
    }

    public InputStream getInputStream() throws IOException {
        return this._request.getInputStream();
    }

    public String toString() {
        return String.format("ContentLength=%s, ContentType=%s", this.getContentLength(), this.getContentType());
    }
}

