/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.event.PagingEvent;
import org.zkoss.zul.ext.Paginal;
import org.zkoss.zul.impl.XulElement;

public class Paging
extends XulElement
implements Paginal {
    private int _pgsz = 20;
    private int _ttsz = 0;
    private int _npg = 1;
    private int _actpg = 0;
    private int _pginc = 10;
    private boolean _autohide;
    private boolean _detailed;
    private boolean _disabled;

    public Paging() {
    }

    public Paging(int totalsz, int pagesz) {
        this();
        this.setTotalSize(totalsz);
        this.setPageSize(pagesz);
    }

    @Override
    public int getPageSize() {
        return this._pgsz;
    }

    @Override
    public void setPageSize(int size) throws WrongValueException {
        if (size <= 0) {
            throw new WrongValueException("positive only");
        }
        if (this._pgsz != size) {
            this._pgsz = size;
            this.smartUpdate("pageSize", this._pgsz);
            this.updatePageNum();
            Events.postEvent((int)10001, (Event)new PagingEvent("onPagingImpl", (Component)this, this._actpg));
        }
    }

    @Override
    public int getTotalSize() {
        return this._ttsz;
    }

    @Override
    public void setTotalSize(int size) throws WrongValueException {
        if (size < 0) {
            throw new WrongValueException("non-negative only");
        }
        if (this._ttsz != size) {
            this._ttsz = size;
            this.smartUpdate("totalSize", this._ttsz);
            this.updatePageNum();
        }
    }

    private void updatePageNum() {
        int v = (this._ttsz - 1) / this._pgsz + 1;
        if (v == 0) {
            v = 1;
        }
        if (v != this._npg) {
            this._npg = v;
            this.smartUpdate("pageCount", this._npg);
            if (this._actpg >= this._npg) {
                this._actpg = this._npg - 1;
                this.smartUpdate("activePage", this._actpg);
            }
        }
    }

    @Override
    public int getPageCount() {
        return this._npg;
    }

    @Override
    public int getActivePage() {
        return this._actpg;
    }

    @Override
    public void setActivePage(int pg) throws WrongValueException {
        if (pg >= this._npg || pg < 0) {
            throw new WrongValueException("Unable to set active page to " + pg + " since only " + this._npg + " pages");
        }
        if (this._actpg != pg) {
            this._actpg = pg;
            this.smartUpdate("activePage", pg);
            Events.postEvent((Event)new PagingEvent("onPagingImpl", (Component)this, this._actpg));
        }
    }

    @Override
    public int getPageIncrement() {
        return this._pginc;
    }

    @Override
    public void setPageIncrement(int pginc) throws WrongValueException {
        if (pginc <= 0) {
            throw new WrongValueException("Nonpositive is not allowed: " + pginc);
        }
        if (this._pginc != pginc) {
            this._pginc = pginc;
            this.smartUpdate("pageIncrement", pginc);
        }
    }

    @Override
    public boolean isDetailed() {
        return this._detailed;
    }

    @Override
    public void setDetailed(boolean detailed) {
        if (this._detailed != detailed) {
            this._detailed = detailed;
            this.smartUpdate("detailed", detailed);
        }
    }

    @Override
    public boolean isAutohide() {
        return this._autohide;
    }

    @Override
    public void setAutohide(boolean autohide) {
        if (this._autohide != autohide) {
            this._autohide = autohide;
            this.smartUpdate("autohide", autohide);
        }
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this._ttsz != 0) {
            renderer.render("totalSize", this._ttsz);
        }
        if (this._pgsz != 20) {
            renderer.render("pageSize", this._pgsz);
        }
        if (this._actpg != 0) {
            renderer.render("activePage", this._actpg);
        }
        if (this._npg != 1) {
            renderer.render("pageCount", this._npg);
        }
        if (this._pginc != 10) {
            renderer.render("pageIncrement", this._pginc);
        }
        this.render(renderer, "detailed", this._detailed);
        this.render(renderer, "autohide", this.isAutohide());
        this.render(renderer, "disabled", this._disabled);
    }

    public String getZclass() {
        return this._zclass == null ? "z-paging" : this._zclass;
    }

    public boolean isVisible() {
        return super.isVisible() && (this._npg > 1 || !this._autohide);
    }

    protected boolean isChildable() {
        return false;
    }

    public void service(AuRequest request, boolean everError) {
        String name = request.getCommand();
        if (name.equals("onPaging")) {
            PagingEvent evt = PagingEvent.getPagingEvent(request);
            this.setActivePage(evt.getActivePage());
            Events.postEvent((Event)evt);
        } else {
            super.service(request, everError);
        }
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.smartUpdate("disabled", this._disabled);
        }
    }

    static {
        Paging.addClientEvent(Paging.class, (String)"onPaging", (int)1);
    }
}

