/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.proxy;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.init.ZKBinderPhaseListeners;
import org.zkoss.bind.proxy.ProxyTargetHandler;
import org.zkoss.zk.ui.util.AggregationListener;

public class ZKProxyTargetHandlers
implements AggregationListener {
    private static final Logger _log = LoggerFactory.getLogger(ZKBinderPhaseListeners.class);
    private static Map<String, ProxyTargetHandler> _handlers = new LinkedHashMap<String, ProxyTargetHandler>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHandled(Class<?> klass) {
        if (ProxyTargetHandler.class.isAssignableFrom(klass)) {
            try {
                Map<String, ProxyTargetHandler> map = _handlers;
                synchronized (map) {
                    if (!_handlers.containsKey(klass.getName())) {
                        _handlers.put(klass.getName(), (ProxyTargetHandler)klass.newInstance());
                    }
                }
            }
            catch (Exception e) {
                _log.error("Error when initial proxy target handler:" + klass, (Throwable)e);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ProxyTargetHandler> getSystemProxyTargetHandlers() {
        Collection<ProxyTargetHandler> values;
        Map<String, ProxyTargetHandler> map = _handlers;
        synchronized (map) {
            values = _handlers.values();
        }
        return new LinkedList<ProxyTargetHandler>(values);
    }
}

