/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.sys;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlShadowElement;
import org.zkoss.zk.ui.ShadowElement;
import org.zkoss.zk.ui.ShadowElementCtrl;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.ComponentCtrl;

public class ShadowElementsCtrl {
    private static final ThreadLocal<Object> _shadowInfo = new ThreadLocal();
    private static final ThreadLocal<Map<Component, Object>> _distributedIndexInfo = ThreadLocal.withInitial(HashMap::new);

    public static final void setCurrentInfo(Object shadowInfo) {
        if (shadowInfo != null) {
            _shadowInfo.set(shadowInfo);
        } else {
            _shadowInfo.remove();
        }
    }

    public static final Object getCurrentInfo() {
        return _shadowInfo.get();
    }

    public static final void setDistributedIndexInfo(Component host, Object indexMapInfo) {
        Map<Component, Object> objectMap = _distributedIndexInfo.get();
        if (indexMapInfo == null) {
            if (objectMap != null) {
                objectMap.remove(host);
                if (objectMap.isEmpty()) {
                    _distributedIndexInfo.remove();
                }
            } else {
                _distributedIndexInfo.remove();
            }
        } else {
            if (objectMap == null) {
                objectMap = new HashMap<Component, Object>();
                _distributedIndexInfo.set(objectMap);
            }
            objectMap.put(host, indexMapInfo);
        }
    }

    public static final Object getDistributedIndexInfo(Component host) {
        Map<Component, Object> objectMap = _distributedIndexInfo.get();
        if (objectMap == null) {
            return null;
        }
        return objectMap.get(host);
    }

    public static final Component[] filterOutShadows(Component[] shadows) {
        if (shadows == null || shadows.length == 0) {
            return shadows;
        }
        int length = shadows.length;
        ShadowElementsCtrl.doBindChildrenInFilter(shadows);
        if (length == 1) {
            if (shadows[0] instanceof ShadowElement) {
                ShadowElement se = (ShadowElement)((Object)shadows[0]);
                return se.getDistributedChildren().toArray(new Component[0]);
            }
        } else {
            ComponentCtrl pCtrl;
            Component parent = null;
            if (!(shadows[0] instanceof ShadowElementCtrl)) {
                parent = shadows[0].getParent();
            }
            if (parent instanceof ComponentCtrl && (pCtrl = (ComponentCtrl)((Object)parent)).getShadowRoots().isEmpty()) {
                return shadows;
            }
            LinkedList<Object> list = new LinkedList<Object>();
            for (Component comp : shadows) {
                if (comp instanceof HtmlShadowElement) {
                    HtmlShadowElement hse = (HtmlShadowElement)comp;
                    list.addAll(hse.getDistributedChildren());
                    continue;
                }
                list.add(comp);
            }
            return list.toArray(new Component[0]);
        }
        return shadows;
    }

    private static void doBindChildrenInFilter(Component[] shadows) {
        for (Component shadow : shadows) {
            ShadowElement se;
            if (!(shadow instanceof ShadowElement) || !(se = (ShadowElement)((Object)shadow)).getDistributedChildren().isEmpty() || !((ShadowElementCtrl)((Object)se)).isDynamicValue()) continue;
            List<Component> children = shadow.getChildren();
            if (children.size() == 0) {
                Events.sendEvent(new Event("onBindInit", (Component)((Object)se)));
                Events.sendEvent(new Event("onBindingReady", (Component)((Object)se)));
                children = shadow.getChildren();
            }
            if (children.size() <= 0) continue;
            ShadowElementsCtrl.doBindChildrenInFilter(children.toArray(new Component[children.size()]));
        }
    }
}

